/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDescriptionCreator;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.mail.api.MailAttachmentUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AddAttachmentsServiceMethod {
    public AttachmentDescription[] addAttachments(AttachmentService attachmentService, AttachmentOwnerType attachmentType, int ownerId, int stepId, LargeContent[] attachments) throws IOException {
        try {
            ArrayList<AttachmentDescription> descList = new ArrayList<AttachmentDescription>();
            for (LargeContent data : attachments) {
                List<String> existingFileNames = attachmentService.getFileNamesFromAttachments(attachmentType, ownerId, stepId);
                String normalizedFileName = MailAttachmentUtilities.normalisiertenFileName((String)data.getName());
                String uniqueFileName = AttachmentFilePathBuilder.getUniqueFileName(normalizedFileName, existingFileNames);
                AttachmentService.Answer answer = attachmentService.createAttachment(attachmentType, ownerId, stepId, uniqueFileName, data);
                AttachmentDescription description = AttachmentDescriptionCreator.createAttDescription(attachmentType, uniqueFileName, ownerId, stepId, answer.getAttachmentLastModified(), answer.getFile());
                descList.add(description);
            }
            return descList.toArray(new AttachmentDescription[descList.size()]);
        }
        catch (Exception ex) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATA_ERROR));
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }
}

