/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared;

import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.lib.util.EncodingFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttachmentFilePathBuilder {
    public static String getOldAttachmentFilePath(int ticketId, int reaStepId, String fileDisplayName) {
        return AttachmentFilePathBuilder.getDirectoryPrefix(ticketId) + "/" + AttachmentFilePathBuilder.getOldAttachmentFileName(ticketId, reaStepId, fileDisplayName);
    }

    public static String getDirectoryPrefix(int ticketId) throws IllegalArgumentException {
        if (ticketId < 0) {
            throw new IllegalArgumentException("ticketId must not be negative");
        }
        return "/Attachments_" + ticketId / 1000 * 1000;
    }

    public static String getOldAttachmentFileName(int ticketId, int reaStepId, String fileDisplayName) throws IllegalArgumentException {
        if (ticketId < 0) {
            throw new IllegalArgumentException("ticketId must not be negative");
        }
        if (fileDisplayName == null) {
            throw new IllegalArgumentException("fileDisplayName must not be null");
        }
        if (fileDisplayName.trim().isEmpty()) {
            throw new IllegalArgumentException("fileDisplayName must not be empty and must not contain only whitespaces");
        }
        Object reaStepPartOfPrefix = reaStepId == -1 ? "_" : "_ReaID" + reaStepId + "_";
        return ticketId + (String)reaStepPartOfPrefix + fileDisplayName;
    }

    public static String getUniqueFileName(String fileName, List<String> existingFileNames) throws IllegalArgumentException {
        boolean isNameReserved;
        if (fileName == null) {
            throw new IllegalArgumentException("fileName must not be null");
        }
        if (existingFileNames == null) {
            throw new IllegalArgumentException("list of existing file names must not be null");
        }
        String nameWithoutExtension = fileName;
        String extension = "";
        int lastDotPosition = fileName.lastIndexOf(".");
        if (lastDotPosition >= 0) {
            nameWithoutExtension = fileName.substring(0, lastDotPosition);
            extension = fileName.substring(lastDotPosition);
        }
        Object currentName = fileName;
        int index = 1;
        while (isNameReserved = AttachmentFilePathBuilder.containsIgnoreCase(existingFileNames, (String)currentName)) {
            currentName = nameWithoutExtension + "(" + index + ")" + extension;
            ++index;
        }
        return currentName;
    }

    private static boolean containsIgnoreCase(List<String> list, String elementToBeFound) {
        for (String element : list) {
            if (!element.equalsIgnoreCase(elementToBeFound)) continue;
            return true;
        }
        return false;
    }

    public static AttachmentKey convertRestfulPathToKey(String path) {
        String fileName;
        Integer id;
        AttachmentOwnerType attachmentType;
        Integer additionalId;
        Integer stepId;
        block10: {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            if (path.startsWith("Attachments/")) {
                path = path.substring("Attachments".length());
            }
            if (path.startsWith("/Attachments/")) {
                path = path.substring("/Attachments".length());
            }
            ArrayList<String> parts = new ArrayList<String>();
            for (String part : path.split("/")) {
                if (part.isEmpty()) continue;
                parts.add(part);
            }
            stepId = -1;
            additionalId = -1;
            try {
                if (parts.size() < 3) {
                    throw new IllegalArgumentException();
                }
                if (parts.size() == 3) {
                    attachmentType = AttachmentOwnerType.getTypeForSubContext((String)parts.get(0));
                    id = Integer.valueOf((String)parts.get(1));
                    fileName = (String)parts.get(2);
                    break block10;
                }
                if (parts.size() == 4) {
                    attachmentType = AttachmentOwnerType.getTypeForSubContext((String)parts.get(0));
                    id = Integer.valueOf((String)parts.get(1));
                    stepId = Integer.valueOf((String)parts.get(2));
                    fileName = (String)parts.get(3);
                    break block10;
                }
                if (parts.size() == 5) {
                    attachmentType = AttachmentOwnerType.getTypeForSubContext((String)parts.get(0));
                    id = Integer.valueOf((String)parts.get(1));
                    stepId = Integer.valueOf((String)parts.get(2));
                    additionalId = Integer.valueOf((String)parts.get(3));
                    fileName = (String)parts.get(4);
                    break block10;
                }
                throw new IllegalArgumentException();
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return new AttachmentKey(attachmentType, id, stepId, additionalId, fileName);
    }

    public static AttachmentKey convertOldPathToKey(String oldAttachmentPathOrName, AttachmentOwnerType attachmentType) {
        Integer stepId;
        Integer ticketId;
        String fileDisplayName = null;
        if (oldAttachmentPathOrName.contains("/")) {
            oldAttachmentPathOrName = oldAttachmentPathOrName.substring(oldAttachmentPathOrName.lastIndexOf(47) + 1);
        }
        if (oldAttachmentPathOrName.contains("\\")) {
            oldAttachmentPathOrName = oldAttachmentPathOrName.substring(oldAttachmentPathOrName.lastIndexOf(92) + 1);
        }
        Pattern pFull = Pattern.compile("(\\d+)_ReaID(\\d+)_.*", 32);
        Pattern pNoRea = Pattern.compile("(\\d+)_.*", 32);
        if (pFull.matcher(oldAttachmentPathOrName).matches()) {
            Matcher m = pFull.matcher(oldAttachmentPathOrName);
            m.find();
            try {
                ticketId = Integer.valueOf(m.group(1));
                stepId = Integer.valueOf(m.group(2));
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException(exc);
            }
            int nameIndex = m.end(2) + 1;
            fileDisplayName = oldAttachmentPathOrName.substring(nameIndex);
        } else if (pNoRea.matcher(oldAttachmentPathOrName).matches()) {
            Matcher m = pNoRea.matcher(oldAttachmentPathOrName);
            m.find();
            try {
                stepId = -1;
                ticketId = Integer.valueOf(m.group(1));
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException(exc);
            }
            int nameIndex = m.end(1) + 1;
            fileDisplayName = oldAttachmentPathOrName.substring(nameIndex);
        } else {
            throw new IllegalArgumentException("Given path can not be recognized as old Path: " + oldAttachmentPathOrName);
        }
        return new AttachmentKey(attachmentType, ticketId, stepId, -1, fileDisplayName);
    }

    public static boolean isRestfulPath(String path) {
        for (AttachmentOwnerType type : AttachmentOwnerType.values()) {
            if (!AttachmentFilePathBuilder.isRestfulPathOfGivenAttachmentType(path, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRestfulPathOfGivenAttachmentType(String path, AttachmentOwnerType type) {
        String regex = "(Attachments/)?" + type.getAttachmentSubContext() + "(/\\d+){1,3}/[^/]+";
        return path.matches(regex);
    }

    public static String getRestfulPath(AttachmentKey key) {
        Integer ownerId = key.getOwnerId();
        Integer stepId = key.getStepId();
        Integer additionalId = key.getAdditionalId();
        String fileName = key.getFileName();
        String attachmentSubContext = key.getType().getAttachmentSubContext();
        StringBuilder sb = new StringBuilder("Attachments/" + attachmentSubContext + "/" + ownerId);
        if (stepId != null && stepId > 0) {
            sb.append("/" + stepId);
        }
        if (additionalId != null && additionalId > 0) {
            sb.append("/" + additionalId);
        }
        sb.append("/" + fileName);
        return sb.toString();
    }

    public static String getRestfulPathForClient(AttachmentKey key) {
        return EncodingFunctions.encodeUrlPath((String)AttachmentFilePathBuilder.getRestfulPath(key));
    }
}

