/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.data.TicketAttachmentsDuplicatorExtension;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDuplicator;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.mail.api.MailAttachmentUtilities;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AttachmentDuplicatorImpl
implements AttachmentDuplicator {
    private AttachmentDAO attachmentDAO;

    public AttachmentDuplicatorImpl(AttachmentDAO attachmentDAO) {
        ValidationUtils.throwExceptionIfNull(attachmentDAO, "attachmentDAO");
        this.attachmentDAO = attachmentDAO;
    }

    @Override
    public List<AttachmentKey> duplicateAttachments(List<AttachmentKey> attachmentsToDuplicate, AttachmentOwnerType targetType, int targetOwnerId, int targetStepId, int targetAdditionalID) throws SQLException {
        ValidationUtils.throwExceptionIfNull(attachmentsToDuplicate, "attachmentsToDuplicate");
        ValidationUtils.throwExceptionIfListContainsNull(attachmentsToDuplicate, "attachmentsToDuplicate");
        ValidationUtils.throwExceptionIfNull(targetType, "targetType");
        ValidationUtils.throwExceptionIfNegative(targetOwnerId, "targetOwnerId");
        ArrayList<String> attFileNames = new ArrayList<String>();
        ArrayList<AttachmentKey> duplicates = new ArrayList<AttachmentKey>(attachmentsToDuplicate.size());
        for (AttachmentKey attKey : attachmentsToDuplicate) {
            AttachmentRow attRow = this.attachmentDAO.getAttachment(attKey);
            if (attRow == null) continue;
            List<String> existingFileNames = this.attachmentDAO.getFileNamesFromAttachments(targetType, targetOwnerId, targetStepId);
            String normalizedFileName = MailAttachmentUtilities.normalisiertenFileName((String)attRow.getFileName());
            String uniqueFileName = AttachmentFilePathBuilder.getUniqueFileName(normalizedFileName, existingFileNames);
            AttachmentKey key = new AttachmentKey(targetType, targetOwnerId, targetStepId, targetAdditionalID, uniqueFileName);
            AttachmentRow duplicatedAttachment = new AttachmentRow(key, attRow.getChecksum(), attRow.getFileLength(), attRow.isEmbedded(), System.currentTimeMillis());
            this.attachmentDAO.createAttachment(duplicatedAttachment);
            attFileNames.add(uniqueFileName);
            duplicates.add(key);
        }
        if (AttachmentOwnerType.TicketAttachment.equals(targetType) && !attFileNames.isEmpty()) {
            AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(targetOwnerId, Collections.emptyList(), attFileNames);
        }
        return duplicates;
    }

    public TicketAttachmentsDuplicatorExtension.AttachmentDuplicationResult duplicateAttachments(AttachmentOwnerType type, int originalOwnerId, int originalStepId, int duplicateOwnerId, int duplicateOwnerStepId) {
        ValidationUtils.throwExceptionIfNull(type, "attachment type");
        ValidationUtils.throwExceptionIfNegative(originalOwnerId, "originalOwnerId");
        ValidationUtils.throwExceptionIfNegative(duplicateOwnerId, "duplicateOwnerId");
        if (originalOwnerId == duplicateOwnerId) {
            throw new IllegalArgumentException("originalOwnerId must not be equal to duplicateOwnerId");
        }
        boolean atLeastOneAttDuplicated = false;
        boolean atLeastOneNonEmbeddedAttDuplicated = false;
        List<AttachmentRow> allAttachmentsToDuplicate = this.getAllAttachments(type, originalOwnerId, originalStepId);
        for (AttachmentRow attachment : allAttachmentsToDuplicate) {
            try {
                AttachmentRow duplicatedAttachment = this.createDuplicateForNewOwnerWithCurrentTimeSetAsLastModified(duplicateOwnerId, duplicateOwnerStepId, attachment);
                this.attachmentDAO.createAttachment(duplicatedAttachment);
                atLeastOneAttDuplicated = true;
                if (duplicatedAttachment.isEmbedded()) continue;
                atLeastOneNonEmbeddedAttDuplicated = true;
            }
            catch (SQLException e) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATABASE_ERROR));
            }
        }
        if (AttachmentOwnerType.TicketAttachment.equals(type) && !allAttachmentsToDuplicate.isEmpty()) {
            List<String> duplicatedTicketAttachmentNames = allAttachmentsToDuplicate.stream().map(AttachmentRow::getFileName).collect(Collectors.toList());
            AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(duplicateOwnerId, Collections.emptyList(), duplicatedTicketAttachmentNames);
        }
        return new TicketAttachmentsDuplicatorExtension.AttachmentDuplicationResult(atLeastOneAttDuplicated, atLeastOneNonEmbeddedAttDuplicated);
    }

    private List<AttachmentRow> getAllAttachments(AttachmentOwnerType type, int ownerId, int stepId) {
        try {
            return this.attachmentDAO.getAttachments(type, ownerId, stepId);
        }
        catch (SQLException e) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATABASE_ERROR));
            return new ArrayList<AttachmentRow>();
        }
    }

    private AttachmentRow createDuplicateForNewOwnerWithCurrentTimeSetAsLastModified(int newOwnerId, int newStepId, AttachmentRow attachmentRow) {
        AttachmentOwnerType type = attachmentRow.getType();
        Integer ownerId = newOwnerId;
        Integer stepId = newStepId;
        Integer additionalId = attachmentRow.getAdditionalId();
        String fileName = attachmentRow.getFileName();
        AttachmentKey key = new AttachmentKey(type, ownerId, stepId, additionalId, fileName);
        String checksum = attachmentRow.getChecksum();
        long fileLength = attachmentRow.getFileLength();
        boolean isEmbedded = attachmentRow.isEmbedded();
        long lastModified = System.currentTimeMillis();
        return new AttachmentRow(key, checksum, fileLength, isEmbedded, lastModified);
    }
}

