/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.shared.BooleanMatcher;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.plugin.ServerPluginManager;
import java.util.Optional;

public class AddOrDeleteAttachmentActionExtensionFactory
implements TicketActionExtensionFactory {
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        if (action.getId() == -21) {
            return new AddOrDeleteAttachmentActionExtension(true);
        }
        if (action.getId() == -6) {
            return new AddOrDeleteAttachmentActionExtension(false);
        }
        return null;
    }

    public static void updateAttachmentFlagForBundle(boolean addedAttachmentElseRemoved, OperationChangedTicket ticket) {
        boolean isBundleSlaveAffected;
        Optional oldTicket = ticket.getOldTicket();
        boolean bl = isBundleSlaveAffected = !ticket.isNew() && ((TicketVO)oldTicket.get()).isSlaveInBundle();
        if (addedAttachmentElseRemoved) {
            ticket.getNewTicketAttributes().put((TicketAttribute)Tickets.ATTRIBUTE_ATTACHMENTS, (Object)true);
            if (isBundleSlaveAffected) {
                ticket.getParentModel().changeExistingTicket(((TicketVO)oldTicket.get()).getBundleID()).getNewTicketAttributes().put((TicketAttribute)Tickets.ATTRIBUTE_ATTACHMENTS, (Object)true);
            }
        } else {
            boolean hasNoMoreAtts = ((TicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAttachmentProvider.class)).getAttachmentsForTicket(ticket.getTicketId(), ContextType.supporter).getAttachments().getMatched(BooleanMatcher.ANY, BooleanMatcher.ONLY_FALSE).isEmpty();
            if (hasNoMoreAtts) {
                boolean bundleMasterHasNoMoreAtts;
                ticket.getNewTicketAttributes().put((TicketAttribute)Tickets.ATTRIBUTE_ATTACHMENTS, (Object)false);
                if (isBundleSlaveAffected && (bundleMasterHasNoMoreAtts = ((TicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAttachmentProvider.class)).getAttachmentsForTicket(((TicketVO)oldTicket.get()).getBundleID(), ContextType.supporter).getAttachments().getMatched(BooleanMatcher.ANY, BooleanMatcher.ONLY_FALSE).isEmpty())) {
                    ticket.getParentModel().changeExistingTicket(((TicketVO)oldTicket.get()).getBundleID()).getNewTicketAttributes().put((TicketAttribute)Tickets.ATTRIBUTE_ATTACHMENTS, (Object)false);
                }
            }
        }
    }

    public class AddOrDeleteAttachmentActionExtension
    implements TicketActionExtension {
        private final boolean addedAttachmentElseRemoved;

        public AddOrDeleteAttachmentActionExtension(boolean addedAttachmentElseRemoved) {
            this.addedAttachmentElseRemoved = addedAttachmentElseRemoved;
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            AddOrDeleteAttachmentActionExtensionFactory.updateAttachmentFlagForBundle(this.addedAttachmentElseRemoved, ticket);
        }
    }
}

