/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

final class FloatConverter
implements Converter {
    public static final FloatConverter INSTANCE = new FloatConverter();

    FloatConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Float.TYPE == cls || Float.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return c == Float.TYPE ? Float.valueOf(0.0f) : null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return c == Float.TYPE ? Float.valueOf(0.0f) : null;
        }
        if (value instanceof String) {
            String str;
            NumberFormat f = context.getNumberFormat();
            if (f != null) {
                value = f.parse((String)value);
            }
            if ((str = value.toString().trim()).length() > 0) {
                return Float.valueOf(str);
            }
            return c == Float.TYPE ? Float.valueOf(0.0f) : null;
        }
        if (value instanceof Boolean) {
            return Float.valueOf((Boolean)value != false ? 1.0f : Float.NaN);
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

