/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.tools;

import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ai.api.c;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.client.transport.StdioClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends AbstractStructureProvider {
    public static final ConfigKey bP = new ConfigKey("tools.mcpservers", "[]", List.class);

    public b() {
        super("com.inet.plugin.ai.structure.i18n.ConfigStructure");
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(103, "categorygroup.ai", this.translate(settings, "categorygroup.ai", new Object[0]), null));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if ("categorygroup.ai".equals(groupKey) && advanced) {
            categories.add(new ConfigCategory(400, "category.ai.tools", this.translate(settings, "category.ai.tools", new Object[0]), "ai-integration.tools"));
        }
    }

    @Nullable
    public URL getCategoryIcon(@Nonnull String categoryKey) {
        if ("category.ai.tools".equals(categoryKey)) {
            return ((Object)((Object)this)).getClass().getResource("ai_tools_48.svg");
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if ("category.ai.tools".equals(categoryKey) && SystemPermissionChecker.checkHostingAccess((Permission)Permission.CONFIGURATION)) {
            configPropertyGroups.add(new ConfigPropertyGroup(100, "group.ai.tools", this.translate(settings, "group.ai.tools", new Object[0])));
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if ("group.ai.tools".equals(propertyGroupKey) && advanced) {
            List list2;
            List list3 = (ArrayList)settings.getValue(bP, List.class);
            if (list3 == null) {
                list3 = new ArrayList();
            }
            if ((list2 = (List)settings.getChangedValue(bP, List.class)) != null) {
                list3 = list2;
            }
            List list4 = list3.stream().map(list -> list.toArray(new String[0])).collect(Collectors.toList());
            ConfigProperty[] configPropertyArray = new ConfigProperty[]{new ConfigProperty(0, "name", "SimpleText", this.translate(settings, "endpoints.name", new Object[0]), null, null, null), new SelectConfigProperty(1, "command", "SimpleText", this.translate(settings, "endpoints.command", new Object[0]), (Object)"npx", null, List.of(new LocalizedKey("npx", "npx"), new LocalizedKey("python", "python"))), new ConfigProperty(2, "args", "SimpleText", this.translate(settings, "endpoints.args", new Object[0]), (Object)"[]", null, null), new ConfigProperty(3, "env", "SimpleText", this.translate(settings, "endpoints.env", new Object[0]), (Object)"{}", null, null)};
            ConfigAction[] configActionArray = new ConfigAction[]{new ConfigAction(this.translate(settings, "endpoints.add", new Object[0]))};
            this.addTableTo(configProperties, bP.getKey(), "KeyLabel", settings, list4, configActionArray, configPropertyArray);
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        String string = settings.getChangedValue(bP.getKey());
        if (string != null && !string.isBlank()) {
            ArrayList arrayList = (ArrayList)new Json().fromJson(string, ArrayList.class);
            arrayList.forEach(arrayList2 -> {
                String string;
                String string2;
                String string3 = (String)arrayList2.get(0);
                if (string3 == null || string3.isBlank()) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "endpoints.name.required", new Object[0]), bP));
                }
                if ((string2 = (String)arrayList2.get(1)) == null || string2.isBlank()) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "endpoints.command.required", new Object[0]), bP));
                } else if (!string2.equals("npx") && !string2.equals("python")) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "endpoints.command.required", new Object[0]), bP));
                    return;
                }
                if (messages.size() > 0) {
                    return;
                }
                String string4 = (String)arrayList2.get(2);
                if (string4 == null || string4.isBlank()) {
                    string4 = "[]";
                }
                if ((string = (String)arrayList2.get(3)) == null || string.isBlank()) {
                    string = "{}";
                }
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    List list = (List)new Json().fromJson(string4, List.class);
                    if (list.size() == 0) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "endpoints.args.required", new Object[0]), bP));
                        return;
                    }
                    Map map = (Map)new Json().fromJson(string, Map.class);
                    ServerParameters serverParameters = ServerParameters.builder((String)string2).args(list).env(map).build();
                    StdioClientTransport stdioClientTransport = new StdioClientTransport(serverParameters);
                    McpSyncClient mcpSyncClient = McpClient.sync((McpClientTransport)stdioClientTransport).loggingConsumer(loggingMessageNotification -> {
                        String string = loggingMessageNotification.data();
                        stringBuilder.append(string);
                        com.inet.plugin.ai.api.b.a(loggingMessageNotification);
                    }).build();
                    mcpSyncClient.initialize();
                    McpSchema.ListToolsResult listToolsResult = mcpSyncClient.listTools();
                }
                catch (Exception exception) {
                    if (stringBuilder.isEmpty()) {
                        stringBuilder.append(StringFunctions.getUserFriendlyErrorMessage((Throwable)exception));
                    }
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "mcp.error", new Object[]{stringBuilder.toString()}), bP));
                }
            });
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (bP.getKey().equals(key)) {
            settings.save(bP, value);
            c.e();
            return ConfigStructure.SaveState.SAVE;
        }
        return ConfigStructure.SaveState.NONE;
    }
}

