/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.api;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.plugin.ai.api.ConversationStepType;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ConversationStep {
    @Nullable
    private String text;
    @Nonnull
    private ConversationStepType stepType;
    private List<Map<String, Object>> toolCalls;
    private String toolCallId;

    public ConversationStep(@Nullable String text, @Nonnull ConversationStepType stepType) {
        this.text = text;
        this.stepType = stepType;
    }

    public ConversationStep(String text, @Nonnull ConversationStepType stepType, String toolCallId) {
        this(text, stepType);
        this.toolCallId = toolCallId;
    }

    public ConversationStep(List<Map<String, Object>> toolCalls) {
        this.stepType = ConversationStepType.assistant;
        this.toolCalls = toolCalls;
    }

    public ConversationStep(@Nullable String text, List<Map<String, Object>> toolCalls) {
        this.stepType = ConversationStepType.assistant;
        this.toolCalls = toolCalls;
        this.text = text;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nonnull
    public ConversationStepType getStepType() {
        return this.stepType;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public List<Map<String, Object>> getToolCalls() {
        return this.toolCalls;
    }

    public void calls(BiConsumer<String, Map<String, Object>> functionCall) {
        if (this.toolCalls == null) {
            return;
        }
        for (Map<String, Object> map : this.toolCalls) {
            String string;
            Map map2 = (Map)map.get("function");
            String string2 = (String)map2.get("name");
            Map map3 = (Map)map2.get("args");
            if (map3 == null && (string = (String)map2.get("arguments")) != null) {
                map3 = (Map)new Json().fromJson(string, Map.class);
            }
            functionCall.accept(string2, map3);
        }
    }
}

