/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.taskplanner;

import com.inet.http.utils.MimeTypes;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.report.adhoc.server.taskplanner.b;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheInputStream;
import com.inet.report.cache.ReportCacheKey;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.result.TextResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
implements FileResult,
TextResult {
    @Nonnull
    private ReportCacheKey mY;
    @Nonnull
    private String mZ;
    private boolean na;

    public c(@Nonnull ReportCacheKey reportCacheKey, @Nonnull String string) {
        this.mY = reportCacheKey;
        this.mZ = string;
        this.na = switch (reportCacheKey.getFormat()) {
            case "txt" -> true;
            case "csv" -> true;
            case "json" -> true;
            case "xml" -> true;
            default -> false;
        };
    }

    public String getText() throws IOException {
        if (this.na) {
            try (InputStream inputStream = this.getTextContent();){
                String string = IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        return "";
    }

    public InputStream getTextContent() throws IOException {
        if (this.na) {
            return this.getFileContent();
        }
        return new FastByteArrayInputStream(new byte[0]);
    }

    @Nonnull
    public InputStream getFileContent() throws IOException {
        return new ReportCacheInputStream(this.mY, 0);
    }

    public String getTextContentType() throws Exception {
        return MimeTypes.getMimeType((String)this.getFileName());
    }

    @Nullable
    public String getFileContentType() throws Exception {
        return this.getTextContentType();
    }

    public List<ResultFlavor> getFlavors() {
        if (this.na) {
            return Arrays.asList(ResultFlavor.TEXT, ResultFlavor.FILE);
        }
        return Arrays.asList(ResultFlavor.FILE);
    }

    public long getFileSize() throws Exception {
        return Cache.getCache().getTotalPageSizeAndWait(this.mY);
    }

    @Nonnull
    public String getFileName() {
        return this.mZ + "." + this.mY.getFormat();
    }

    public void cleanup() throws Exception {
        try {
            Cache.getCache().delete(this.mY);
        }
        catch (Throwable throwable) {
            b.mX.warn("Error while deleting report from cache: " + String.valueOf(this.mY), (Object)throwable);
        }
    }
}

