/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.renderer.table;

import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.ColorUtils;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.dataview.PersistenceTemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.AbstractFormatableColumn;
import com.inet.report.adhoc.server.api.renderer.AdHocDefinition;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.PreviewData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import com.inet.report.adhoc.server.api.renderer.SummaryOperation;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.adhoc.server.api.renderer.table.TableSortingData;
import com.inet.report.adhoc.server.api.theming.ThemePropertyKey;
import com.inet.report.adhoc.server.renderer.table.a;
import com.inet.report.adhoc.server.theming.AdHocTheme;
import com.inet.report.adhoc.webgui.controls.BooleanControl;
import com.inet.report.adhoc.webgui.controls.ColorControl;
import com.inet.report.adhoc.webgui.controls.ColumnsControl;
import com.inet.report.adhoc.webgui.controls.ColumnsSection;
import com.inet.report.adhoc.webgui.controls.ComponentSettings;
import com.inet.report.adhoc.webgui.controls.ConditionalLocalizedkey;
import com.inet.report.adhoc.webgui.controls.DataFilterControl;
import com.inet.report.adhoc.webgui.controls.DataSelectControl;
import com.inet.report.adhoc.webgui.controls.GroupControl;
import com.inet.report.adhoc.webgui.handler.data.ColumnSelectOption;
import com.inet.shared.utils.MemoryStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends AdHocRendererFactory<a> {
    @Nonnull
    public static final ThemePropertyKey<Boolean> mF = new ThemePropertyKey<Boolean>("table.border.show", Boolean.class, false);
    @Nonnull
    public static final ThemePropertyKey<Integer> mG = new ThemePropertyKey<Integer>("table.border.color", Integer.class, 0);
    @Nonnull
    public static final ThemePropertyKey<Integer> mH = new ThemePropertyKey<Integer>("table.header.font.color", Integer.class, 0);
    @Nonnull
    public static final ThemePropertyKey<Boolean> mI = new ThemePropertyKey<Boolean>("table.header.font.style.bold", Boolean.class, true);
    @Nonnull
    public static final ThemePropertyKey<Boolean> mJ = new ThemePropertyKey<Boolean>("table.header.font.style.italic", Boolean.class, false);
    @Nonnull
    public static final ThemePropertyKey<Boolean> mK = new ThemePropertyKey<Boolean>("table.header.font.style.underline", Boolean.class, false);
    @Nonnull
    public static final RendererPropertyKey<TableColumnData[]> TABLE_COLUMNS = new RendererPropertyKey<TableColumnData[]>("table.columns", TableColumnData[].class);
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> TABLE_GROUPS = new RendererPropertyKey<GroupData[]>("table.groups", GroupData[].class);
    @Nonnull
    public static final RendererPropertyKey<TableSortingData[]> TABLE_SORTING = new RendererPropertyKey<TableSortingData[]>("table.sorting", TableSortingData[].class);

    public b() {
        super("table");
    }

    @Override
    public void validate(@Nonnull AdHocDefinition definition) throws ValidationException {
        Object object;
        super.validate(definition);
        Map map = definition.getProperties();
        String string = TABLE_COLUMNS.getName();
        String string2 = map.get(TABLE_COLUMNS);
        if (string2 == null) {
            throw new ValidationException(string, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.noTableColumn", new Object[0]));
        }
        try {
            object = (TableColumnData[])new Json().fromJson(string2, TableColumnData[].class);
            if (((TableColumnData[])object).length == 0) {
                throw new ValidationException(string, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.noTableColumn", new Object[0]));
            }
            for (TableColumnData tableColumnData : object) {
                if (tableColumnData != null) continue;
                throw new ValidationException(string, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.invalidData", new Object[0]));
            }
        }
        catch (JsonException jsonException) {
            throw new ValidationException(string, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.invalidData", new Object[0]), jsonException);
        }
        object = TABLE_SORTING.getName();
        String string3 = map.get(TABLE_SORTING);
        if (string3 != null) {
            try {
                TableSortingData[] jsonException = (TableSortingData[])new Json().fromJson(string3, TableSortingData[].class);
                if (jsonException.length > 0) {
                    for (TableSortingData tableSortingData : jsonException) {
                        if (tableSortingData != null) continue;
                        throw new ValidationException((String)object, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.invalidData", new Object[0]));
                    }
                }
            }
            catch (JsonException string32) {
                throw new ValidationException((String)object, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.invalidData", new Object[0]), string32);
            }
        }
        String string4 = TABLE_GROUPS.getName();
        String string5 = map.get(TABLE_GROUPS);
        if (string5 != null) {
            try {
                GroupData[] jsonException = (GroupData[])new Json().fromJson(string5, GroupData[].class);
                if (jsonException.length > 0) {
                    for (GroupData groupData : jsonException) {
                        if (groupData != null) continue;
                        throw new ValidationException(string4, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.invalidData", new Object[0]));
                    }
                }
            }
            catch (JsonException jsonException) {
                throw new ValidationException(string4, com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.invalidData", new Object[0]), jsonException);
            }
        }
    }

    @Nonnull
    public a g(@Nonnull AdHocDefinition adHocDefinition) {
        return new a(adHocDefinition.getProperties());
    }

    @Override
    @Nonnull
    public ComponentSettings getComponentSettings(@Nonnull com.inet.report.adhoc.webgui.controls.a complexity) {
        ComponentSettings componentSettings = new ComponentSettings("table");
        componentSettings.setExpandContent(true);
        GroupControl groupControl = componentSettings.addGroup("group.source");
        DataSelectControl dataSelectControl = new DataSelectControl();
        groupControl.add(dataSelectControl);
        groupControl = componentSettings.addGroup("group.column");
        groupControl.add(new ColumnsControl("preview-table", new ColumnsSection(TABLE_COLUMNS.getName(), "", 0, ColumnsSection.a.np, ColumnsSection.a.nr)));
        groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        switch (complexity) {
            case nD: {
                groupControl = componentSettings.addGroup("group.group");
                groupControl.add(new ColumnsControl("group", (String)null, new ColumnsSection(TABLE_GROUPS.getName(), "", 6, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns)));
                groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
                break;
            }
        }
        groupControl = componentSettings.addGroup("group.filter");
        DataFilterControl dataFilterControl = new DataFilterControl();
        groupControl.add(dataFilterControl);
        groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        switch (complexity) {
            case nD: 
            case nC: {
                groupControl = componentSettings.addGroup("group.sort");
                groupControl.add(new ColumnsControl("sort", (String)null, new ColumnsSection(TABLE_SORTING.getName(), "", 0, ColumnsSection.a.nn)));
                groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
                break;
            }
        }
        return componentSettings;
    }

    @Override
    @Nonnull
    public ComponentSettings getDefaultSettings() {
        ComponentSettings componentSettings = new ComponentSettings("table");
        GroupControl groupControl = componentSettings.addGroup("group.column");
        groupControl.add(new ColumnsControl("preview-table", new ColumnsSection(TABLE_COLUMNS.getName(), "", 0, ColumnsSection.a.np, ColumnsSection.a.nr)));
        groupControl.visibleWhen(PersistenceTemplateDataViewDefaults.TEMPLATESOURCE_COLUMNS_KEY.getName(), ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        groupControl = componentSettings.addGroup("group.group");
        groupControl.add(new ColumnsControl("group", (String)null, new ColumnsSection(TABLE_GROUPS.getName(), "", 6, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns)));
        groupControl.visibleWhen(PersistenceTemplateDataViewDefaults.TEMPLATESOURCE_COLUMNS_KEY.getName(), ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        groupControl = componentSettings.addGroup("group.sort");
        groupControl.add(new ColumnsControl("sort", (String)null, new ColumnsSection(TABLE_SORTING.getName(), "", 0, ColumnsSection.a.nn)));
        groupControl.visibleWhen(PersistenceTemplateDataViewDefaults.TEMPLATESOURCE_COLUMNS_KEY.getName(), ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        return componentSettings;
    }

    @Override
    @Nullable
    public ComponentSettings getThemeSettings() {
        ComponentSettings componentSettings = new ComponentSettings("table");
        GroupControl groupControl = componentSettings.addGroup("settingsgroup.table.border", com.inet.report.adhoc.server.renderer.a.bm.getMsg("border", new Object[0]));
        groupControl.add(new BooleanControl(mF, com.inet.report.adhoc.server.renderer.a.bm.getMsg("border.show", new Object[0])));
        ColorControl colorControl = new ColorControl(mG, com.inet.report.adhoc.server.renderer.a.bm.getMsg("border.color", new Object[0]));
        colorControl.visibleWhen(mF.getName(), ConditionalLocalizedkey.ConditionOperator.EQ, (Object)"true");
        groupControl.add(colorControl);
        GroupControl groupControl2 = componentSettings.addGroup("settingsgroup.table.header", com.inet.report.adhoc.server.renderer.a.bm.getMsg("headerrow", new Object[0]));
        groupControl2.add(new ColorControl(mH, com.inet.report.adhoc.server.renderer.a.bm.getMsg("font.color", new Object[0])));
        groupControl2.add(new BooleanControl(mI, com.inet.report.adhoc.server.renderer.a.bm.getMsg("font.style.bold", new Object[0])));
        groupControl2.add(new BooleanControl(mJ, com.inet.report.adhoc.server.renderer.a.bm.getMsg("font.style.italic", new Object[0])));
        groupControl2.add(new BooleanControl(mK, com.inet.report.adhoc.server.renderer.a.bm.getMsg("font.style.underline", new Object[0])));
        return componentSettings;
    }

    @Override
    public void convertUiModeltoServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        super.convertUiModeltoServerModel(uiModel, serverModel);
        this.convertUiProperty("columns", TABLE_COLUMNS, columnSelectOption -> {
            SummaryOperation summaryOperation = columnSelectOption.getSummaryOperation();
            return new TableColumnData(columnSelectOption.getValue(), columnSelectOption.getValueFormat(), summaryOperation == null ? Collections.emptyList() : Arrays.asList(summaryOperation));
        }, uiModel, serverModel);
        this.convertUiProperty("group", TABLE_GROUPS, columnSelectOption -> new GroupData(columnSelectOption.getValue(), columnSelectOption.getSorting(), columnSelectOption.getTimePeriod(), columnSelectOption.getValueFormat()), uiModel, serverModel);
        this.convertUiProperty("sort", TABLE_SORTING, columnSelectOption -> new TableSortingData(columnSelectOption.getValue(), columnSelectOption.getSorting() != SortOrder.DESCENDING), uiModel, serverModel);
    }

    @Override
    public void convertServerModeltoUiModel(@Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        super.convertServerModeltoUiModel(serverModel, uiModel);
        Json json = new Json();
        this.convertServerProperty(TABLE_COLUMNS, "columns", (string, list) -> {
            for (TableColumnData tableColumnData : (TableColumnData[])json.fromJson(string, TableColumnData[].class, Json.NULL_MAP, null)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(tableColumnData.getColumnKey(), tableColumnData.getColumnKey(), -1, tableColumnData.getValueFormat());
                List<SummaryOperation> list2 = tableColumnData.getSumOperations();
                if (list2 != null && !list2.isEmpty()) {
                    columnSelectOption.setSummaryOperation(list2.get(0));
                }
                list.add(columnSelectOption);
            }
        }, serverModel, uiModel);
        this.convertServerProperty(TABLE_GROUPS, "group", (string, list) -> {
            for (GroupData groupData : (GroupData[])json.fromJson(string, GroupData[].class, Json.NULL_MAP, null)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(groupData.getColumnKey(), groupData.getColumnKey(), null, -1, groupData.getValueFormat(), groupData.getTimePeriod());
                columnSelectOption.setSorting(groupData.getSortOrder());
                list.add(columnSelectOption);
            }
        }, serverModel, uiModel);
        this.convertServerProperty(TABLE_SORTING, "sort", (string, list) -> {
            for (TableSortingData tableSortingData : (TableSortingData[])json.fromJson(string, TableSortingData[].class, Json.NULL_MAP, null)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(tableSortingData.getColumnKey(), tableSortingData.getColumnKey(), -1, AbstractFormatableColumn.ValueFormat.UNFORMATTED);
                columnSelectOption.setSorting(tableSortingData.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                list.add(columnSelectOption);
            }
        }, serverModel, uiModel);
    }

    @Override
    @Nonnull
    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/report/adhoc/server/images/table.svg");
    }

    @Override
    protected void convertThemeSettingsFromUiModelToServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        b.transferUnconvertedValueOrDefaultToServerModel(mF, uiModel, serverModel);
        b.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(mG, uiModel, serverModel);
        b.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(mH, uiModel, serverModel);
        b.transferUnconvertedValueOrDefaultToServerModel(mI, uiModel, serverModel);
        b.transferUnconvertedValueOrDefaultToServerModel(mJ, uiModel, serverModel);
        b.transferUnconvertedValueOrDefaultToServerModel(mK, uiModel, serverModel);
    }

    @Override
    protected void convertThemeSettingsFromServerModelToUiModel(@Nonnull Map<ThemePropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        b.transferUnconvertedValueOrDefaultToUiModel(mF, serverModel, uiModel);
        b.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(mG, serverModel, uiModel);
        b.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(mH, serverModel, uiModel);
        b.transferUnconvertedValueOrDefaultToUiModel(mI, serverModel, uiModel);
        b.transferUnconvertedValueOrDefaultToUiModel(mJ, serverModel, uiModel);
        b.transferUnconvertedValueOrDefaultToUiModel(mK, serverModel, uiModel);
    }

    @Override
    public void appendCSS(@Nonnull AdHocTheme theme, @Nonnull MemoryStream stream) {
        stream.writeASCII("table.adhocthemed {width: 100%;}");
        boolean bl = theme.getBooleanOrDefault(mF);
        if (bl) {
            stream.writeASCII("table.adhocthemed {border-collapse: separate; border-spacing: 0px;}");
            stream.writeASCII("table.adhocthemed th, table.adhocthemed td {border: 0px solid ");
            int n2 = theme.getIntOrDefault(mG);
            ColorUtils.appendHtmlColor((MemoryStream)stream, (int)n2);
            stream.writeASCII("; border-right-width: 1px; border-bottom-width: 1px;}");
            stream.writeASCII("table.adhocthemed th.first-child, table.adhocthemed td.first-child {border-left-width: 1px;}");
            stream.writeASCII("table.adhocthemed tr.first-child th, table.adhocthemed tr.first-child td {border-top-width: 1px;}");
        }
        stream.writeASCII("table.adhocthemed tr th{");
        AdHocTheme.appendFontFromTheme(stream, b.f(theme));
        stream.writeASCII(";text-align:left");
        stream.writeASCII(";padding:2px 5px");
        stream.write(125);
        stream.writeASCII("table.adhocthemed tr td{");
        AdHocTheme.appendFontFromTheme(stream, theme.getBody());
        stream.writeASCII(";padding:2px 5px");
        stream.write(125);
        stream.writeASCII("table.adhocthemed tr td.sum{");
        AdHocTheme.appendFontFromTheme(stream, theme.getSummary());
        stream.write(125);
    }

    @Nonnull
    static com.inet.report.adhoc.server.theming.a f(@Nonnull AdHocTheme adHocTheme) {
        return adHocTheme.getThemeFontFrom(AdHocTheme.DEFAULT_FONT_FAMILY, mH, AdHocTheme.DEFAULT_FONT_SIZE, mI, mJ, mK);
    }

    @Override
    @Nullable
    public PreviewData getPreviewData(@Nullable GUID themeId) {
        return new PreviewData("<table class='adhocthemed'><thead class='stickyheader'><tr class='first-child'><th class='first-child stickyheader'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.column", new Object[0]) + " 1</th><th>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.column", new Object[0]) + " 2</th><th>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.column", new Object[0]) + " 3</th></tr></thead><tbody><tr><td class='first-child'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 1</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 2</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 3</td></tr><tr><td class='first-child'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 4</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 5</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 6</td></tr><tr><td class='first-child'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 7</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 8</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 9</td></tr><tr><td class='first-child'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 10</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 11</td><td>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.value", new Object[0]) + " 12</td></tr><tr><td class='first-child sum'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.sum", new Object[0]) + " 1</td><td class='sum'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.sum", new Object[0]) + " 2</td><td class='sum'>" + com.inet.report.adhoc.server.renderer.a.bm.getMsg("preview.sum", new Object[0]) + " 3</td></tr></tbody></table>");
    }

    @Override
    @Nonnull
    public /* synthetic */ com.inet.report.adhoc.server.api.renderer.b createInstanceFrom(@Nonnull AdHocDefinition adHocDefinition) {
        return this.g(adHocDefinition);
    }
}

