/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.handler;

import com.inet.annotations.JsonData;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.a;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.renderer.AdHocDefinition;
import com.inet.report.adhoc.server.api.renderer.d;
import com.inet.report.adhoc.webgui.controls.ComponentSettings;
import com.inet.report.adhoc.webgui.handler.data.RenderComponentRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;

public class RenderComponentHandler
extends ServiceMethod<RenderComponentRequest, Void> {
    public Void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, RenderComponentRequest renderComponentRequest) throws IOException {
        final String string = renderComponentRequest.getClientId();
        String string2 = renderComponentRequest.getTheme();
        final GUID gUID = renderComponentRequest.getComponentId();
        String string3 = renderComponentRequest.getComponentType();
        Map<String, String> map = renderComponentRequest.getProperties();
        final int n2 = Math.max(renderComponentRequest.getLimit(), 1000) + (renderComponentRequest.isMoreData() ? 1000 : 0);
        d d2 = new d(){

            @Override
            public void a(@Nonnull Throwable throwable) {
                RenderError renderError;
                if (throwable instanceof ValidationException) {
                    AdHocServerPlugin.LOGGER.debug((Object)throwable);
                    String string2 = throwable.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    renderError = new RenderError(gUID, ((ValidationException)throwable).getKey(), string2);
                } else {
                    AdHocServerPlugin.LOGGER.error(throwable);
                    renderError = new RenderError(gUID, null, StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
                }
                WebSocketEventHandler.getInstance().sendEvent(string, () -> new WebSocketEventData("adhoc.render.error", (Object)renderError));
            }

            @Override
            public void a(@Nonnull String string2, boolean bl) {
                RenderResult renderResult = new RenderResult(gUID, string2, n2, bl);
                WebSocketEventHandler.getInstance().sendEvent(string, () -> new WebSocketEventData("adhoc.render.result", (Object)renderResult));
            }

            @Override
            public void a(double d2) {
                RenderProgress renderProgress = new RenderProgress(gUID, d2);
                WebSocketEventHandler.getInstance().sendEvent(string, () -> new WebSocketEventData("adhoc.render.progress", (Object)renderProgress));
            }
        };
        try {
            AdHocDefinition adHocDefinition = ComponentSettings.toServerModel(gUID, string3, map, true);
            a a2 = (a)ServerPluginManager.getInstance().getSingleInstance(a.class);
            a2.a(adHocDefinition, string2, n2, d2);
        }
        catch (Throwable throwable) {
            d2.a(throwable);
        }
        return null;
    }

    public String getMethodName() {
        return "adhoc.rendercomponent";
    }

    public short getMethodType() {
        return 1;
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (RenderComponentRequest)object);
    }

    @JsonData
    public static class RenderProgress {
        private GUID componentId;
        private double progress;

        public RenderProgress(GUID componentId, double progress) {
            this.componentId = componentId;
            this.progress = progress;
        }
    }

    @JsonData
    public static class RenderResult {
        private GUID componentId;
        @Nonnull
        private String componentHTML;
        private int limit;
        private boolean partial;

        public RenderResult(GUID componentId, @Nonnull String componentHTML, int limit, boolean partial) {
            this.componentId = componentId;
            this.componentHTML = componentHTML;
            this.limit = limit;
            this.partial = partial;
        }
    }

    @JsonData
    public static class RenderError {
        private GUID componentId;
        private String controlKey;
        @Nonnull
        private String errorMessage;

        public RenderError(GUID componentId, String controlKey, @Nonnull String errorMessage) {
            this.componentId = componentId;
            this.controlKey = controlKey;
            this.errorMessage = errorMessage;
        }
    }
}

