/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.controls;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.report.adhoc.server.api.dataview.DataViewAccessList;
import com.inet.report.adhoc.server.api.dataview.PersistenceTemplateDataViewDefaults;
import com.inet.report.adhoc.webgui.controls.BaseControl;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
public class AccessControl
extends BaseControl {
    public AccessControl(@Nonnull String key) {
        super("access", key);
    }

    public static DataViewAccessList convertUiModeltoServerModel(@Nonnull Map<String, String> uiModel) {
        String string = uiModel.get(PersistenceTemplateDataViewDefaults.ACCESS_LIST_KEY.getName());
        Json json = new Json();
        HashSet<GUID> hashSet = new HashSet<GUID>();
        HashSet<GUID> hashSet2 = new HashSet<GUID>();
        if (!StringFunctions.isEmpty((String)string)) {
            UsersOrGroupsSelection usersOrGroupsSelection = (UsersOrGroupsSelection)json.fromJson(string, UsersOrGroupsSelection.class);
            if ("custom".equals(usersOrGroupsSelection.getPreselection())) {
                usersOrGroupsSelection.getSelectedMembers().stream().forEach(sm -> {
                    if (sm.getType().equals((Object)Type.group)) {
                        hashSet2.add(sm.getId());
                    } else {
                        hashSet.add(sm.getId());
                    }
                });
            } else if ("public".equals(usersOrGroupsSelection.getPreselection())) {
                hashSet2.add(UsersAndGroups.GROUPID_ALLUSERS);
            }
        }
        return new DataViewAccessList(hashSet, hashSet2);
    }

    public static void convertServerModeltoUiModel(@Nonnull DataViewAccessList accessList, @Nonnull Map<String, String> uiModel) {
        Json json = new Json();
        ArrayList arrayList = new ArrayList();
        if (accessList != null) {
            accessList.getGroupIDs().stream().forEach(id -> arrayList.add(new UsersOrGroupsSelection.SelectedMember(Type.group, id)));
            accessList.getUserIDs().stream().forEach(id -> arrayList.add(new UsersOrGroupsSelection.SelectedMember(Type.user, id)));
        }
        UsersOrGroupsSelection usersOrGroupsSelection = new UsersOrGroupsSelection(arrayList);
        String string = json.toJson((Object)usersOrGroupsSelection);
        uiModel.put(PersistenceTemplateDataViewDefaults.ACCESS_LIST_KEY.getName(), string);
    }
}

