/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.taskplanner;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.model.AdHocReport;
import com.inet.report.adhoc.server.taskplanner.a;
import com.inet.report.exportwebui.api.ExportReportHandlerBase;
import com.inet.report.exportwebui.data.ExportFormatDescription;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.AbstractInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.FileField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends JobFactory<a> {
    @Nonnull
    public static final Logger mX = LogManager.getLogger((String)"Task Planner");

    public b() {
        super("adhoc");
    }

    protected a a(@Nonnull JobDefinition jobDefinition, @Nullable GUID gUID) {
        String string = jobDefinition.getProperty("job.adhoc.path");
        String string2 = jobDefinition.getProperty("job.adhoc.format");
        return new a(string, string2, jobDefinition.getCondition());
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        return Arrays.asList(ResultFlavor.FILE);
    }

    protected void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
    }

    public JobInfo g(@Nullable GUID gUID) {
        String string = AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.name", new Object[0]);
        String string2 = AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.description", new Object[0]);
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/inet/report/adhoc/server/taskplanner/adhoc_32.png");
        String string3 = "taskplanner.job.adhoc";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("adhoc.reportname");
        ArrayList<LocalizedKey> arrayList3 = new ArrayList<LocalizedKey>(ExportReportHandlerBase.collectExportFormats());
        arrayList3.removeIf(localizedKey -> localizedKey.getKey().isEmpty());
        arrayList3.add(1, new LocalizedKey("AdHocHTML", com.inet.report.adhoc.server.renderer.a.bm.getMsg("export.adHocHTML", new Object[0])));
        SelectField selectField = new SelectField("job.adhoc.format", AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.format", new Object[0]), arrayList3);
        if (!arrayList3.isEmpty()) {
            selectField.setValue(((LocalizedKey)arrayList3.get(0)).getKey());
        }
        arrayList.add(selectField);
        FileField fileField = new FileField("job.adhoc.path", AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path", new Object[0]));
        fileField.setProtocols(FileServiceForTaskPlanner.getAllAvailableProtocols());
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList4.add("*.adhoc");
        arrayList4.add("*.*");
        fileField.setFilter(arrayList4);
        arrayList.add(fileField);
        ArrayList<LocalizedKey> arrayList5 = new ArrayList<LocalizedKey>();
        arrayList5.add(new LocalizedKey("job.adhoc.condition.notEmptyReport", AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.condition.notEmptyReport", new Object[0])));
        arrayList5.add(new LocalizedKey("job.adhoc.condition.emptyReport", AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.condition.emptyReport", new Object[0])));
        SelectField selectField2 = new SelectField("job.adhoc.condition", AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.condition", new Object[0]), arrayList5);
        selectField2.setConditions(null);
        selectField2.setValue("job.adhoc.condition.notEmptyReport");
        ConditionInfo conditionInfo = new ConditionInfo(List.of(selectField2));
        return new JobInfo("adhoc", string, string2, uRL, string3, conditionInfo, arrayList, arrayList2);
    }

    protected void b(@Nonnull JobDefinition jobDefinition, @Nullable GUID gUID) throws ValidationException {
        Object object;
        String string = jobDefinition.getProperty("job.adhoc.path");
        if (StringFunctions.isEmpty((String)string)) {
            throw new ValidationException(new String[]{AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path.missing", new Object[0])});
        }
        if (!this.hasPlaceholderSet(string, gUID) && (object = FileServiceForTaskPlanner.getServiceFor((String)string)) != null) {
            object.validateFilePath(string);
            try (InputStream inputStream = object.readFile(string);){
                if (inputStream == null) {
                    throw new ValidationException(new String[]{AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path.fileDoesNotExist", new Object[0])});
                }
                AdHocReport adHocReport = (AdHocReport)new Json().fromJson(inputStream, AdHocReport.class);
                if (adHocReport.getPages() == null) {
                    throw new ValidationException(new String[]{AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path.invalidFile", new Object[0])});
                }
            }
            catch (ValidationException validationException) {
                throw validationException;
            }
            catch (Exception exception) {
                throw new ValidationException(new String[]{AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path.invalidFile", new Object[0])});
            }
        }
        if (StringFunctions.isEmpty((String)(object = jobDefinition.getProperty("job.adhoc.format")))) {
            throw new ValidationException(new String[]{AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.format.missing", new Object[0])});
        }
        if (!"AdHocHTML".equals(object) && ExportReportHandlerBase.collectExportFormats().stream().noneMatch(arg_0 -> b.a((String)object, arg_0))) {
            throw new ValidationException(new String[]{AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.format.unsupported", new Object[0])});
        }
    }

    public JobSummaryInfo a(@Nonnull JobDefinition jobDefinition) {
        String string;
        Object object2;
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string2 = jobDefinition.getProperty("job.adhoc.format");
        if (!StringFunctions.isEmpty((String)string2)) {
            if (string2.equals("AdHocHTML")) {
                string2 = com.inet.report.adhoc.server.renderer.a.bm.getMsg("export.adHocHTML", new Object[0]);
            } else {
                for (Object object2 : ExportReportHandlerBase.collectExportFormats()) {
                    if (!string2.equals(object2.getKey())) continue;
                    string2 = object2.getDisplayName();
                    break;
                }
            }
        }
        arrayList.add(new SummaryEntry(AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.format", new Object[0]), string2));
        String string3 = jobDefinition.getProperty("job.adhoc.path");
        arrayList.add(new SummaryEntry(AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.path", new Object[0]), string3));
        object2 = null;
        ConditionDefinition conditionDefinition = jobDefinition.getCondition();
        if (conditionDefinition != null && ("job.adhoc.condition.notEmptyReport".equals(string = conditionDefinition.getProperty("job.adhoc.condition")) || "job.adhoc.condition.emptyReport".equals(string))) {
            object2 = new ArrayList();
            object2.add(new SummaryEntry(AdHocServerPlugin.TASKPLANNER_MSG.getMsg("job.adhoc.condition.summary.prefix", new Object[0]), AdHocServerPlugin.TASKPLANNER_MSG.getMsg(string, new Object[0])));
        }
        return new JobSummaryInfo(arrayList, (List)object2);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean isAvailable() {
        if (!SystemPermissionChecker.checkAccess((Permission)com.inet.report.adhoc.webgui.b.nk)) {
            return false;
        }
        @Nonnull List list = ServerPluginManager.getInstance().get(FileServiceForTaskPlanner.class);
        for (FileServiceForTaskPlanner fileServiceForTaskPlanner : list) {
            Permission permission = fileServiceForTaskPlanner.getRequiredPermission();
            if (permission != null && !SystemPermissionChecker.checkAccess((Permission)permission)) continue;
            return true;
        }
        return false;
    }

    public /* synthetic */ SummaryInfo getSummary(@Nonnull AbstractDefinition abstractDefinition) {
        return this.a((JobDefinition)abstractDefinition);
    }

    protected /* synthetic */ Object createInstanceFrom(@Nonnull AbstractDefinition abstractDefinition, @Nullable GUID gUID) {
        return this.a((JobDefinition)abstractDefinition, gUID);
    }

    protected /* synthetic */ void validate(@Nonnull AbstractDefinition abstractDefinition, @Nullable GUID gUID) throws ValidationException {
        this.b((JobDefinition)abstractDefinition, gUID);
    }

    public /* synthetic */ AbstractInfo getInformation(@Nullable GUID gUID) {
        return this.g(gUID);
    }

    private static /* synthetic */ boolean a(String string, ExportFormatDescription exportFormatDescription) {
        return string.equals(exportFormatDescription.getKey());
    }
}

