/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.dataview.user;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.adhoc.server.api.datasource.UserDataSourceConfiguration;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.dataview.d;
import com.inet.report.adhoc.server.api.dataview.user.DataView_Users;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DataView_GroupMembers
extends d {
    public static final String KEY = "group_members";

    public DataView_GroupMembers() {
        this.setOverriddenHasAccessFunction(gUID -> SystemPermissionChecker.hasAnyPermission((GUID)gUID, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}));
    }

    @Nonnull
    public String getExtensionName() {
        return KEY;
    }

    @Override
    @Nullable
    public String getDescription() {
        return AdHocServerPlugin.SERVER_MSG.getMsg("Dataview_group_members_description", new Object[0]);
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return AdHocServerPlugin.SERVER_MSG.getMsg("Dataview_group_members", new Object[0]);
    }

    @Override
    @Nonnull
    public @Nonnull List< @Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)"Users");
        if (dataSourceConfiguration == null) {
            throw new IllegalStateException("Datasource Users is missing");
        }
        try {
            Engine engine = RDC.createEmptyEngine((String)"java");
            return this.a(engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    @Override
    @Nullable
    public <T> T get_default(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            ArrayList<TableColumnData> arrayList = new ArrayList<TableColumnData>();
            arrayList.add(new TableColumnData("UserAdhoc.username"));
            if (DataSourceUtils.userFieldIsVisible(UsersAndGroups.FIELD_FIRSTNAME)) {
                arrayList.add(new TableColumnData("UserAdhoc." + UsersAndGroups.FIELD_FIRSTNAME.getKey()));
            }
            if (DataSourceUtils.userFieldIsVisible(UsersAndGroups.FIELD_LASTNAME)) {
                arrayList.add(new TableColumnData("UserAdhoc." + UsersAndGroups.FIELD_LASTNAME.getKey()));
            }
            return (T)arrayList.toArray(new TableColumnData[arrayList.size()]);
        }
        if (key == TABLE_GROUPS) {
            return (T)new GroupData[]{new GroupData("UserGroups.usergroupname", SortOrder.ASCENDING)};
        }
        return null;
    }

    @Override
    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            List<@Nonnull LocalizedKey> list = this.a(engine);
            DatabaseTables databaseTables = engine.getDatabaseTables();
            Datasource datasource = databaseTables.getDatasource(0);
            TableSource tableSource = datasource.createTableSource("UserGroupMemberships");
            TableSource tableSource2 = databaseTables.getTablesource("UserAdhoc");
            TableSource tableSource3 = databaseTables.getTablesource("UserGroups");
            DataSourceUtils.join(databaseTables, tableSource2, "userGUID", tableSource, "userGUID", 11);
            DataSourceUtils.join(databaseTables, tableSource3, "usergroupid", tableSource, "usergroupid", 11, this.a(filter) ? 21 : 23);
            DataViewConditions dataViewConditions = new DataViewConditions(filter == null ? new DataFilter(List.of()) : filter, List.of());
            String string = new Json().toJson((Object)dataViewConditions);
            UserDataSourceConfiguration.buildSearchExpressionFromFilter(dataViewConditions);
            DataSourceUtils.setInputParameter(tableSource2, "UserSearchPhrase", string);
            this.setSelectionFormula(engine, filter);
            return new SimpleDataView(list, engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    private boolean a(@Nullable DataFilter dataFilter) {
        if (dataFilter == null) {
            return false;
        }
        for (List<DataFilter.DataFilterEntry> list : dataFilter.getFilterLists()) {
            for (DataFilter.DataFilterEntry dataFilterEntry : list) {
                if (!dataFilterEntry.getColumnKey().startsWith("UserAdhoc")) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    private @Nonnull List< @Nonnull TemplateDataViewDefaults.Column> a(@Nonnull Engine engine) throws ReportException {
        DataSourceUtils.ColumnInfoWithLabel columnInfoWithLabel;
        int n2;
        String string;
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)"Users");
        if (dataSourceConfiguration == null) {
            throw new IllegalStateException("Datasource Users is missing");
        }
        DatabaseTables databaseTables = engine.getDatabaseTables();
        Datasource datasource = databaseTables.getDatasource(0);
        datasource.setDataSourceConfiguration(dataSourceConfiguration);
        ArrayList< @Nonnull TemplateDataViewDefaults.Column> arrayList = new ArrayList<TemplateDataViewDefaults.Column>();
        DataFactory dataFactory = datasource.getDataFactory();
        TableSource tableSource = datasource.createTableSource("UserAdhoc");
        List list = dataFactory.getColumns(tableSource);
        String string2 = tableSource.getAlias() + ".";
        for (ColumnInfo columnInfo : list) {
            string = columnInfo.getName();
            n2 = columnInfo.getDataType();
            tableSource.addColumn(string, n2);
            if (columnInfo.getColumnType() != 3) continue;
            columnInfoWithLabel = (DataSourceUtils.ColumnInfoWithLabel)columnInfo;
            arrayList.add(new TemplateDataViewDefaults.Column(string2 + string, columnInfoWithLabel.getLabel(), n2));
        }
        dataFactory = datasource.getDataFactory();
        tableSource = datasource.createTableSource("UserGroups");
        list = dataFactory.getColumns(tableSource);
        string2 = tableSource.getAlias() + ".";
        for (ColumnInfo columnInfo : list) {
            string = columnInfo.getName();
            n2 = columnInfo.getDataType();
            tableSource.addColumn(string, n2);
            if (columnInfo.getColumnType() != 3) continue;
            columnInfoWithLabel = (DataSourceUtils.ColumnInfoWithLabel)columnInfo;
            String string3 = columnInfoWithLabel.getLabel();
            string3 = this.a(string3, arrayList);
            arrayList.add(new TemplateDataViewDefaults.Column(string2 + string, string3, n2));
        }
        return arrayList;
    }

    private String a(String string, List< @Nonnull TemplateDataViewDefaults.Column> list) {
        if (list.stream().anyMatch(column -> column.getDisplayName().equals(string))) {
            return string + " " + AdHocServerPlugin.SERVER_MSG.getMsg("suffix_duplicated_column_usergroup", new Object[0]);
        }
        return string;
    }

    @Override
    @Nullable
    public List<LocalizedKey> getFilterSuggestions(@Nonnull Engine engine, @Nonnull String filterColumn, @Nonnull String filterText) {
        if (filterColumn.startsWith("UserAdhoc")) {
            return DataView_Users.getSuggestedValuesForUserColumn(filterColumn, filterText);
        }
        if (filterColumn.startsWith("UserGroups")) {
            String string = filterColumn.substring("UserGroups".length() + 1);
            GroupFieldDefinition groupFieldDefinition = UsersAndGroups.getUserGroupFieldDefinitionByKey((String)string);
            if (groupFieldDefinition != null && groupFieldDefinition instanceof HasSelectOptions) {
                if (filterText.isEmpty()) {
                    filterText = null;
                }
                return ((HasSelectOptions)groupFieldDefinition).getSelectOptions(false).stream().map(selectOption -> new LocalizedKey(selectOption.getValue(), selectOption.getLabel())).collect(Collectors.toList());
            }
            SearchTag searchTag = UserGroupManager.getInstance().getSearchEngine().getTag(string);
            if (searchTag != null) {
                if (!searchTag.isSuggestedTag()) {
                    Iterator iterator = UserGroupManager.getInstance().getSearchEngine().createValuesIterator(searchTag, true);
                    ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                    while (arrayList.size() < 50 && iterator.hasNext()) {
                        Optional<GroupTypeDef> optional;
                        String string2;
                        String string3 = (String)iterator.next();
                        String string4 = string2 = string3 == null ? "" : string3.toString();
                        if (string.equals("grouptype") && (optional = ServerPluginManager.getInstance().get(GroupTypeDef.class).stream().filter(groupTypeDef -> groupTypeDef.getGroupType().getName().equals(string2)).findFirst()).isPresent()) {
                            string4 = optional.get().getDisplayName();
                        }
                        if (!string2.toLowerCase().startsWith(filterText)) continue;
                        arrayList.add(new LocalizedKey(string4, string4));
                    }
                    return arrayList;
                }
                Object object = searchTag.getDisplayName() + ":" + filterText;
                object = ((String)object).trim();
                return UserGroupManager.getInstance().getSearchEngine().getSuggestedValues((String)object, null).stream().map(suggestedValue -> new LocalizedKey(String.valueOf(suggestedValue.getKey()), suggestedValue.getDisplayName())).toList();
            }
        }
        return null;
    }
}

