/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.handler.data;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ai.api.ConversationStep;
import com.inet.plugin.ai.api.MarkDownChunks;
import com.inet.report.adhoc.server.ai.d;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class AiGetHistoryRequest {
    private String clientId;

    private AiGetHistoryRequest() {
    }

    public String getClientId() {
        return this.clientId;
    }

    @JsonData
    public static class ConversationMessage {
        private boolean userinput;
        private String text;
        private boolean tool;

        public static void appendTo(@Nonnull List<ConversationMessage> target, @Nonnull ConversationStep conversationStep) {
            switch (conversationStep.getStepType()) {
                case user: {
                    if (StringFunctions.isEmpty((String)conversationStep.getText())) break;
                    ConversationMessage conversationMessage = new ConversationMessage();
                    conversationMessage.text = conversationStep.getText();
                    conversationMessage.userinput = true;
                    target.add(conversationMessage);
                    break;
                }
                case assistant: {
                    if (!StringFunctions.isEmpty((String)conversationStep.getText())) {
                        ConversationMessage conversationMessage = new ConversationMessage();
                        conversationMessage.text = MarkDownChunks.CONVERTER.convert(conversationStep.getText());
                        target.add(conversationMessage);
                    }
                    conversationStep.calls((functionName, parameters) -> {
                        ConversationMessage conversationMessage = new ConversationMessage();
                        conversationMessage.text = d.a(functionName, parameters);
                        conversationMessage.tool = true;
                        target.add(conversationMessage);
                    });
                    break;
                }
            }
        }
    }
}

