/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.dataview.user;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.adhoc.server.api.datasource.UserDataSourceConfiguration;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.dataview.d;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DataView_Users
extends d {
    public static final String KEY = "users";

    public DataView_Users() {
        this.setOverriddenHasAccessFunction(gUID -> SystemPermissionChecker.hasAnyPermission((GUID)gUID, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER}));
    }

    @Nonnull
    public String getExtensionName() {
        return KEY;
    }

    @Override
    @Nullable
    public String getDescription() {
        return AdHocServerPlugin.SERVER_MSG.getMsg("Dataview_users_description", new Object[0]);
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return AdHocServerPlugin.SERVER_MSG.getMsg("Dataview_users", new Object[0]);
    }

    @Override
    @Nonnull
    public @Nonnull List< @Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)"Users");
        if (dataSourceConfiguration == null) {
            throw new IllegalStateException("Datasource Users is missing");
        }
        try {
            Engine engine = RDC.createEmptyEngine((String)"java");
            return this.a(engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    @Override
    @Nullable
    public <T> T get_default(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            ArrayList<TableColumnData> arrayList = new ArrayList<TableColumnData>();
            arrayList.add(new TableColumnData("UserAdhoc.username"));
            if (DataSourceUtils.userFieldIsVisible(UsersAndGroups.FIELD_FIRSTNAME)) {
                arrayList.add(new TableColumnData("UserAdhoc." + UsersAndGroups.FIELD_FIRSTNAME.getKey()));
            }
            if (DataSourceUtils.userFieldIsVisible(UsersAndGroups.FIELD_LASTNAME)) {
                arrayList.add(new TableColumnData("UserAdhoc." + UsersAndGroups.FIELD_LASTNAME.getKey()));
            }
            if (DataSourceUtils.userFieldIsVisible(UsersAndGroups.FIELD_EMAIL)) {
                arrayList.add(new TableColumnData("UserAdhoc." + UsersAndGroups.FIELD_EMAIL.getKey()));
            }
            return (T)arrayList.toArray(new TableColumnData[arrayList.size()]);
        }
        if (key == FILTER_DEFINITION) {
            return (T)new DataFilter(List.of(List.of(new DataFilter.DataFilterEntry("UserAdhoc.userActive", DataFilter.Operation.equals, new LocalizedKey("true", null), null))));
        }
        return null;
    }

    @Override
    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            List<@Nonnull LocalizedKey> list = this.a(engine);
            DatabaseTables databaseTables = engine.getDatabaseTables();
            TableSource tableSource = databaseTables.getTablesource("UserAdhoc");
            DataViewConditions dataViewConditions = new DataViewConditions(filter == null ? new DataFilter(List.of()) : filter, List.of());
            String string = new Json().toJson((Object)dataViewConditions);
            UserDataSourceConfiguration.buildSearchExpressionFromFilter(dataViewConditions);
            DataSourceUtils.setInputParameter(tableSource, "UserSearchPhrase", string);
            this.setSelectionFormula(engine, filter);
            return new SimpleDataView(list, engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    @Nonnull
    private @Nonnull List< @Nonnull TemplateDataViewDefaults.Column> a(@Nonnull Engine engine) throws ReportException {
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)"Users");
        if (dataSourceConfiguration == null) {
            throw new IllegalStateException("Datasource Users is missing");
        }
        DatabaseTables databaseTables = engine.getDatabaseTables();
        Datasource datasource = databaseTables.getDatasource(0);
        datasource.setDataSourceConfiguration(dataSourceConfiguration);
        ArrayList< @Nonnull TemplateDataViewDefaults.Column> arrayList = new ArrayList<TemplateDataViewDefaults.Column>();
        DataFactory dataFactory = datasource.getDataFactory();
        TableSource tableSource = datasource.createTableSource("UserAdhoc");
        List list = dataFactory.getColumns(tableSource);
        String string = tableSource.getAlias() + ".";
        for (ColumnInfo columnInfo : list) {
            String string2 = columnInfo.getName();
            int n2 = columnInfo.getDataType();
            tableSource.addColumn(string2, n2);
            if (columnInfo.getColumnType() != 3) continue;
            DataSourceUtils.ColumnInfoWithLabel columnInfoWithLabel = (DataSourceUtils.ColumnInfoWithLabel)columnInfo;
            arrayList.add(new TemplateDataViewDefaults.Column(string + string2, columnInfoWithLabel.getLabel(), n2));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public List<LocalizedKey> getFilterSuggestions(@Nonnull Engine engine, @Nonnull String filterColumn, @Nonnull String filterText) {
        if (filterColumn.startsWith("UserAdhoc")) {
            return DataView_Users.getSuggestedValuesForUserColumn(filterColumn, filterText);
        }
        return null;
    }

    public static List<LocalizedKey> getSuggestedValuesForUserColumn(String filterColumn, String filterText) {
        String string = filterColumn.substring("UserAdhoc".length() + 1);
        UserFieldDefinition userFieldDefinition = UsersAndGroups.getUserFieldDefinitionByKey((String)string);
        if (userFieldDefinition != null) {
            if (!(userFieldDefinition instanceof SelectUserFieldDefinition)) {
                Object object = userFieldDefinition.getLabel() + ":" + filterText;
                object = ((String)object).trim();
                if (!UsersAndGroups.getFieldByKey((String)string).getSearchTag().isSuggestedTag()) {
                    Iterator iterator = UserManager.getInstance().getSearchEngine().createValuesIterator(UsersAndGroups.getFieldByKey((String)string).getSearchTag(), true);
                    ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                    while (arrayList.size() < 50 && iterator.hasNext()) {
                        String string2;
                        String string3 = (String)iterator.next();
                        String string4 = string2 = string3 == null ? "" : string3.toString();
                        if (!string2.toLowerCase().startsWith(filterText)) continue;
                        arrayList.add(new LocalizedKey(string2, string2));
                    }
                    return arrayList;
                }
                return UserManager.getInstance().getSearchEngine().getSuggestedValues((String)object, null).stream().map(suggestedValue -> {
                    String string = suggestedValue.getKey();
                    if (string.startsWith("value:")) {
                        string = string.substring("value:".length());
                    }
                    return new LocalizedKey(string, suggestedValue.getDisplayName());
                }).toList();
            }
            if (filterText.isEmpty()) {
                filterText = null;
            }
            return DataSourceUtils.selectOptionsToLocalizedKeys(((SelectUserFieldDefinition)userFieldDefinition).getOptions(null, filterText, 0, 50).getOptions(), string);
        }
        return null;
    }
}

