/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.dataview;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class DataFilter {
    @Nonnull
    private List<List<DataFilterEntry>> filterList;

    private DataFilter() {
    }

    public DataFilter(@Nonnull List<List<DataFilterEntry>> filterLists) {
        this.filterList = filterLists;
    }

    @Nonnull
    public List<List<DataFilterEntry>> getFilterLists() {
        return this.filterList;
    }

    @JsonData
    @PublicApi
    public static class DataFilterEntry {
        @Nonnull
        private String column;
        @Nonnull
        private Operation operation;
        private LocalizedKey value;
        @JsonExcludeNull
        private LocalizedKey secondValue;

        private DataFilterEntry() {
        }

        public DataFilterEntry(@Nonnull String columnKey, @Nonnull Operation operation, @Nonnull String value, @Nullable String secondValue) {
            this(columnKey, operation, new LocalizedKey(value, value), secondValue != null ? new LocalizedKey(secondValue, secondValue) : null);
        }

        public DataFilterEntry(@Nonnull String columnKey, @Nonnull Operation operation, @Nonnull LocalizedKey value, @Nullable LocalizedKey secondValue) {
            this.column = columnKey;
            this.operation = operation;
            this.value = value;
            this.secondValue = secondValue;
        }

        @Nonnull
        public String getColumnKey() {
            return this.column;
        }

        @Nonnull
        public Operation getOperation() {
            return this.operation;
        }

        @Nonnull
        public String getValue() {
            return this.value == null ? "" : this.value.getKey();
        }

        @Nonnull
        public LocalizedKey getLocalizedValue() {
            return this.value;
        }

        @Nullable
        public String getSecondValue() {
            return this.secondValue != null ? this.secondValue.getKey() : null;
        }

        @Nullable
        public LocalizedKey getLocalizedSecondValue() {
            return this.secondValue;
        }
    }

    @PublicApi
    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation equals = new Operation();
        public static final /* enum */ Operation notequals = new Operation();
        public static final /* enum */ Operation lessthan = new Operation();
        public static final /* enum */ Operation lessthanequals = new Operation();
        public static final /* enum */ Operation greaterthan = new Operation();
        public static final /* enum */ Operation greaterthanequals = new Operation();
        public static final /* enum */ Operation contains = new Operation();
        public static final /* enum */ Operation notcontains = new Operation();
        public static final /* enum */ Operation startswith = new Operation();
        public static final /* enum */ Operation notstartswith = new Operation();
        public static final /* enum */ Operation endswith = new Operation();
        public static final /* enum */ Operation notendswith = new Operation();
        public static final /* enum */ Operation inrange = new Operation();
        public static final /* enum */ Operation notinrange = new Operation();
        private static final /* synthetic */ Operation[] bZ;

        public static Operation[] values() {
            return (Operation[])bZ.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        private static /* synthetic */ Operation[] K() {
            return new Operation[]{equals, notequals, lessthan, lessthanequals, greaterthan, greaterthanequals, contains, notcontains, startswith, notstartswith, endswith, notendswith, inrange, notinrange};
        }

        static {
            bZ = Operation.K();
        }
    }
}

