/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.datasource;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.Field;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeGUID;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.id.GUID;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.DefaultValue;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.database.ColumnInfo;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DataSourceUtils {
    public static boolean showDisplayValueForField(Field<?> field) {
        if (field == null) {
            return true;
        }
        if (field.renderDisplayValueInReporting()) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeDate) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeString) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeBoolean) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeInteger) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeSelect_Int) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeSelect_String) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeGUID) {
            return true;
        }
        if (field.getFieldType() instanceof FieldTypeTime) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeCurrency) {
            return false;
        }
        if (field.getFieldType() instanceof FieldTypeDouble) {
            return false;
        }
        return !(field.getFieldType() instanceof FieldTypeRating);
    }

    @Nullable
    public static Object convertFieldValueToReportingValue(@Nullable Object value, Field<?> field) {
        if (value == null) {
            return value;
        }
        if (field.getFieldType() instanceof FieldTypeGUID) {
            return ((GUID)value).toString();
        }
        if (field.getFieldType() instanceof FieldTypeTime) {
            try {
                String string = (String)value;
                int n2 = Integer.valueOf(string.substring(0, 2));
                int n3 = Integer.valueOf(string.substring(3, 5));
                return new Time(n2, n3, 0);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                return null;
            }
        }
        if (field.getFieldType() instanceof FieldTypeDate) {
            return new Date((Long)value);
        }
        if (field.getFieldType() instanceof FieldTypeRating) {
            return (double)((Integer)value).intValue() / 2.0;
        }
        return value;
    }

    public static int apiFieldTypeToReportFieldType(Field<?> field) {
        int n2 = field.getFieldType() instanceof FieldTypeDate ? (((FieldTypeDate)field.getFieldType()).isDateWithTime() ? 15 : 9) : (field.getFieldType() instanceof FieldTypeString ? 11 : (field.getFieldType() instanceof FieldTypeBoolean ? 8 : (field.getFieldType() instanceof FieldTypeInteger ? 6 : (field.getFieldType() instanceof FieldTypeSelect_Int ? 6 : (field.getFieldType() instanceof FieldTypeSelect_String ? 11 : (field.getFieldType() instanceof FieldTypeGUID ? 11 : (field.getFieldType() instanceof FieldTypeTime ? 10 : (field.getFieldType() instanceof FieldTypeCurrency ? 7 : (field.getFieldType() instanceof FieldTypeDouble ? 6 : 11)))))))));
        return n2;
    }

    public static AndSearchExpression buildSearchPhraseExpression(@Nonnull DataViewConditions filter, String tableAlias, Function<String, Field<?>> hasSearchTag, @Nonnull IndexSearchEngine<?> searchEngine, Map<String, JoinTokenInfo> joinTokenTables) {
        SearchExpression searchExpression;
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        if (!filter.getFilter().getFilterLists().isEmpty()) {
            OrSearchExpression orSearchExpression = new OrSearchExpression();
            Iterator<List<DataFilter.DataFilterEntry>> object = filter.getFilter().getFilterLists().iterator();
            while (object.hasNext()) {
                searchExpression = object.next();
                AndSearchExpression andSearchExpression2 = new AndSearchExpression();
                ArrayList<DataFilter.DataFilterEntry> arrayList = new ArrayList<DataFilter.DataFilterEntry>();
                Iterator iterator = searchExpression.iterator();
                while (iterator.hasNext()) {
                    DataFilter.DataFilterEntry dataFilterEntry = (DataFilter.DataFilterEntry)iterator.next();
                    SearchExpression searchExpression2 = DataSourceUtils.a(dataFilterEntry, tableAlias, joinTokenTables, hasSearchTag, searchEngine);
                    if (searchExpression2 != null) {
                        andSearchExpression2.add(searchExpression2);
                        iterator.remove();
                        continue;
                    }
                    if (dataFilterEntry.getLocalizedValue().getDisplayName() == null) continue;
                    iterator.remove();
                    LocalizedKey localizedKey = new LocalizedKey(dataFilterEntry.getLocalizedValue().getDisplayName(), dataFilterEntry.getLocalizedValue().getDisplayName());
                    LocalizedKey localizedKey2 = dataFilterEntry.getLocalizedSecondValue();
                    LocalizedKey localizedKey3 = localizedKey2 != null ? new LocalizedKey(localizedKey2.getDisplayName(), localizedKey2.getDisplayName()) : null;
                    arrayList.add(new DataFilter.DataFilterEntry(dataFilterEntry.getColumnKey(), dataFilterEntry.getOperation(), localizedKey, localizedKey3));
                }
                searchExpression.addAll(arrayList);
                DataSourceUtils.a(andSearchExpression2);
                if (!andSearchExpression2.isEmpty()) {
                    orSearchExpression.add((Object)andSearchExpression2);
                }
                if (!searchExpression.isEmpty()) continue;
                object.remove();
            }
            if (!orSearchExpression.isEmpty()) {
                andSearchExpression.add((SearchExpression)orSearchExpression);
            }
        }
        if (!filter.getConditionsFromView().isEmpty()) {
            for (DataFilter.DataFilterEntry dataFilterEntry : filter.getConditionsFromView()) {
                searchExpression = DataSourceUtils.a(dataFilterEntry, tableAlias, joinTokenTables, hasSearchTag, searchEngine);
                if (searchExpression == null) continue;
                andSearchExpression.add(searchExpression);
            }
        }
        return andSearchExpression;
    }

    @Nullable
    private static SearchExpression a(DataFilter.DataFilterEntry dataFilterEntry, String string, Map<String, JoinTokenInfo> map, Function<String, Field<?>> function, @Nonnull IndexSearchEngine<?> indexSearchEngine) {
        String string3;
        Field<?> field;
        String string4 = dataFilterEntry.getColumnKey();
        if (string4.startsWith(string) && (field = function.apply(string3 = string4.substring(string.length() + 1))) != null && field.getSearchTag() != null) {
            String string5 = field.getKey();
            boolean bl = field.getKey().contains("owner") && field.getFieldType() instanceof FieldTypeGUID;
            Object object = DataSourceUtils.a(dataFilterEntry, field);
            SearchCondition.SearchTermOperator searchTermOperator = DataSourceUtils.a(dataFilterEntry, field, bl);
            if (searchTermOperator == null) {
                return null;
            }
            if (searchTermOperator == SearchCondition.SearchTermOperator.Equals && (object == null || "".equals(object))) {
                return new PhraseSearchExpression(string5, searchTermOperator, "", Set.of());
            }
            if (bl) {
                if (searchTermOperator == SearchCondition.SearchTermOperator.BETWEEN || searchTermOperator == SearchCondition.SearchTermOperator.NOT_BETWEEN) {
                    return null;
                }
                JoinTokenMatcher joinTokenMatcher = new JoinTokenMatcher(indexSearchEngine, field.getSearchTag(), UserManager.getInstance().getSearchEngine(), UserManager.getInstance().getSearchEngine().getTag("useraccountdisplayname"), false);
                return joinTokenMatcher.createSearchExpression(dataFilterEntry.getValue(), searchTermOperator, false, false);
            }
            if (searchTermOperator == SearchCondition.SearchTermOperator.BETWEEN || searchTermOperator == SearchCondition.SearchTermOperator.NOT_BETWEEN) {
                return new SearchCondition(string5, searchTermOperator, (Object)new Object[]{object, dataFilterEntry.getSecondValue()});
            }
            if (searchTermOperator == SearchCondition.SearchTermOperator.Unequals && (object == null || "".equals(object))) {
                return new SearchCondition(string5, SearchCondition.SearchTermOperator.StartsWith, (Object)"");
            }
            if (object instanceof String && (searchTermOperator == SearchCondition.SearchTermOperator.Equals || searchTermOperator == SearchCondition.SearchTermOperator.Unequals)) {
                Set set = TextSearchTokenizer.DEFAULT.tokens(object, 1);
                return new PhraseSearchExpression(string5, searchTermOperator, object.toString(), (Collection)set);
            }
            return new SearchCondition(string5, searchTermOperator, object);
        }
        boolean bl = map.keySet().stream().anyMatch(string2 -> string4.startsWith((String)string2));
        if (bl) {
            return DataSourceUtils.a(dataFilterEntry, map, indexSearchEngine);
        }
        return null;
    }

    private static void a(AndSearchExpression andSearchExpression) {
        SearchExpression searchExpression;
        SearchCondition searchCondition = null;
        ArrayList<SearchCondition> arrayList = null;
        for (int i2 = 0; i2 < andSearchExpression.size(); ++i2) {
            SearchExpression searchExpression2 = (SearchExpression)andSearchExpression.get(i2);
            if (searchExpression2 instanceof SearchCondition) {
                SearchCondition searchCondition2 = (SearchCondition)searchExpression2;
                if (searchCondition != null && Objects.equals(searchCondition2.getLeftOperand(), searchCondition.getLeftOperand())) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<SearchCondition>();
                        arrayList.add(searchCondition);
                    }
                    arrayList.add(searchCondition2);
                    searchCondition = searchCondition2;
                    continue;
                }
                if (arrayList != null) {
                    SearchExpression searchExpression3 = DataSourceUtils.b(arrayList);
                    if (searchExpression3 != null) {
                        andSearchExpression.removeAll(arrayList);
                        andSearchExpression.add(i2 - arrayList.size() + 1, (Object)searchExpression3);
                        i2 = i2 - arrayList.size() + 1;
                    }
                    arrayList = null;
                }
                searchCondition = searchCondition2;
                continue;
            }
            searchCondition = null;
        }
        if (arrayList != null && (searchExpression = DataSourceUtils.b(arrayList)) != null) {
            andSearchExpression.removeAll(arrayList);
            andSearchExpression.add(searchExpression);
        }
    }

    private static SearchExpression b(List<SearchCondition> list) {
        OrSearchExpression orSearchExpression = new OrSearchExpression();
        SearchCondition searchCondition = null;
        AndSearchExpression andSearchExpression = null;
        for (SearchCondition searchCondition2 : list) {
            if (searchCondition != null && DataSourceUtils.a(searchCondition.getOperator()) && DataSourceUtils.a(searchCondition2.getOperator())) {
                if (andSearchExpression == null) {
                    andSearchExpression = new AndSearchExpression();
                    andSearchExpression.add((SearchExpression)searchCondition);
                    orSearchExpression.remove((Object)searchCondition);
                    orSearchExpression.add((Object)andSearchExpression);
                }
                andSearchExpression.add((SearchExpression)searchCondition2);
            } else {
                andSearchExpression = null;
                orSearchExpression.add((Object)searchCondition2);
            }
            searchCondition = searchCondition2;
        }
        return orSearchExpression;
    }

    private static boolean a(SearchCondition.SearchTermOperator searchTermOperator) {
        switch (searchTermOperator) {
            case Unequals: 
            case NOT_BETWEEN: {
                return true;
            }
            case BETWEEN: {
                break;
            }
            case Contains: {
                break;
            }
            case Equals: {
                break;
            }
            case GE: {
                break;
            }
            case GT: {
                break;
            }
            case IN: {
                break;
            }
            case LE: {
                break;
            }
            case LT: {
                break;
            }
            case StartsWith: {
                break;
            }
        }
        return false;
    }

    private static SearchCondition.SearchTermOperator a(DataFilter.DataFilterEntry dataFilterEntry, Field<?> field, boolean bl) {
        boolean bl2 = DataSourceUtils.showDisplayValueForField(field) && !(field.getFieldType() instanceof FieldTypeString) && !bl;
        SearchCondition.SearchTermOperator searchTermOperator = null;
        switch (dataFilterEntry.getOperation()) {
            case contains: {
                if (bl2) break;
                searchTermOperator = SearchCondition.SearchTermOperator.Contains;
                break;
            }
            case equals: {
                searchTermOperator = SearchCondition.SearchTermOperator.Equals;
                break;
            }
            case greaterthan: {
                searchTermOperator = SearchCondition.SearchTermOperator.GT;
                break;
            }
            case greaterthanequals: {
                searchTermOperator = SearchCondition.SearchTermOperator.GE;
                break;
            }
            case inrange: {
                searchTermOperator = SearchCondition.SearchTermOperator.BETWEEN;
                break;
            }
            case lessthan: {
                searchTermOperator = SearchCondition.SearchTermOperator.LT;
                break;
            }
            case lessthanequals: {
                searchTermOperator = SearchCondition.SearchTermOperator.LE;
                break;
            }
            case notequals: {
                searchTermOperator = SearchCondition.SearchTermOperator.Unequals;
                break;
            }
            case startswith: {
                if (bl2) break;
                searchTermOperator = SearchCondition.SearchTermOperator.StartsWith;
                break;
            }
            case notinrange: {
                if (bl2) break;
                searchTermOperator = SearchCondition.SearchTermOperator.NOT_BETWEEN;
                break;
            }
        }
        return searchTermOperator;
    }

    private static Object a(DataFilter.DataFilterEntry dataFilterEntry, Field<?> field) {
        Object object = dataFilterEntry.getValue();
        if (object != null) {
            FieldType fieldType = field.getFieldType();
            if (fieldType instanceof FieldTypeBoolean) {
                object = "true".equals(object) ? Integer.valueOf(1) : Integer.valueOf(0);
            } else {
                try {
                    object = fieldType.valueOf(dataFilterEntry.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return object;
    }

    private static SearchExpression a(DataFilter.DataFilterEntry dataFilterEntry, Map<String, JoinTokenInfo> map, @Nonnull IndexSearchEngine<?> indexSearchEngine) {
        JoinTokenMatcher joinTokenMatcher;
        Object object2;
        String string = dataFilterEntry.getColumnKey();
        String string2 = string.substring(0, string.indexOf("."));
        String string3 = string.substring(string2.length() + 1);
        JoinTokenInfo joinTokenInfo = map.get(string2);
        JoinTokenMatcher joinTokenMatcher2 = null;
        for (Object object2 : indexSearchEngine.getTokenMatcher()) {
            if (!(object2 instanceof JoinTokenMatcher) || (joinTokenMatcher = (JoinTokenMatcher)object2).getChildSearchEngine() != joinTokenInfo.bM || !joinTokenMatcher.getChildSuggestedTag().getTag().equals(string3) || !joinTokenMatcher.getParentSuggestedTag().getTag().equals(joinTokenInfo.bN)) continue;
            joinTokenMatcher2 = joinTokenMatcher;
            break;
        }
        if (joinTokenMatcher2 == null) {
            return null;
        }
        Iterator iterator = map.get((Object)string2).bO.apply(string3);
        if (iterator == null) {
            return null;
        }
        object2 = DataSourceUtils.a(dataFilterEntry, iterator);
        joinTokenMatcher = DataSourceUtils.a(dataFilterEntry, iterator, false);
        if (joinTokenMatcher == null) {
            return null;
        }
        if (joinTokenMatcher == SearchCondition.SearchTermOperator.Equals && (object2 == null || "".equals(object2))) {
            return new PhraseSearchExpression(string3, (SearchCondition.SearchTermOperator)joinTokenMatcher, "", Set.of());
        }
        if (joinTokenMatcher == SearchCondition.SearchTermOperator.BETWEEN || joinTokenMatcher == SearchCondition.SearchTermOperator.NOT_BETWEEN) {
            return null;
        }
        if (joinTokenMatcher == SearchCondition.SearchTermOperator.Unequals && (object2 == null || "".equals(object2))) {
            return joinTokenMatcher2.createSearchExpression("", SearchCondition.SearchTermOperator.StartsWith, false, false);
        }
        if (object2 instanceof String && object2.toString().contains(" ")) {
            return null;
        }
        return joinTokenMatcher2.createSearchExpression(dataFilterEntry.getValue(), (SearchCondition.SearchTermOperator)joinTokenMatcher, false, true);
    }

    public static final boolean userFieldIsVisible(UserField<?> field) {
        UserFieldDefinition userFieldDefinition = UsersAndGroups.getUserFieldDefinitionByKey((String)field.getKey());
        if (userFieldDefinition == null) {
            return true;
        }
        return userFieldDefinition.isAvailable(null);
    }

    public static void join(DatabaseTables dbTables, TableSource t1, String column1, TableSource toTS, String column2, int fieldType) throws ReportException {
        DataSourceUtils.join(dbTables, t1, column1, toTS, column2, fieldType, 21);
    }

    public static void join(DatabaseTables dbTables, TableSource t1, String column1, TableSource toTS, String column2, int fieldType, int joinType) throws ReportException {
        DatabaseField databaseField;
        DatabaseField databaseField2 = t1.getDatabaseField(column1);
        if (databaseField2 == null) {
            t1.addColumn(column1, fieldType);
            databaseField2 = t1.getDatabaseField(column1);
        }
        if ((databaseField = toTS.getDatabaseField(column2)) == null) {
            toTS.addColumn(column2, fieldType);
            databaseField = toTS.getDatabaseField(column2);
        }
        dbTables.addJoin(t1, databaseField2, toTS, databaseField, joinType, 1);
    }

    public static List<LocalizedKey> selectOptionsToLocalizedKeys(List<SelectOption> options, String key) {
        return options.stream().map(selectOption -> {
            String string2;
            String string3 = string2 = selectOption.getPath() != null ? selectOption.getPath() : selectOption.getLabel();
            if (key.equals("categoryid")) {
                string2 = string2.replace("\\", " \\ ");
            }
            return new LocalizedKey(selectOption.getValue(), string2);
        }).toList();
    }

    public static void setInputParameter(@Nonnull TableSource ts, @Nonnull String paramName, @Nonnull String value) throws ReportException {
        ts.setInputParameter(new String[]{paramName}, new int[]{11}, new Object[]{value});
        for (PromptField promptField : ts.getInputParameters()) {
            if (!paramName.equals(promptField.getName())) continue;
            promptField.addDefaultValue(new DefaultValue((Object)value, null, 11));
            promptField.setEditable(false);
        }
    }

    @InternalApi
    public static class JoinTokenInfo {
        private IndexSearchEngine<?> bM;
        private String bN;
        private Function<String, Field<?>> bO;

        public JoinTokenInfo(IndexSearchEngine<?> searchEngine, String parentSearchtag, Function<String, Field<?>> fieldLocator) {
            this.bM = searchEngine;
            this.bN = parentSearchtag;
            this.bO = fieldLocator;
        }
    }

    @InternalApi
    public static class ColumnInfoWithLabel
    extends ColumnInfo {
        private String label;

        public ColumnInfoWithLabel(@Nonnull String name, @Nonnull String label, int dataType) {
            super(name, dataType);
            this.label = Objects.requireNonNull(label);
        }

        @Nonnull
        public String getLabel() {
            return this.label;
        }
    }
}

