/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.designer;

import com.inet.annotations.JsonData;
import com.inet.report.renderer.doc.Adornment;
import com.inet.report.renderer.html.HtmlStyleWriter;
import com.inet.shared.utils.MemoryStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class RenderedElementStyle {
    @Nonnull
    private String selectorText;
    @Nonnull
    private String rule;

    private RenderedElementStyle() {
    }

    @Nonnull
    public static RenderedElementStyle forElement(@Nonnull String rendererID, @Nonnull @Nonnull Map<@Nonnull String, @Nonnull String> properties) {
        return RenderedElementStyle.forElement(rendererID, properties, null);
    }

    @Nonnull
    public static RenderedElementStyle forElement(@Nonnull String rendererID, @Nonnull @Nonnull Map<@Nonnull String, @Nonnull String> properties, @Nullable Adornment adornment) {
        return new RenderedElementStyle(RenderedElementStyle.createSelectorTextForElementStyle(rendererID), properties, adornment);
    }

    @Nonnull
    public static String createSelectorTextForElementStyle(@Nonnull String renderedID) {
        return "." + RenderedElementStyle.createElementStyleClassName(renderedID);
    }

    @Nonnull
    public static String createElementStyleClassName(@Nonnull String renderedID) {
        return renderedID;
    }

    private RenderedElementStyle(@Nonnull String selectorText, @Nonnull @Nonnull Map<@Nonnull String, @Nonnull String> properties, @Nullable Adornment adornment) {
        ArrayList<@Nonnull String> arrayList = new ArrayList<String>(properties.keySet());
        Collections.sort(arrayList);
        MemoryStream memoryStream = new MemoryStream();
        memoryStream.writeASCII(selectorText);
        memoryStream.writeASCII("{");
        for (String string : arrayList) {
            String string2 = properties.get(string);
            memoryStream.writeASCII(string);
            memoryStream.writeASCII(":");
            memoryStream.writeASCII(string2);
            memoryStream.writeASCII(";");
        }
        if (adornment != null) {
            HtmlStyleWriter.writeAllAdornmentAttributes((Adornment)adornment, (MemoryStream)memoryStream);
        }
        memoryStream.writeASCII("}");
        Object object = memoryStream.toString();
        if (adornment != null) {
            object = ((String)object).replace("\n", "");
        }
        this.selectorText = selectorText;
        this.rule = object;
    }

    @Nonnull
    public String getClassName() {
        return this.selectorText.substring(1);
    }

    @Nonnull
    public String getSelectorText() {
        return this.selectorText;
    }

    @Nonnull
    public String getRule() {
        return this.rule;
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.selectorText);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenderedElementStyle renderedElementStyle = (RenderedElementStyle)obj;
        return Objects.equals(this.rule, renderedElementStyle.rule) && Objects.equals(this.selectorText, renderedElementStyle.selectorText);
    }
}

