/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.dataview.datasource;

import com.inet.cache.MemoryStoreMap;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Fields;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.common.AbstractDefinition;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.DataViewDefinition;
import com.inet.report.adhoc.server.api.dataview.DataViewPropertyKey;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.dataview.datasource.b;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.report.database.TableSourceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
extends com.inet.report.adhoc.server.api.dataview.a {
    @Nonnull
    public static final DataViewPropertyKey<String> cm = new DataViewPropertyKey<String>("datasource.name", String.class);
    @Nonnull
    public static final DataViewPropertyKey<String> cn = new DataViewPropertyKey<String>("datasource.table", String.class);
    private static final HashSet<String> co = new HashSet();
    private static final MemoryStoreMap<String, ArrayList<TableSourceInfo>> cp;

    public a() {
        super("datasource");
    }

    public void a(@Nonnull DataViewDefinition dataViewDefinition) throws ValidationException {
        DataSourceConfiguration dataSourceConfiguration;
        Map map = dataViewDefinition.getProperties();
        String string = map.get(cm);
        if (StringFunctions.isEmpty((String)string)) {
            throw new ValidationException("source", com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.noDataSource", new Object[0]));
        }
        DataSourceConfiguration dataSourceConfiguration2 = dataSourceConfiguration = SystemPermissionChecker.checkAccess((Permission)com.inet.report.adhoc.webgui.b.nl) ? DataSourceConfigurationManager.getDataSource((String)string) : null;
        if (dataSourceConfiguration == null) {
            throw new ValidationException("source", com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.nonExistingDataSource", new Object[]{string}));
        }
        String string2 = map.get(cn);
        if (StringFunctions.isEmpty((String)string2)) {
            throw new ValidationException("source.table", com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.noTable", new Object[0]));
        }
        a.f(string, string2);
    }

    @Override
    @Nonnull
    public DataView a(@Nonnull DataViewDefinition dataViewDefinition, @Nullable DataFilter dataFilter, @Nonnull Engine engine) {
        Map map = dataViewDefinition.getProperties();
        String string = map.get(cm);
        String string2 = map.get(cn);
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)string);
        try {
            DatabaseTables databaseTables = engine.getDatabaseTables();
            Datasource datasource = databaseTables.getDatasource(0);
            datasource.setDataSourceConfiguration(dataSourceConfiguration);
            TableSource tableSource = datasource.createTableSource(string2);
            DataFactory dataFactory = datasource.getDataFactory();
            List list = dataFactory.getColumns(tableSource);
            return a.a(tableSource, list, dataFilter, engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    @Nonnull
    public static DataView a(@Nonnull TableSource tableSource, @Nonnull List<ColumnInfo> list, @Nullable DataFilter dataFilter, @Nonnull Engine engine) throws ReportException {
        Fields fields = engine.getFields();
        String string = tableSource.getAlias() + ".";
        ArrayList<@Nonnull LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        for (ColumnInfo columnInfo : list) {
            String string2 = columnInfo.getName();
            String string3 = string + string2;
            arrayList.add(new LocalizedKey(string3, string2));
            DatabaseField databaseField = fields.getDatabaseField(string3);
            if (databaseField != null) continue;
            tableSource.addColumn(columnInfo.getName(), columnInfo.getDataType());
        }
        b.setSelectionFormula(engine, dataFilter);
        return new SimpleDataView(arrayList, engine);
    }

    public static void f(@Nonnull String string, @Nonnull String string2) {
        for (TableSourceInfo tableSourceInfo : a.n(string)) {
            if (!Objects.equals(string2, tableSourceInfo.getTable())) continue;
            return;
        }
        throw new ValidationException("source.table", com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.tableNotFound", new Object[]{string2}));
    }

    @Nonnull
    public static List<TableSourceInfo> n(@Nonnull String string) {
        ArrayList arrayList = (ArrayList)cp.get((Object)string);
        if (arrayList != null) {
            return Collections.unmodifiableList(arrayList);
        }
        try {
            Engine engine = RDC.createEmptyEngine((String)"java");
            DatabaseTables databaseTables = engine.getDatabaseTables();
            Datasource datasource = databaseTables.createDatasource(string);
            String string2 = datasource.getCatalog();
            if (StringFunctions.isEmpty((String)string2)) {
                string2 = null;
            }
            DataFactory dataFactory = datasource.getDataFactory();
            Map map = dataFactory.getTableSourceInfos(datasource, string2);
            arrayList = new ArrayList(map.values());
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                String string3;
                TableSourceInfo tableSourceInfo = (TableSourceInfo)arrayList.get(i2);
                if (tableSourceInfo.getType() == 1 || co.contains(tableSourceInfo.getSchema())) {
                    arrayList.remove(i2);
                    continue;
                }
                if (tableSourceInfo.getType() != 20 || !(string3 = tableSourceInfo.getTable()).endsWith(";1")) continue;
                string3 = string3.substring(0, string3.length() - 2);
                arrayList.set(i2, new TableSourceInfo(tableSourceInfo.getCatalog(), tableSourceInfo.getSchema(), string3, tableSourceInfo.getType()));
            }
            cp.put((Object)string, arrayList);
            return Collections.unmodifiableList(arrayList);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    @Override
    public /* synthetic */ void validate(@Nonnull AbstractDefinition abstractDefinition) throws ValidationException {
        this.a((DataViewDefinition)abstractDefinition);
    }

    static {
        co.add("INFORMATION_SCHEMA");
        co.add("sys");
        cp = new MemoryStoreMap(60, true);
    }
}

