/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.controls;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.renderer.AdHocDefinition;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.renderer.a;
import com.inet.report.adhoc.webgui.controls.GroupControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ComponentSettings
extends LocalizedKey {
    private final List<GroupControl> groups = new ArrayList<GroupControl>();
    private Map<String, String> defaultValues = new HashMap<String, String>();
    private boolean expandContent;
    private boolean themeChangeRequiredRendering;
    private ComponentLocation location;

    public ComponentSettings(@Nonnull String componentType) {
        this(componentType, a.bm.getMsg(componentType, new Object[0]));
    }

    public ComponentSettings(@Nonnull String componentType, @Nonnull String componentLabel) {
        this(componentType, componentLabel, ComponentLocation.body);
    }

    public ComponentSettings(@Nonnull String componentType, @Nonnull ComponentLocation location) {
        this(componentType, a.bm.getMsg(componentType, new Object[0]), location);
    }

    public ComponentSettings(@Nonnull String componentType, @Nonnull String componentLabel, @Nonnull ComponentLocation location) {
        super(componentType, componentLabel);
        this.location = location;
    }

    public ComponentLocation getComponentLocation() {
        return this.location;
    }

    public void setExpandContent(boolean expandContent) {
        this.expandContent = expandContent;
    }

    public void setThemeChangeRequiredRendering(boolean themeChangeRequiredRendering) {
        this.themeChangeRequiredRendering = themeChangeRequiredRendering;
    }

    @Nonnull
    public GroupControl addGroup(@Nonnull String key) {
        GroupControl groupControl = new GroupControl(key);
        this.groups.add(groupControl);
        return groupControl;
    }

    @Nonnull
    public GroupControl addGroup(@Nonnull String key, @Nullable String label) {
        GroupControl groupControl = new GroupControl(key, label);
        this.groups.add(groupControl);
        return groupControl;
    }

    public void addDefaultValue(String key, String value) {
        this.defaultValues.put(key, value);
    }

    @Nonnull
    public static AdHocDefinition toServerModel(@Nonnull GUID componentId, @Nonnull String componentType, @Nonnull Map<String, String> uiModel, boolean validate) throws ValidationException {
        AdHocRendererFactory adHocRendererFactory = (AdHocRendererFactory)ServerPluginManager.getInstance().getSingleInstanceByName(AdHocRendererFactory.class, componentType, false);
        HashMap hashMap = new HashMap();
        adHocRendererFactory.convertUiModeltoServerModel(uiModel, hashMap);
        AdHocDefinition adHocDefinition = new AdHocDefinition(componentId, componentType, hashMap);
        if (validate) {
            adHocRendererFactory.validate(adHocDefinition);
        }
        return adHocDefinition;
    }

    @Nonnull
    public static Map<String, String> toUiModel(@Nonnull AdHocDefinition definition) {
        AdHocRendererFactory adHocRendererFactory = (AdHocRendererFactory)ServerPluginManager.getInstance().getSingleInstanceByName(AdHocRendererFactory.class, definition.getExtensionName(), false);
        Map<RendererPropertyKey<?>, String> map = definition.getProperties();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        adHocRendererFactory.convertServerModeltoUiModel(map, hashMap);
        return hashMap;
    }

    @InternalApi
    public static final class ComponentLocation
    extends Enum<ComponentLocation> {
        public static final /* enum */ ComponentLocation body = new ComponentLocation();
        public static final /* enum */ ComponentLocation header = new ComponentLocation();
        public static final /* enum */ ComponentLocation footer = new ComponentLocation();
        private static final /* synthetic */ ComponentLocation[] ny;

        public static ComponentLocation[] values() {
            return (ComponentLocation[])ny.clone();
        }

        public static ComponentLocation valueOf(String name) {
            return Enum.valueOf(ComponentLocation.class, name);
        }

        private static /* synthetic */ ComponentLocation[] bM() {
            return new ComponentLocation[]{body, header, footer};
        }

        static {
            ny = ComponentLocation.bM();
        }
    }
}

