/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.renderer.chart;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.SelectOption;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.dataview.PersistenceTemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.AdHocDefinition;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.renderer.DataField;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.PreviewData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.theming.ThemePropertyKey;
import com.inet.report.adhoc.server.renderer.a;
import com.inet.report.adhoc.server.renderer.chart.b;
import com.inet.report.adhoc.server.renderer.chart.g;
import com.inet.report.adhoc.server.renderer.chart.i;
import com.inet.report.adhoc.server.renderer.chart.j;
import com.inet.report.adhoc.server.renderer.chart.l;
import com.inet.report.adhoc.server.renderer.chart.m;
import com.inet.report.adhoc.server.renderer.chart.model.BarAndLineChartDataset;
import com.inet.report.adhoc.server.theming.AdHocTheme;
import com.inet.report.adhoc.webgui.controls.BaseControl;
import com.inet.report.adhoc.webgui.controls.BooleanControl;
import com.inet.report.adhoc.webgui.controls.ColorControl;
import com.inet.report.adhoc.webgui.controls.ColorSchemeControl;
import com.inet.report.adhoc.webgui.controls.ColumnsControl;
import com.inet.report.adhoc.webgui.controls.ColumnsSection;
import com.inet.report.adhoc.webgui.controls.ComponentSettings;
import com.inet.report.adhoc.webgui.controls.ConditionalLocalizedkey;
import com.inet.report.adhoc.webgui.controls.DataFilterControl;
import com.inet.report.adhoc.webgui.controls.DataSelectControl;
import com.inet.report.adhoc.webgui.controls.GroupControl;
import com.inet.report.adhoc.webgui.controls.ImageSelectControl;
import com.inet.report.adhoc.webgui.controls.SelectControl;
import com.inet.report.adhoc.webgui.controls.SliderControl;
import com.inet.report.adhoc.webgui.controls.TextControl;
import com.inet.report.adhoc.webgui.handler.data.ColumnSelectOption;
import com.inet.shared.utils.MemoryStream;
import java.awt.Color;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class d
extends AdHocRendererFactory<com.inet.report.adhoc.server.api.renderer.b> {
    @Nonnull
    public static final ThemePropertyKey<String[]> kq = new ThemePropertyKey<String[]>("chart.colors", String[].class, new String[]{"#ff595e", "#1982C4", "#8AC926", "#6A4C93", "#FF924C", "#36949D", "#FFCA3A", "#4267AC", "#C5CA30", "#686ac4"});
    @Nonnull
    private static final @Nonnull List<@Nonnull Color> kr = Collections.unmodifiableList(Arrays.stream(kq.getDefaultValue()).map(string -> Color.decode(string)).collect(Collectors.toList()));
    @Nonnull
    public static final RendererPropertyKey<g> ks = new RendererPropertyKey<g>("chart.type", g.class);
    @Nonnull
    public static final RendererPropertyKey<b> kt = new RendererPropertyKey<b>("chart.grouping", b.class);
    @Nonnull
    public static final RendererPropertyKey<GroupData> CHART_CATEGORY = new RendererPropertyKey<GroupData>("chart.category", GroupData.class);
    @Nonnull
    public static final RendererPropertyKey<GroupData> ku = new RendererPropertyKey<GroupData>("chart.secondcategory", GroupData.class);
    @Nonnull
    public static final RendererPropertyKey<DataField[]> CHART_DATA_FIELDS = new RendererPropertyKey<DataField[]>("chart.datafields", DataField[].class);
    @Nonnull
    public static final RendererPropertyKey<DataField> kv = new RendererPropertyKey<DataField>("chart.data.x", DataField.class);
    @Nonnull
    public static final RendererPropertyKey<DataField> kw = new RendererPropertyKey<DataField>("chart.data.y", DataField.class);
    @Nonnull
    public static final RendererPropertyKey<DataField> kx = new RendererPropertyKey<DataField>("chart.data.r", DataField.class);
    @Nonnull
    public static final RendererPropertyKey<String> ky = new RendererPropertyKey<String>("chart.title", String.class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> kz = new RendererPropertyKey<Boolean>("chart.radar.fill", Boolean.class);
    @Nonnull
    public static final RendererPropertyKey<Double> kA = new RendererPropertyKey<Double>("chart.bubble.sizemodifier", Double.class);
    @Nonnull
    public static final ThemePropertyKey<Integer> kB = new ThemePropertyKey<Integer>("chart.title.font.size", Integer.class, 360);
    @Nonnull
    public static final ThemePropertyKey<Integer> kC = new ThemePropertyKey<Integer>("chart.title.font.color", Integer.class, AdHocTheme.DEFAULT_FONT_COLOR.getDefaultValue());
    @Nonnull
    public static final ThemePropertyKey<Boolean> kD = new ThemePropertyKey<Boolean>("chart.title.font.style.bold", Boolean.class, true);
    @Nonnull
    public static final ThemePropertyKey<Boolean> kE = new ThemePropertyKey<Boolean>("chart.title.font.style.italic", Boolean.class, false);
    @Nonnull
    public static final ThemePropertyKey<Boolean> kF = new ThemePropertyKey<Boolean>("chart.title.font.style.underline", Boolean.class, false);

    @Nonnull
    public static @Nonnull List<@Nonnull Color> b(@Nonnull AdHocTheme adHocTheme) {
        try {
            String[] stringArray = adHocTheme.getStringArrayOrDefault(kq);
            return Arrays.stream(stringArray).map(string -> Color.decode(string)).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return kr;
        }
    }

    public d() {
        super("chart");
    }

    @Override
    public void validate(@Nonnull AdHocDefinition definition) throws ValidationException {
        g g2;
        Map<RendererPropertyKey<?>, String> map = definition.getProperties();
        String string = map.get(ks);
        if (string == null) {
            throw new ValidationException(ks.getName(), a.bm.getMsg("err.noChartType", new Object[0]));
        }
        try {
            g2 = g.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ValidationException(ks.getName(), a.bm.getMsg("err.invalidData", new Object[0]));
        }
        super.validate(definition);
        switch (g2) {
            case kO: 
            case kP: {
                com.inet.report.adhoc.server.renderer.chart.a.a(g2, map);
                break;
            }
            case kQ: 
            case kR: {
                i.a(g2, map);
                break;
            }
            case kT: 
            case kU: {
                m.a(g2, map);
                break;
            }
            case kS: {
                l.a(g2, map);
            }
        }
    }

    @Override
    @Nonnull
    public com.inet.report.adhoc.server.api.renderer.b createInstanceFrom(@Nonnull AdHocDefinition definition) {
        GUID gUID = definition.getComponentId();
        Map<RendererPropertyKey<?>, String> map = definition.getProperties();
        g g2 = g.valueOf(map.get(ks));
        switch (g2) {
            case kO: {
                return new com.inet.report.adhoc.server.renderer.chart.a(gUID, true, map);
            }
            case kP: {
                return new com.inet.report.adhoc.server.renderer.chart.a(gUID, false, map);
            }
            case kQ: {
                return new i(gUID, true, map);
            }
            case kR: {
                return new i(gUID, false, map);
            }
            case kT: {
                return new m(gUID, true, map);
            }
            case kU: {
                return new m(gUID, false, map);
            }
            case kS: {
                return new l(gUID, map);
            }
        }
        throw new IllegalArgumentException(g2.name());
    }

    @Override
    @Nonnull
    public ComponentSettings getComponentSettings(@Nonnull com.inet.report.adhoc.webgui.controls.a complexity) {
        Object object;
        ComponentSettings componentSettings = new ComponentSettings("chart");
        componentSettings.setThemeChangeRequiredRendering(true);
        GroupControl groupControl = componentSettings.addGroup("group.charttype");
        ImageSelectControl imageSelectControl = new ImageSelectControl(ks.getName());
        for (g g2 : g.values()) {
            object = g2.name();
            imageSelectControl.addOption(new LocalizedKey(object, a.bm.getMsg(object, new Object[0])));
        }
        groupControl.add(imageSelectControl);
        groupControl = componentSettings.addGroup("group.source");
        DataSelectControl dataSelectControl = new DataSelectControl();
        groupControl.add(dataSelectControl);
        groupControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        groupControl = componentSettings.addGroup("group.column");
        BaseControl baseControl = this.f(b.a(g.kO));
        baseControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kO);
        groupControl.add(baseControl);
        Object object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl = new ColumnsControl("preview-chart-bar", new ColumnsSection[]{object2, this.o(100)});
        columnsControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kO).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kf);
        groupControl.add(columnsControl);
        object2 = this.a(2, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl2 = new ColumnsControl("preview-chart-bar", new ColumnsSection[]{object2, this.o(1)});
        columnsControl2.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kO).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kg);
        groupControl.add(columnsControl2);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr);
        ColumnsControl columnsControl3 = new ColumnsControl("preview-chart-bar", new ColumnsSection[]{object2, this.p(100)});
        columnsControl3.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kO).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kh);
        groupControl.add(columnsControl3);
        baseControl = this.f(b.a(g.kP));
        baseControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kP);
        groupControl.add(baseControl);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl4 = new ColumnsControl("preview-chart-line", new ColumnsSection[]{object2, this.o(100)});
        columnsControl4.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kP).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kf);
        groupControl.add(columnsControl4);
        object2 = this.a(2, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl5 = new ColumnsControl("preview-chart-line", new ColumnsSection[]{object2, this.o(1)});
        columnsControl5.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kP).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kg);
        groupControl.add(columnsControl5);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr);
        ColumnsControl columnsControl6 = new ColumnsControl("preview-chart-line", new ColumnsSection[]{object2, this.p(100)});
        columnsControl6.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kP).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kh);
        groupControl.add(columnsControl6);
        baseControl = this.f(b.a(g.kS));
        baseControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kS);
        groupControl.add(baseControl);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl7 = new ColumnsControl("preview-chart-radar", new ColumnsSection[]{object2, this.o(100)});
        columnsControl7.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kS).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kf);
        groupControl.add(columnsControl7);
        object2 = this.a(2, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl8 = new ColumnsControl("preview-chart-radar", new ColumnsSection[]{object2, this.o(1)});
        columnsControl8.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kS).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kg);
        groupControl.add(columnsControl8);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr);
        ColumnsControl columnsControl9 = new ColumnsControl("preview-chart-radar", new ColumnsSection[]{object2, this.p(100)});
        columnsControl9.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kS).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kh);
        groupControl.add(columnsControl9);
        baseControl = this.f(b.a(g.kQ));
        baseControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kQ);
        groupControl.add(baseControl);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl10 = new ColumnsControl("preview-chart-doughnut", new ColumnsSection[]{object2, this.o(1)});
        columnsControl10.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kQ).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kf);
        groupControl.add(columnsControl10);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr);
        ColumnsControl columnsControl11 = new ColumnsControl("preview-chart-doughnut", new ColumnsSection[]{object2, this.p(1)});
        columnsControl11.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kQ).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kh);
        groupControl.add(columnsControl11);
        ColumnsControl columnsControl12 = new ColumnsControl("preview-chart-doughnut", this.o(100));
        columnsControl12.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kQ).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.ki);
        groupControl.add(columnsControl12);
        baseControl = this.f(b.a(g.kR));
        baseControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kR);
        groupControl.add(baseControl);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsControl columnsControl13 = new ColumnsControl("preview-chart-pie", new ColumnsSection[]{object2, this.o(1)});
        columnsControl13.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kR).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kf);
        groupControl.add(columnsControl13);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr);
        ColumnsControl columnsControl14 = new ColumnsControl("preview-chart-pie", new ColumnsSection[]{object2, this.p(1)});
        columnsControl14.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kR).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kh);
        groupControl.add(columnsControl14);
        ColumnsControl columnsControl15 = new ColumnsControl("preview-chart-pie", this.o(100));
        columnsControl15.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kR).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.ki);
        groupControl.add(columnsControl15);
        baseControl = this.f(b.a(g.kT));
        baseControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kT);
        groupControl.add(baseControl);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsSection columnsSection = new ColumnsSection(kv.getName(), "X", 1, ColumnsSection.a.nq, ColumnsSection.a.nr);
        object = new ColumnsSection(kw.getName(), "Y", 1, ColumnsSection.a.nq, ColumnsSection.a.nr);
        ConditionalLocalizedkey conditionalLocalizedkey = new ColumnsSection(kx.getName(), a.bm.getMsg("chart.data.r", new Object[0]), 1, ColumnsSection.a.nq);
        ColumnsControl columnsControl16 = new ColumnsControl("preview-chart-bubble", new ColumnsSection[]{object2, columnsSection, object, conditionalLocalizedkey});
        columnsControl16.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kT).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kf);
        groupControl.add(columnsControl16);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr);
        ColumnsSection columnsSection2 = new ColumnsSection(kv.getName(), "X", 1, ColumnsSection.a.nr);
        object = new ColumnsSection(kw.getName(), "Y", 1, ColumnsSection.a.nr);
        conditionalLocalizedkey = new ColumnsSection(kx.getName(), a.bm.getMsg("chart.data.r", new Object[0]), 1, new ColumnsSection.a[0]);
        columnsControl16 = new ColumnsControl("preview-chart-bubble", new ColumnsSection[]{object2, columnsSection2, object, conditionalLocalizedkey});
        columnsControl16.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kT).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kh);
        groupControl.add(columnsControl16);
        baseControl = this.f(b.a(g.kU));
        baseControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kU);
        groupControl.add(baseControl);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsSection columnsSection3 = new ColumnsSection(kv.getName(), "X", 1, ColumnsSection.a.nq, ColumnsSection.a.nr);
        object = new ColumnsSection(kw.getName(), "Y", 1, ColumnsSection.a.nq, ColumnsSection.a.nr);
        conditionalLocalizedkey = new ColumnsControl("preview-chart-scatter", new ColumnsSection[]{object2, columnsSection3, object});
        conditionalLocalizedkey.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kU).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kf);
        groupControl.add((BaseControl)conditionalLocalizedkey);
        object2 = this.a(1, ColumnsSection.a.nn, ColumnsSection.a.nr);
        ColumnsSection columnsSection4 = new ColumnsSection(kv.getName(), "X", 1, ColumnsSection.a.nr);
        object = new ColumnsSection(kw.getName(), "Y", 1, ColumnsSection.a.nr);
        conditionalLocalizedkey = new ColumnsControl("preview-chart-scatter", new ColumnsSection[]{object2, columnsSection4, object});
        conditionalLocalizedkey.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kU).a(baseControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)b.kh);
        groupControl.add((BaseControl)conditionalLocalizedkey);
        groupControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"").a(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, "");
        groupControl = componentSettings.addGroup("group.filter");
        baseControl = new DataFilterControl();
        groupControl.add(baseControl);
        groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        groupControl = componentSettings.addGroup("group.settings");
        groupControl.add(new TextControl(ky));
        groupControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)g.kS).a(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)g.kT).a(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, "");
        groupControl = componentSettings.addGroup("group.settings.radarchart");
        groupControl.add(new TextControl(ky));
        groupControl.add(new BooleanControl(kz, a.bm.getMsg(kz.getName(), new Object[0])));
        groupControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kS).a(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, "");
        groupControl = componentSettings.addGroup("group.settings.bubblechart");
        groupControl.add(new TextControl(ky));
        object2 = this.bm();
        if (com.inet.report.adhoc.webgui.controls.a.nD.equals((Object)complexity)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            double d2 = 20.0;
            int n2 = 1;
            while ((double)n2 <= d2) {
                arrayList.add(((NumberFormat)object2).format((double)n2 / d2));
                ++n2;
            }
            groupControl.add(new SliderControl(kA, a.bm.getMsg(kA.getName(), new Object[0]), arrayList));
        }
        groupControl.visibleWhen(imageSelectControl, ConditionalLocalizedkey.ConditionOperator.EQ, (Object)g.kT).a(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, "");
        componentSettings.addDefaultValue(kt.getName(), b.kf.name());
        componentSettings.addDefaultValue(imageSelectControl.getKey(), g.kO.name());
        componentSettings.addDefaultValue(kA.getName(), ((NumberFormat)object2).format(0.3));
        return componentSettings;
    }

    private SelectControl f(@Nonnull @Nonnull List<@Nonnull b> list) {
        ArrayList<SelectOption> arrayList = new ArrayList<SelectOption>();
        for (b b2 : list) {
            arrayList.add(new SelectOption(b2.name(), a.bm.getMsg("groupingType." + b2.name(), new Object[0])));
        }
        return new SelectControl(kt.getName(), arrayList);
    }

    private ColumnsSection a(int n2, ColumnsSection.a ... aArray) {
        return new ColumnsSection(CHART_CATEGORY.getName(), a.bm.getMsg("categories", new Object[0]), n2, aArray);
    }

    private ColumnsSection o(int n2) {
        return new ColumnsSection(CHART_DATA_FIELDS.getName(), a.bm.getMsg("series", new Object[0]), n2, ColumnsSection.a.nq, ColumnsSection.a.nr);
    }

    private ColumnsSection p(int n2) {
        return new ColumnsSection(CHART_DATA_FIELDS.getName(), a.bm.getMsg("series", new Object[0]), n2, ColumnsSection.a.nr);
    }

    @Override
    @Nonnull
    public ComponentSettings getDefaultSettings() {
        ComponentSettings componentSettings = new ComponentSettings("chart");
        GroupControl groupControl = componentSettings.addGroup("group.column");
        ColumnsSection columnsSection = new ColumnsSection(CHART_CATEGORY.getName(), a.bm.getMsg("categories", new Object[0]), 1, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns);
        ColumnsSection columnsSection2 = new ColumnsSection(CHART_DATA_FIELDS.getName(), a.bm.getMsg("series", new Object[0]), 2, ColumnsSection.a.nq, ColumnsSection.a.nr);
        groupControl.visibleWhen(PersistenceTemplateDataViewDefaults.TEMPLATESOURCE_COLUMNS_KEY.getName(), ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        groupControl.add(new ColumnsControl("preview-chart-bar", columnsSection, columnsSection2));
        return componentSettings;
    }

    @Override
    @Nullable
    public ComponentSettings getThemeSettings() {
        ComponentSettings componentSettings = new ComponentSettings("chart");
        GroupControl groupControl = componentSettings.addGroup("settingsgroup.chart.colorschema", "");
        groupControl.add(new ColorSchemeControl(kq, a.bm.getMsg("colorscheme", new Object[0])));
        GroupControl groupControl2 = componentSettings.addGroup("title", a.bm.getMsg(ky.getName(), new Object[0]));
        groupControl2.add(new SelectControl(kB, com.inet.report.adhoc.server.theming.b.nh));
        groupControl2.add(new ColorControl(kC));
        groupControl2.add(new BooleanControl(kD, a.bm.getMsg("font.style.bold", new Object[0])));
        groupControl2.add(new BooleanControl(kE, a.bm.getMsg("font.style.italic", new Object[0])));
        return componentSettings;
    }

    @Override
    public void convertUiModeltoServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        super.convertUiModeltoServerModel(uiModel, serverModel);
        this.transferUiProperty(ks, uiModel, serverModel);
        this.transferUiProperty(kt, uiModel, serverModel);
        this.a(uiModel, serverModel);
        Function<ColumnSelectOption, Object> function = columnSelectOption -> new DataField(columnSelectOption.getValue(), columnSelectOption.getSummaryOperation(), columnSelectOption.getValueFormat());
        this.convertUiProperty("columns", CHART_DATA_FIELDS, function, uiModel, serverModel);
        this.convertUiPropertyThatIsNotListBased("columns", kv, function, uiModel, serverModel);
        this.convertUiPropertyThatIsNotListBased("columns", kw, function, uiModel, serverModel);
        this.convertUiPropertyThatIsNotListBased("columns", kx, function, uiModel, serverModel);
        this.transferUiProperty(ky, uiModel, serverModel);
        this.transferUiProperty(kz, uiModel, serverModel);
        String string = uiModel.get(kA.getName());
        if (!StringFunctions.isEmpty((String)string)) {
            try {
                serverModel.put(kA, new Json().toJson((Object)this.bm().parse(string).doubleValue()));
            }
            catch (ParseException parseException) {
                serverModel.put(kA, new Json().toJson((Object)0.3));
            }
        }
    }

    private void a(@Nonnull Map<String, String> map, @Nonnull Map<RendererPropertyKey<?>, String> map2) {
        Json json;
        Map map3;
        List list;
        String string = map.get("columns");
        if (string != null && (list = (List)(map3 = Objects.requireNonNull((Map)(json = new Json()).fromJson(string, (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, new JsonParameterizedType(List.class, new Type[]{ColumnSelectOption.class})})))).get(CHART_CATEGORY.getName())) != null && !list.isEmpty()) {
            ColumnSelectOption columnSelectOption = (ColumnSelectOption)((Object)list.get(0));
            Objects.requireNonNull(columnSelectOption.getValue());
            GroupData groupData = new GroupData(columnSelectOption.getValue(), columnSelectOption.getSorting(), columnSelectOption.getTimePeriod(), columnSelectOption.getValueFormat());
            map2.put(CHART_CATEGORY, json.toJson((Object)groupData));
            if (list.size() > 1 && (columnSelectOption = (ColumnSelectOption)((Object)list.get(1))) != null) {
                Objects.requireNonNull(columnSelectOption.getValue());
                groupData = new GroupData(columnSelectOption.getValue(), columnSelectOption.getSorting(), columnSelectOption.getTimePeriod(), columnSelectOption.getValueFormat());
                map2.put(ku, json.toJson((Object)groupData));
            }
        }
    }

    private void b(@Nonnull Map<RendererPropertyKey<?>, String> map, @Nonnull Map<String, String> map2) {
        String string = map.get(CHART_CATEGORY);
        if (string == null) {
            return;
        }
        Json json = new Json();
        String string2 = map2.get("columns");
        @Nonnull HashMap<String, ArrayList<E>> hashMap = string2 == null ? new HashMap() : (Map)json.fromJson(string2, (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, new JsonParameterizedType(List.class, new Type[]{ColumnSelectOption.class})}));
        ArrayList<ColumnSelectOption> arrayList = new ArrayList<ColumnSelectOption>();
        GroupData groupData = (GroupData)json.fromJson(string, GroupData.class, Json.NULL_MAP);
        ColumnSelectOption columnSelectOption = new ColumnSelectOption(groupData.getColumnKey(), groupData.getColumnKey(), null, -1, groupData.getValueFormat(), groupData.getTimePeriod());
        columnSelectOption.setSorting(groupData.getSortOrder());
        arrayList.add(columnSelectOption);
        string = map.get(ku);
        if (string != null) {
            groupData = (GroupData)json.fromJson(string, GroupData.class, Json.NULL_MAP);
            columnSelectOption = new ColumnSelectOption(groupData.getColumnKey(), groupData.getColumnKey(), null, -1, groupData.getValueFormat(), groupData.getTimePeriod());
            columnSelectOption.setSorting(groupData.getSortOrder());
            arrayList.add(columnSelectOption);
        }
        hashMap.put(CHART_CATEGORY.getName(), arrayList);
        map2.put("columns", json.toJson(hashMap));
    }

    @Override
    public void convertServerModeltoUiModel(@Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        super.convertServerModeltoUiModel(serverModel, uiModel);
        Json json = new Json();
        this.transferServerProperty(ks, serverModel, uiModel);
        this.transferServerPropertyOrDefault(kt, serverModel, uiModel, b.kf.name());
        this.b(serverModel, uiModel);
        this.convertServerProperty(CHART_DATA_FIELDS, "columns", (string, list) -> {
            for (DataField dataField : (DataField[])json.fromJson(string, DataField[].class, Json.NULL_MAP)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(dataField.getColumnKey(), dataField.getColumnKey(), -1, dataField.getValueFormat());
                columnSelectOption.setSummaryOperation(dataField.getSummaryOperation());
                list.add(columnSelectOption);
            }
        }, serverModel, uiModel);
        BiConsumer<String, List<ColumnSelectOption>> biConsumer = (string, list) -> {
            DataField dataField = (DataField)json.fromJson(string, DataField.class, Json.NULL_MAP);
            ColumnSelectOption columnSelectOption = new ColumnSelectOption(dataField.getColumnKey(), dataField.getColumnKey(), -1, dataField.getValueFormat());
            columnSelectOption.setSummaryOperation(dataField.getSummaryOperation());
            list.add(columnSelectOption);
        };
        this.convertServerProperty(kv, "columns", biConsumer, serverModel, uiModel);
        this.convertServerProperty(kw, "columns", biConsumer, serverModel, uiModel);
        this.convertServerProperty(kx, "columns", biConsumer, serverModel, uiModel);
        this.transferServerProperty(ky, serverModel, uiModel);
        this.transferServerProperty(kz, serverModel, uiModel);
        String string2 = serverModel.get(kA);
        if (StringFunctions.isEmpty((String)string2)) {
            string2 = "0.3";
        }
        uiModel.put(kA.getName(), this.bm().format(json.fromJson(string2, Double.class)));
    }

    private NumberFormat bm() {
        NumberFormat numberFormat = NumberFormat.getInstance(ClientLocale.getThreadLocale());
        numberFormat.setMinimumFractionDigits(2);
        return numberFormat;
    }

    @Override
    @Nonnull
    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/report/adhoc/server/images/chart.svg");
    }

    @Override
    protected void convertThemeSettingsFromUiModelToServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        d.transferArrayOrDefaultToServerModel(kq, uiModel, serverModel);
        d.transferConvertedPointsToTwipsOrDefaultToServerModel(kB, uiModel, serverModel);
        d.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(kC, uiModel, serverModel);
        d.transferUnconvertedValueOrDefaultToServerModel(kD, uiModel, serverModel);
        d.transferUnconvertedValueOrDefaultToServerModel(kE, uiModel, serverModel);
        d.transferUnconvertedValueOrDefaultToServerModel(kF, uiModel, serverModel);
    }

    @Override
    protected void convertThemeSettingsFromServerModelToUiModel(@Nonnull Map<ThemePropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        d.transferArrayOrDefaultToUiModel(kq, serverModel, uiModel);
        d.transferConvertedTwipsToPointsOrDefaultToUiModel(kB, serverModel, uiModel);
        d.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(kC, serverModel, uiModel);
        d.transferUnconvertedValueOrDefaultToUiModel(kD, serverModel, uiModel);
        d.transferUnconvertedValueOrDefaultToUiModel(kE, serverModel, uiModel);
        d.transferUnconvertedValueOrDefaultToUiModel(kF, serverModel, uiModel);
    }

    @Override
    public void appendCSS(@Nonnull AdHocTheme theme, @Nonnull MemoryStream stream) {
    }

    @Override
    @Nullable
    public PreviewData getPreviewData(@Nullable GUID themeId) {
        String string;
        AdHocTheme adHocTheme = null;
        if (themeId != null) {
            adHocTheme = com.inet.report.adhoc.server.theming.b.bI().h(themeId);
        }
        if (adHocTheme == null) {
            adHocTheme = com.inet.report.adhoc.server.theming.b.ne;
        }
        String[] stringArray = adHocTheme.getStringArrayOrDefault(kq);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        while (arrayList.size() < 10) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                string = stringArray[i2];
                arrayList.add(Color.decode(string));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class=\"chartwrapper\" style=\"max-width: 100%; max-height: 100%; margin: auto; position: relative; aspect-ratio: 2\" id='barchartpreview'></div>");
        string = a.bm.getMsg("preview.chart.title", new Object[0]);
        double d2 = 0.0;
        double d3 = 4.0;
        List<@Nonnull String> list = List.of("1", "2", "3", "4", "5");
        ArrayList<@Nonnull BarAndLineChartDataset> arrayList2 = new ArrayList<BarAndLineChartDataset>();
        for (int i3 = 1; i3 <= 10; ++i3) {
            String string2 = a.bm.getMsg("preview.chart.data", new Object[0]) + " " + i3;
            Double[] doubleArray = new Double[]{3.5, 2.0, 3.0, 1.5, 4.0};
            String[] stringArray2 = new String[]{"3.5", "2", "3", "1.5", "4"};
            Color color = (Color)arrayList.get(i3 - 1);
            arrayList2.add(new BarAndLineChartDataset(true, string2, doubleArray, stringArray2, color, adHocTheme));
        }
        Map<@Nonnull String, @Nonnull Object> map = j.a(adHocTheme, string, d2, d3, list, arrayList2);
        stringBuilder.append("<script>");
        stringBuilder.append("var chartDom = document.getElementById('").append("barchartpreview").append("');");
        stringBuilder.append("var myChart = echarts.init(chartDom, null, {renderer: 'svg'});");
        stringBuilder.append("window.barchartpreview = ").append(new Json().toJson(map)).append(";");
        stringBuilder.append("window.barchartpreview && myChart.setOption(window.barchartpreview);");
        stringBuilder.append("</script>");
        return new PreviewData(stringBuilder.toString());
    }
}

