/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.handler.data;

import com.inet.annotations.JsonData;
import com.inet.field.SelectOption;
import com.inet.report.adhoc.server.api.renderer.AbstractFormatableColumn;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import com.inet.report.adhoc.server.api.renderer.SummaryOperation;

@JsonData
public class ColumnSelectOption
extends SelectOption {
    private SortOrder sorting = SortOrder.ASCENDING;
    private SummaryOperation summaryOperation;
    private AbstractFormatableColumn.ValueFormat valueFormat = AbstractFormatableColumn.ValueFormat.UNFORMATTED;
    private GroupData.TimePeriod timePeriod;
    private int dataType;
    private String displayAlias;

    private ColumnSelectOption() {
    }

    public ColumnSelectOption(String value, String label, int dataType, AbstractFormatableColumn.ValueFormat valueFormat) {
        super(value, label, "" + dataType);
        this.dataType = dataType;
        this.valueFormat = valueFormat;
    }

    public ColumnSelectOption(String value, String label, String displayAlias, int dataType, AbstractFormatableColumn.ValueFormat valueFormat, GroupData.TimePeriod timePeriod) {
        super(value, label, "" + dataType);
        this.dataType = dataType;
        this.displayAlias = displayAlias;
        this.valueFormat = valueFormat;
        this.timePeriod = timePeriod;
    }

    public static AbstractFormatableColumn.ValueFormat getDefaultValueFormatForDataType(int dataType) {
        switch (dataType) {
            case 6: {
                return AbstractFormatableColumn.ValueFormat.NUMBER_FORMAT_FRACTIONAL;
            }
            case 7: {
                return AbstractFormatableColumn.ValueFormat.NUMBER_FORMAT_CURRENCY;
            }
            case 9: {
                return AbstractFormatableColumn.ValueFormat.DATE_FORMAT_MEDIUM;
            }
            case 15: {
                return AbstractFormatableColumn.ValueFormat.DATETIME_FORMAT_MEDIUM;
            }
            case 10: {
                return AbstractFormatableColumn.ValueFormat.TIME_FORMAT_MEDIUM;
            }
        }
        return AbstractFormatableColumn.ValueFormat.UNFORMATTED;
    }

    public String getDisplayAlias() {
        return this.displayAlias;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public SortOrder getSorting() {
        return this.sorting;
    }

    public void setSorting(SortOrder sorting) {
        this.sorting = sorting;
    }

    public SummaryOperation getSummaryOperation() {
        return this.summaryOperation;
    }

    public void setSummaryOperation(SummaryOperation summaryOperation) {
        this.summaryOperation = summaryOperation;
    }

    public AbstractFormatableColumn.ValueFormat getValueFormat() {
        return this.valueFormat;
    }

    public GroupData.TimePeriod getTimePeriod() {
        return this.timePeriod;
    }
}

