/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.renderer;

import com.inet.annotations.JsonData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class RendererPropertyKey<JSONIZABLE_VALUE> {
    private static final Map<String, RendererPropertyKey<?>> values = new HashMap();
    @Nonnull
    private String name;
    @Nonnull
    private @Nonnull Class<@Nonnull JSONIZABLE_VALUE> type;

    private RendererPropertyKey() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RendererPropertyKey(@Nonnull String name, @Nonnull @Nonnull Class<? super @Nonnull JSONIZABLE_VALUE> type) {
        this.name = name;
        this.type = type;
        Map<String, RendererPropertyKey<?>> map = values;
        synchronized (map) {
            if (values.containsKey(name)) {
                throw new IllegalStateException("Duplicate key: " + name);
            }
            values.put(name, this);
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public @Nonnull Class<@Nonnull JSONIZABLE_VALUE> getType() {
        return this.type;
    }

    public JSONIZABLE_VALUE cast(@Nonnull Object value) {
        if (this.type.isInstance(value)) {
            return this.type.cast(value);
        }
        throw new ClassCastException("Cannot cast " + value.getClass().getName() + " to " + this.type.getName());
    }

    @Nonnull
    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.equals(((RendererPropertyKey)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static RendererPropertyKey<?> valueOf(String name) {
        if (name == null) {
            return null;
        }
        RendererPropertyKey<Object> rendererPropertyKey = values.get(name);
        if (rendererPropertyKey == null) {
            rendererPropertyKey = new RendererPropertyKey<String>(name, String.class);
        }
        return rendererPropertyKey;
    }
}

