/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.dataview;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class DataViewAccessList {
    @Nonnull
    private @Nonnull Set<@Nonnull GUID> userIDs = new HashSet<GUID>();
    @Nonnull
    private @Nonnull Set<@Nonnull GUID> groupIDs = new HashSet<GUID>();

    private DataViewAccessList() {
    }

    public DataViewAccessList(@Nonnull @Nonnull Set<@Nonnull GUID> userIDs, @Nonnull @Nonnull Set<@Nonnull GUID> groupIDs) {
        this.userIDs = new HashSet<GUID>(userIDs);
        this.groupIDs = new HashSet<GUID>(groupIDs);
    }

    @Nonnull
    public @Nonnull Set<@Nonnull GUID> getUserIDs() {
        return Collections.unmodifiableSet(this.userIDs);
    }

    @Nonnull
    public @Nonnull Set<@Nonnull GUID> getGroupIDs() {
        return Collections.unmodifiableSet(this.groupIDs);
    }

    public boolean isEmpty() {
        return this.userIDs.isEmpty() && this.groupIDs.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.groupIDs, this.userIDs);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataViewAccessList dataViewAccessList = (DataViewAccessList)obj;
        return Objects.equals(this.groupIDs, dataViewAccessList.groupIDs) && Objects.equals(this.userIDs, dataViewAccessList.userIDs);
    }
}

