/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.renderer.crosstab;

import com.inet.field.SelectOption;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.ColorUtils;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.dataview.PersistenceTemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.AdHocDefinition;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.renderer.DataField;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.PreviewData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.theming.ThemePropertyKey;
import com.inet.report.adhoc.server.renderer.a;
import com.inet.report.adhoc.server.renderer.crosstab.b;
import com.inet.report.adhoc.server.theming.AdHocTheme;
import com.inet.report.adhoc.webgui.controls.BooleanControl;
import com.inet.report.adhoc.webgui.controls.ColorControl;
import com.inet.report.adhoc.webgui.controls.ColumnsControl;
import com.inet.report.adhoc.webgui.controls.ColumnsSection;
import com.inet.report.adhoc.webgui.controls.ComponentSettings;
import com.inet.report.adhoc.webgui.controls.ConditionalLocalizedkey;
import com.inet.report.adhoc.webgui.controls.DataFilterControl;
import com.inet.report.adhoc.webgui.controls.DataSelectControl;
import com.inet.report.adhoc.webgui.controls.GroupControl;
import com.inet.report.adhoc.webgui.controls.SelectControl;
import com.inet.report.adhoc.webgui.handler.data.ColumnSelectOption;
import com.inet.shared.utils.MemoryStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
extends AdHocRendererFactory<b> {
    @Nonnull
    public static final ThemePropertyKey<Boolean> lC = new ThemePropertyKey<Boolean>("crosstab.border.show", Boolean.class, true);
    @Nonnull
    public static final ThemePropertyKey<Integer> lD = new ThemePropertyKey<Integer>("crosstab.border.color", Integer.class, 0);
    @Nonnull
    public static final ThemePropertyKey<Integer> lE = new ThemePropertyKey<Integer>("crosstab.header.font.color", Integer.class, 0);
    @Nonnull
    public static final ThemePropertyKey<Boolean> lF = new ThemePropertyKey<Boolean>("crosstab.header.font.style.bold", Boolean.class, true);
    @Nonnull
    public static final ThemePropertyKey<Boolean> lG = new ThemePropertyKey<Boolean>("crosstab.header.font.style.italic", Boolean.class, false);
    @Nonnull
    public static final ThemePropertyKey<Boolean> lH = new ThemePropertyKey<Boolean>("crosstab.header.font.style.underline", Boolean.class, false);
    @Nonnull
    public static final RendererPropertyKey<DataField[]> CROSSTAB_DATA = new RendererPropertyKey<DataField[]>("crosstab.data", DataField[].class);
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> CROSSTAB_COLUMNS = new RendererPropertyKey<GroupData[]>("crosstab.columns", GroupData[].class);
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> CROSSTAB_ROWS = new RendererPropertyKey<GroupData[]>("crosstab.rows", GroupData[].class);
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> CROSSTAB_GROUPS = new RendererPropertyKey<GroupData[]>("crosstab.groups", GroupData[].class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> lI = new RendererPropertyKey<Boolean>("crosstab.cells.horizontalalignment", Boolean.class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> lJ = new RendererPropertyKey<Boolean>("crosstab.columns.suppressifempty", Boolean.class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> lK = new RendererPropertyKey<Boolean>("crosstab.columns.suppressgrandtotal", Boolean.class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> lL = new RendererPropertyKey<Boolean>("crosstab.columns.showtotalsontop", Boolean.class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> lM = new RendererPropertyKey<Boolean>("crosstab.rows.suppressifempty", Boolean.class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> lN = new RendererPropertyKey<Boolean>("crosstab.rows.suppressgrandtotal", Boolean.class);
    @Nonnull
    public static final RendererPropertyKey<Boolean> lO = new RendererPropertyKey<Boolean>("crosstab.rows.showtotalsontop", Boolean.class);

    public c() {
        super("crosstab");
    }

    @Override
    public void validate(@Nonnull AdHocDefinition definition) throws ValidationException {
        Object object;
        super.validate(definition);
        Map map = definition.getProperties();
        String string = CROSSTAB_DATA.getName();
        String string2 = map.get(CROSSTAB_DATA);
        if (string2 == null) {
            throw new ValidationException(string, a.bm.getMsg("err.noValueField", new Object[0]));
        }
        try {
            object = (DataField[])new Json().fromJson(string2, DataField[].class);
            if (((DataField[])object).length == 0) {
                throw new ValidationException(string, a.bm.getMsg("err.noValueField", new Object[0]));
            }
            for (DataField dataField : object) {
                if (dataField != null) continue;
                throw new ValidationException(string, a.bm.getMsg("err.invalidData", new Object[0]));
            }
        }
        catch (JsonException jsonException) {
            throw new ValidationException(string, a.bm.getMsg("err.invalidData", new Object[0]), jsonException);
        }
        object = CROSSTAB_COLUMNS.getName();
        String string3 = map.get(CROSSTAB_COLUMNS);
        if (string3 != null) {
            try {
                GroupData[] jsonException = (GroupData[])new Json().fromJson(string3, GroupData[].class);
                if (jsonException.length > 0) {
                    for (GroupData groupData : jsonException) {
                        if (groupData != null) continue;
                        throw new ValidationException((String)object, a.bm.getMsg("err.invalidData", new Object[0]));
                    }
                }
            }
            catch (JsonException string32) {
                throw new ValidationException((String)object, a.bm.getMsg("err.invalidData", new Object[0]), string32);
            }
        }
        String string4 = CROSSTAB_ROWS.getName();
        String string5 = map.get(CROSSTAB_ROWS);
        if (string5 != null) {
            try {
                GroupData[] jsonException = (GroupData[])new Json().fromJson(string5, GroupData[].class);
                if (jsonException.length > 0) {
                    for (GroupData groupData : jsonException) {
                        if (groupData != null) continue;
                        throw new ValidationException(string4, a.bm.getMsg("err.invalidData", new Object[0]));
                    }
                }
            }
            catch (JsonException string52) {
                throw new ValidationException(string4, a.bm.getMsg("err.invalidData", new Object[0]), string52);
            }
        }
        String string6 = CROSSTAB_GROUPS.getName();
        String string7 = map.get(CROSSTAB_GROUPS);
        if (string7 != null) {
            try {
                GroupData[] jsonException = (GroupData[])new Json().fromJson(string7, GroupData[].class);
                if (jsonException.length > 0) {
                    for (GroupData groupData : jsonException) {
                        if (groupData != null) continue;
                        throw new ValidationException(string6, a.bm.getMsg("err.invalidData", new Object[0]));
                    }
                }
            }
            catch (JsonException jsonException) {
                throw new ValidationException(string6, a.bm.getMsg("err.invalidData", new Object[0]), jsonException);
            }
        }
    }

    @Nonnull
    public b e(@Nonnull AdHocDefinition adHocDefinition) {
        return new b(adHocDefinition.getProperties());
    }

    @Override
    @Nonnull
    public ComponentSettings getComponentSettings(@Nonnull com.inet.report.adhoc.webgui.controls.a complexity) {
        ComponentSettings componentSettings = new ComponentSettings("crosstab");
        componentSettings.setExpandContent(true);
        GroupControl groupControl = componentSettings.addGroup("group.source");
        DataSelectControl dataSelectControl = new DataSelectControl();
        groupControl.add(dataSelectControl);
        groupControl = componentSettings.addGroup("group.column");
        int n2 = 3;
        groupControl.add(new ColumnsControl("preview-crosstab", new ColumnsSection(CROSSTAB_COLUMNS.getName(), a.bm.getMsg("columns", new Object[0]), n2, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns), new ColumnsSection(CROSSTAB_ROWS.getName(), a.bm.getMsg("rows", new Object[0]), n2, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns), new ColumnsSection(CROSSTAB_DATA.getName(), a.bm.getMsg("values", new Object[0]), n2, ColumnsSection.a.no, ColumnsSection.a.nr)));
        groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        switch (complexity) {
            case nD: {
                groupControl = componentSettings.addGroup("group.group");
                groupControl.add(new ColumnsControl("group", (String)null, new ColumnsSection(CROSSTAB_GROUPS.getName(), "", 6, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns)));
                groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
                break;
            }
        }
        groupControl = componentSettings.addGroup("group.filter");
        DataFilterControl dataFilterControl = new DataFilterControl();
        groupControl.add(dataFilterControl);
        groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        switch (complexity) {
            case nD: {
                groupControl = componentSettings.addGroup("group.column.setting");
                groupControl.add(new BooleanControl(lJ, a.bm.getMsg("suppressifempty", new Object[0])));
                groupControl.add(new BooleanControl(lK, a.bm.getMsg("suppressgrandtotal", new Object[0])));
                groupControl.add(new BooleanControl(lL, a.bm.getMsg("showtotalsontop", new Object[0])));
                groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
                groupControl = componentSettings.addGroup("group.row.setting");
                groupControl.add(new BooleanControl(lM, a.bm.getMsg("suppressifempty", new Object[0])));
                groupControl.add(new BooleanControl(lN, a.bm.getMsg("suppressgrandtotal", new Object[0])));
                groupControl.add(new BooleanControl(lO, a.bm.getMsg("showtotalsontop", new Object[0])));
                groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
            }
            case nC: {
                groupControl = componentSettings.addGroup("group.cell.setting");
                List<SelectOption> list = List.of(new SelectOption(Boolean.FALSE.toString(), a.bm.getMsg("crosstab.cells.horizontalalignment.column", new Object[0])), new SelectOption(Boolean.TRUE.toString(), a.bm.getMsg("crosstab.cells.horizontalalignment.row", new Object[0])));
                SelectControl selectControl = new SelectControl(lI.getName(), list);
                groupControl.add(selectControl);
                groupControl.visibleWhen(dataSelectControl, ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
                selectControl.enabledWhen(new ConditionalLocalizedkey("columns$" + CROSSTAB_DATA.getName(), ""), ConditionalLocalizedkey.ConditionOperator.LEN_GT, (Object)"1");
                break;
            }
        }
        componentSettings.addDefaultValue(lI.getName(), Boolean.FALSE.toString());
        return componentSettings;
    }

    @Override
    @Nonnull
    public ComponentSettings getDefaultSettings() {
        ComponentSettings componentSettings = new ComponentSettings("crosstab");
        GroupControl groupControl = componentSettings.addGroup("group.column");
        groupControl.visibleWhen(PersistenceTemplateDataViewDefaults.TEMPLATESOURCE_COLUMNS_KEY.getName(), ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        groupControl.add(new ColumnsControl("preview-crosstab", new ColumnsSection(CROSSTAB_COLUMNS.getName(), a.bm.getMsg("columns", new Object[0]), 3, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns), new ColumnsSection(CROSSTAB_ROWS.getName(), a.bm.getMsg("rows", new Object[0]), 3, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns), new ColumnsSection(CROSSTAB_DATA.getName(), a.bm.getMsg("values", new Object[0]), 3, ColumnsSection.a.no, ColumnsSection.a.nr)));
        groupControl = componentSettings.addGroup("group.group");
        groupControl.visibleWhen(PersistenceTemplateDataViewDefaults.TEMPLATESOURCE_COLUMNS_KEY.getName(), ConditionalLocalizedkey.ConditionOperator.NE, (Object)"");
        groupControl.add(new ColumnsControl("group", (String)null, new ColumnsSection(CROSSTAB_GROUPS.getName(), "", 6, ColumnsSection.a.nn, ColumnsSection.a.nr, ColumnsSection.a.ns)));
        return componentSettings;
    }

    @Override
    @Nullable
    public ComponentSettings getThemeSettings() {
        ComponentSettings componentSettings = new ComponentSettings("crosstab");
        GroupControl groupControl = componentSettings.addGroup("settingsgroup.crosstab.border", a.bm.getMsg("border", new Object[0]));
        groupControl.add(new BooleanControl(lC, a.bm.getMsg("border.show", new Object[0])));
        ColorControl colorControl = new ColorControl(lD, a.bm.getMsg("border.color", new Object[0]));
        colorControl.visibleWhen(lC.getName(), ConditionalLocalizedkey.ConditionOperator.EQ, (Object)"true");
        groupControl.add(colorControl);
        GroupControl groupControl2 = componentSettings.addGroup("settingsgroup.crosstab.header", a.bm.getMsg("headerrow", new Object[0]));
        groupControl2.add(new ColorControl(lE, a.bm.getMsg("font.color", new Object[0])));
        groupControl2.add(new BooleanControl(lF, a.bm.getMsg("font.style.bold", new Object[0])));
        groupControl2.add(new BooleanControl(lG, a.bm.getMsg("font.style.italic", new Object[0])));
        groupControl2.add(new BooleanControl(lH, a.bm.getMsg("font.style.underline", new Object[0])));
        return componentSettings;
    }

    @Override
    public void convertUiModeltoServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        super.convertUiModeltoServerModel(uiModel, serverModel);
        Function<ColumnSelectOption, Object> function = columnSelectOption -> new GroupData(columnSelectOption.getValue(), columnSelectOption.getSorting(), columnSelectOption.getTimePeriod(), columnSelectOption.getValueFormat());
        this.convertUiProperty("columns", CROSSTAB_COLUMNS, function, uiModel, serverModel);
        this.convertUiProperty("columns", CROSSTAB_ROWS, function, uiModel, serverModel);
        this.convertUiProperty("columns", CROSSTAB_DATA, columnSelectOption -> new DataField(columnSelectOption.getValue(), columnSelectOption.getSummaryOperation(), columnSelectOption.getValueFormat()), uiModel, serverModel);
        this.convertUiProperty("group", CROSSTAB_GROUPS, function, uiModel, serverModel);
        this.transferUiProperty(lI, uiModel, serverModel);
        this.transferUiProperty(lJ, uiModel, serverModel);
        this.transferUiProperty(lK, uiModel, serverModel);
        this.transferUiProperty(lL, uiModel, serverModel);
        this.transferUiProperty(lM, uiModel, serverModel);
        this.transferUiProperty(lN, uiModel, serverModel);
        this.transferUiProperty(lO, uiModel, serverModel);
    }

    @Override
    public void convertServerModeltoUiModel(@Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        super.convertServerModeltoUiModel(serverModel, uiModel);
        Json json = new Json();
        HashMap hashMap = new HashMap();
        this.convertServerProperty(CROSSTAB_COLUMNS, "columns", (string, list) -> {
            for (GroupData groupData : (GroupData[])json.fromJson(string, GroupData[].class, Json.NULL_MAP)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(groupData.getColumnKey(), groupData.getColumnKey(), null, -1, groupData.getValueFormat(), groupData.getTimePeriod());
                columnSelectOption.setSorting(groupData.getSortOrder());
                list.add(columnSelectOption);
            }
            hashMap.put(CROSSTAB_COLUMNS.getName(), list);
        }, serverModel, uiModel);
        this.convertServerProperty(CROSSTAB_ROWS, "columns", (string, list) -> {
            for (GroupData groupData : (GroupData[])json.fromJson(string, GroupData[].class, Json.NULL_MAP)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(groupData.getColumnKey(), groupData.getColumnKey(), null, -1, groupData.getValueFormat(), groupData.getTimePeriod());
                columnSelectOption.setSorting(groupData.getSortOrder());
                list.add(columnSelectOption);
            }
            hashMap.put(CROSSTAB_ROWS.getName(), list);
        }, serverModel, uiModel);
        this.convertServerProperty(CROSSTAB_DATA, "columns", (string, list) -> {
            for (DataField dataField : (DataField[])json.fromJson(string, DataField[].class, Json.NULL_MAP)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(dataField.getColumnKey(), dataField.getColumnKey(), -1, dataField.getValueFormat());
                columnSelectOption.setSummaryOperation(dataField.getSummaryOperation());
                list.add(columnSelectOption);
            }
            hashMap.put(CROSSTAB_DATA.getName(), list);
        }, serverModel, uiModel);
        this.convertServerProperty(CROSSTAB_GROUPS, "group", (string, list) -> {
            for (GroupData groupData : (GroupData[])json.fromJson(string, GroupData[].class, Json.NULL_MAP)) {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(groupData.getColumnKey(), groupData.getColumnKey(), null, -1, groupData.getValueFormat(), groupData.getTimePeriod());
                columnSelectOption.setSorting(groupData.getSortOrder());
                list.add(columnSelectOption);
            }
        }, serverModel, uiModel);
        this.transferServerProperty(lI, serverModel, uiModel);
        this.transferServerProperty(lJ, serverModel, uiModel);
        this.transferServerProperty(lK, serverModel, uiModel);
        this.transferServerProperty(lL, serverModel, uiModel);
        this.transferServerProperty(lM, serverModel, uiModel);
        this.transferServerProperty(lN, serverModel, uiModel);
        this.transferServerProperty(lO, serverModel, uiModel);
    }

    @Override
    @Nonnull
    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/report/adhoc/server/images/crosstab.svg");
    }

    @Override
    protected void convertThemeSettingsFromUiModelToServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        c.transferUnconvertedValueOrDefaultToServerModel(lC, uiModel, serverModel);
        c.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(lD, uiModel, serverModel);
        c.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(lE, uiModel, serverModel);
        c.transferUnconvertedValueOrDefaultToServerModel(lF, uiModel, serverModel);
        c.transferUnconvertedValueOrDefaultToServerModel(lG, uiModel, serverModel);
        c.transferUnconvertedValueOrDefaultToServerModel(lH, uiModel, serverModel);
    }

    @Override
    protected void convertThemeSettingsFromServerModelToUiModel(@Nonnull Map<ThemePropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        c.transferUnconvertedValueOrDefaultToUiModel(lC, serverModel, uiModel);
        c.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(lD, serverModel, uiModel);
        c.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(lE, serverModel, uiModel);
        c.transferUnconvertedValueOrDefaultToUiModel(lF, serverModel, uiModel);
        c.transferUnconvertedValueOrDefaultToUiModel(lG, serverModel, uiModel);
        c.transferUnconvertedValueOrDefaultToUiModel(lH, serverModel, uiModel);
    }

    @Override
    public void appendCSS(@Nonnull AdHocTheme theme, @Nonnull MemoryStream stream) {
        boolean bl = theme.getBooleanOrDefault(lC);
        if (bl) {
            stream.writeASCII("table.adhocthemed.crosstab {border-collapse: separate; border-spacing: 0px;}");
            stream.writeASCII("table.adhocthemed.crosstab th, table.adhocthemed.crosstab td {border: 0px solid ");
            int n2 = theme.getIntOrDefault(lD);
            ColorUtils.appendHtmlColor((MemoryStream)stream, (int)n2);
            stream.writeASCII("; border-right-width: 1px; border-bottom-width: 1px;}");
            stream.writeASCII("table.adhocthemed.crosstab th.first-child, table.adhocthemed.crosstab td.first-child {border-left-width: 1px;}");
            stream.writeASCII("table.adhocthemed.crosstab tr.first-child th, table.adhocthemed.crosstab tr.first-child td {border-top-width: 1px;}");
            stream.writeASCII("table.adhocthemed.crosstab th.crosstab00 {border-left-width: 0px; border-top-width: 0px !important;}");
        }
        stream.writeASCII("table.adhocthemed.crosstab tr th{");
        AdHocTheme.appendFontFromTheme(stream, c.d(theme));
        stream.writeASCII(";text-align:left");
        stream.write(125);
        stream.writeASCII("table.adhocthemed.crosstab tr td{");
        AdHocTheme.appendFontFromTheme(stream, theme.getBody());
        stream.write(125);
        stream.writeASCII("table.adhocthemed.crosstab tr td.sum{");
        AdHocTheme.appendFontFromTheme(stream, theme.getSummary());
        stream.write(125);
    }

    @Nonnull
    static com.inet.report.adhoc.server.theming.a d(@Nonnull AdHocTheme adHocTheme) {
        return adHocTheme.getThemeFontFrom(AdHocTheme.DEFAULT_FONT_FAMILY, lE, AdHocTheme.DEFAULT_FONT_SIZE, lF, lG, lH);
    }

    @Override
    @Nullable
    public PreviewData getPreviewData(@Nullable GUID themeId) {
        return new PreviewData("<table class='adhocthemed crosstab'><thead class='stickyheader'><tr class='first-child'><th class='first-child stickyheader crosstab00'></th><th>" + a.bm.getMsg("preview.column", new Object[0]) + " 1</th><th>" + a.bm.getMsg("preview.column", new Object[0]) + " 1</th></tr></thead><tbody><tr><th class='first-child stickyheader'>" + a.bm.getMsg("preview.row", new Object[0]) + " 1</th><td>" + a.bm.getMsg("preview.value", new Object[0]) + " 1</td><td>" + a.bm.getMsg("preview.value", new Object[0]) + " 2</td></tr><tr><th class='first-child stickyheader'>" + a.bm.getMsg("preview.row", new Object[0]) + " 2</th><td>" + a.bm.getMsg("preview.value", new Object[0]) + " 3</td><td>" + a.bm.getMsg("preview.value", new Object[0]) + " 4</td></tr><tr><th class='first-child stickyheader'>" + a.bm.getMsg("preview.row", new Object[0]) + " 3</th><td>" + a.bm.getMsg("preview.value", new Object[0]) + " 5</td><td>" + a.bm.getMsg("preview.value", new Object[0]) + " 6</td></tr><tr><th class='first-child stickyheader'>" + a.bm.getMsg("preview.result", new Object[0]) + " 10</th><td class='sum'>" + a.bm.getMsg("preview.sum", new Object[0]) + " 1</td><td class='sum'>" + a.bm.getMsg("preview.sum", new Object[0]) + " 2</td></tr></tbody></table>");
    }

    @Override
    @Nonnull
    public /* synthetic */ com.inet.report.adhoc.server.api.renderer.b createInstanceFrom(@Nonnull AdHocDefinition adHocDefinition) {
        return this.e(adHocDefinition);
    }
}

