/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.handler.data;

import com.inet.annotations.JsonData;

@JsonData
public class LayoutSettings {
    private int groupNumber;
    private String groupName;
    private String key;
    private String label;
    private double width;
    private double height;
    private double border;
    private boolean paperFormat;
    private int maxPages;
    private int maxComponentsPerPage;

    public LayoutSettings(int groupNumber, String groupName, String key, String label, int maxPages, int maxComponentsPerPage, double width, double height, boolean paperFormat) {
        this.groupNumber = groupNumber;
        this.groupName = groupName;
        this.key = key;
        this.label = label;
        this.maxPages = maxPages;
        this.maxComponentsPerPage = maxComponentsPerPage;
        this.width = width;
        this.height = height;
        this.border = 1.5;
        if (paperFormat) {
            if (this.width < 18.0 || this.height < 18.0) {
                this.border = 1.0;
            }
            if (this.width < 14.0 || this.height < 14.0) {
                this.border = 0.75;
            }
        }
        this.paperFormat = paperFormat;
    }

    public LayoutSettings(int groupNumber, String groupName, String key, String label, int maxComponents) {
        this(groupNumber, groupName, key, label, 1, maxComponents, -1.0, -1.0, false);
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public int getMaxComponentsPerPage() {
        return this.maxComponentsPerPage;
    }

    public boolean isPaperFormat() {
        return this.paperFormat;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }
}

