/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.theming;

import com.inet.annotations.JsonData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ThemePropertyKey<JSONIZABLE_VALUE> {
    private static final Map<String, ThemePropertyKey<?>> values = new HashMap();
    @Nonnull
    private String name;
    @Nonnull
    private @Nonnull Class<@Nonnull JSONIZABLE_VALUE> type;
    @Nonnull
    private JSONIZABLE_VALUE defaultValue;

    private ThemePropertyKey() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemePropertyKey(@Nonnull String name, @Nonnull @Nonnull Class<@Nonnull JSONIZABLE_VALUE> type, @Nonnull JSONIZABLE_VALUE defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        Map<String, ThemePropertyKey<?>> map = values;
        synchronized (map) {
            if (values.containsKey(name)) {
                throw new IllegalStateException("Duplicate key: " + name);
            }
            values.put(name, this);
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public @Nonnull Class<@Nonnull JSONIZABLE_VALUE> getType() {
        return this.type;
    }

    @Nonnull
    public JSONIZABLE_VALUE getDefaultValue() {
        return this.defaultValue;
    }

    public JSONIZABLE_VALUE cast(@Nonnull Object value) {
        if (this.type.isInstance(value)) {
            return this.type.cast(value);
        }
        throw new ClassCastException("Cannot cast " + value.getClass().getName() + " to " + this.type.getName());
    }

    @Nonnull
    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.equals(((ThemePropertyKey)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static ThemePropertyKey<?> valueOf(String name) {
        if (name == null) {
            return null;
        }
        ThemePropertyKey<Object> themePropertyKey = values.get(name);
        if (themePropertyKey == null) {
            themePropertyKey = new ThemePropertyKey<String>(name, String.class, "");
        }
        return themePropertyKey;
    }
}

