/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.designer.layouter;

import com.inet.font.layout.FontContext;
import com.inet.lib.util.ColorUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.designer.RenderedElement;
import com.inet.report.adhoc.designer.RenderedElementStyle;
import com.inet.report.adhoc.designer.RenderedPage;
import com.inet.report.adhoc.designer.layouter.f;
import com.inet.report.adhoc.designer.layouter.g;
import com.inet.report.adhoc.designer.layouter.h;
import com.inet.report.adhoc.designer.layouter.i;
import com.inet.report.adhoc.designer.layouter.j;
import com.inet.report.adhoc.designer.layouter.k;
import com.inet.report.certificate.CertificateInfo;
import com.inet.report.layout.BulletChunk;
import com.inet.report.layout.Chunk;
import com.inet.report.layout.HyperlinkChunk;
import com.inet.report.layout.ImageChunk;
import com.inet.report.layout.IndentChunk;
import com.inet.report.layout.LineBreakChunk;
import com.inet.report.layout.ListChunk;
import com.inet.report.layout.TextChunk;
import com.inet.report.renderer.doc.Adornment;
import com.inet.report.renderer.doc.CellAdornment;
import com.inet.report.renderer.doc.ComponentLayout;
import com.inet.report.renderer.doc.StyledLayout;
import com.inet.report.renderer.html.HtmlUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public class c
implements ComponentLayout,
StyledLayout {
    private int i = 0;
    private int j = 0;
    private int k = 0;
    private int l = 0;
    private List<@Nonnull RenderedElement> m;
    private List<@Nonnull RenderedElementStyle> n;
    private int o = 0;
    private String p;
    private String q;
    private h r;
    private k s;
    private j t;
    private i u;

    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"setPageLayout");
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)("pageTopMarginInTwips: " + topMargin));
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)("pageLeftMarginInTwips: " + leftMargin));
        this.i = topMargin;
        this.j = leftMargin;
        this.k = HtmlUtils.twipsToPixel((int)width);
        this.l = HtmlUtils.twipsToPixel((int)height);
    }

    public void startPage() {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startPage");
        this.m = new ArrayList<RenderedElement>();
        this.n = new ArrayList<RenderedElementStyle>();
        ++this.o;
        RenderedElement renderedElement = RenderedElement.forPage(this.o);
        this.m.add(renderedElement);
        this.p = renderedElement.getRendererID();
        HashMap<@Nonnull String, @Nonnull String> hashMap = new HashMap<String, String>();
        hashMap.put("width", this.k + "px");
        hashMap.put("height", this.l + "px");
        hashMap.put("position", "relative");
        RenderedElementStyle renderedElementStyle = RenderedElementStyle.forElement(this.p, hashMap);
        this.n.add(renderedElementStyle);
    }

    @Nonnull
    public RenderedPage d() {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endPage");
        RenderedPage renderedPage = new RenderedPage(this.m, this.n);
        this.m = null;
        this.n = null;
        return renderedPage;
    }

    public void startReportComponent(Object customData, int currentRow, int currentPage) {
        assert (customData != null);
        String string = String.valueOf(customData);
        this.q = this.e() ? RenderedElement.createRendererID(this.u.o().getRendererID(), string, currentRow, currentPage) : RenderedElement.createRendererID(string, currentRow, currentPage);
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)("startReportComponent: " + this.q));
    }

    private boolean e() {
        return this.u != null;
    }

    public void startContainer(int x2, int y2, int width, int height, int backgroundColor, boolean underlayFollow) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)String.format("startContainer: x=%d, y=%d, w=%d, h=%d", x2, y2, width, height));
        if (!this.e()) {
            x2 += this.j;
            y2 += this.i;
        }
        x2 = HtmlUtils.twipsToPixel((int)x2);
        y2 = HtmlUtils.twipsToPixel((int)y2);
        width = HtmlUtils.twipsToPixel((int)width);
        height = HtmlUtils.twipsToPixel((int)height);
        this.r = h.a(this.q, x2, y2, width, height, backgroundColor);
    }

    public void endContainer() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endContainer");
        this.r.k();
        if (this.e()) {
            this.u.a(this.r);
        } else {
            this.m.add(this.r.a(this.p));
            this.m.addAll(this.r.l());
            this.n.addAll(this.r.m());
        }
        this.r = null;
    }

    public void startSubreport(int x2, int y2, int width, int height, Adornment adornment, String tooltip) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)String.format("startSubreport: x=%d, y=%d, w=%d, h=%d", x2, y2, width, height));
        x2 = HtmlUtils.twipsToPixel((int)x2);
        y2 = HtmlUtils.twipsToPixel((int)y2);
        width = HtmlUtils.twipsToPixel((int)width);
        height = HtmlUtils.twipsToPixel((int)height);
        tooltip = StringFunctions.encodeHTML((String)tooltip);
        this.u = com.inet.report.adhoc.designer.layouter.i.a(this.q, x2, y2, width, height, adornment, tooltip, this.r);
        this.r = null;
    }

    public void endSubreport() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endSubreport");
        this.u.k();
        this.r = this.u.o();
        this.r.a(this.u);
        this.u = null;
    }

    public void startGroup(int groupLevel, String groupLabel, String requestUrl) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startGroup");
    }

    public void endGroup() {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endGroup");
    }

    public void startTextBox(int x2, int y2, int width, int height, boolean canGrow, Adornment adornment, int vAlign, int rotation, int glyphOrientation, String url, String toolTip, boolean isRichHtml) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startTextBox");
        x2 = HtmlUtils.twipsToPixel((int)x2);
        y2 = HtmlUtils.twipsToPixel((int)y2);
        width = HtmlUtils.twipsToPixel((int)width);
        height = HtmlUtils.twipsToPixel((int)height);
        url = StringFunctions.encodeHTML((String)url);
        toolTip = StringFunctions.encodeHTML((String)toolTip);
        boolean bl = this.t != null;
        this.s = com.inet.report.adhoc.designer.layouter.k.a(this.q, x2, y2, width, height, adornment, vAlign, url, toolTip, bl);
    }

    public void drawChunk(Chunk chunk, int x2, int y2, int align) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)("drawChunk: " + String.valueOf(chunk)));
        if (this.s == null) {
            return;
        }
        x2 = HtmlUtils.twipsToPixel((int)x2);
        y2 = HtmlUtils.twipsToPixel((int)y2);
        switch (chunk.getChunkType()) {
            case 1: {
                TextChunk textChunk = (TextChunk)chunk;
                String string = StringFunctions.encodeHTML((String)textChunk.getText());
                this.s.a(string, textChunk.getFontContext(), align);
                break;
            }
            case 2: {
                LineBreakChunk lineBreakChunk = (LineBreakChunk)chunk;
                this.s.b(lineBreakChunk.getLineSpacingAbsolute(), lineBreakChunk.getLineSpacingRelative());
                if (lineBreakChunk.isWordWrapLineBreak()) {
                    String string = StringFunctions.encodeHTML((String)lineBreakChunk.getWordWrapDiff());
                    this.s.b(string);
                    break;
                }
                if (lineBreakChunk.isOnlyLineBreak()) {
                    this.s.v();
                    break;
                }
                this.s.v();
                this.s.v();
                break;
            }
            case 3: {
                BulletChunk bulletChunk = (BulletChunk)chunk;
                g g2 = g.a(bulletChunk.getBulletType(), g.E);
                this.s.a(bulletChunk.getValue(), g2, align);
                break;
            }
            case 4: {
                ListChunk listChunk = (ListChunk)chunk;
                if (listChunk.isBeginningTag()) {
                    g g3 = g.a(listChunk.getListType(), g.E);
                    this.s.a(g3, align);
                    break;
                }
                this.s.x();
                break;
            }
            case 5: {
                IndentChunk indentChunk = (IndentChunk)chunk;
                if (!indentChunk.isTab()) break;
                this.s.w();
                break;
            }
            case 6: {
                ImageChunk imageChunk = (ImageChunk)chunk;
                int n2 = imageChunk.getWidth() * 15;
                int n3 = imageChunk.getHeight() * 15;
                this.s.a((BufferedImage)imageChunk.getImage(), n2, n3, align);
                break;
            }
            case 7: {
                HyperlinkChunk hyperlinkChunk = (HyperlinkChunk)chunk;
                if (hyperlinkChunk.isBeginningTag()) {
                    this.s.a(hyperlinkChunk.getURL(), hyperlinkChunk.getColor());
                    break;
                }
                this.s.q();
            }
        }
    }

    public void endTextBox() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endTextBox");
        this.s.k();
        if (this.t != null) {
            this.t.a(this.s);
        } else {
            this.r.a(this.s);
        }
        this.s = null;
    }

    public void drawBox(int x2, int y2, int width, int height, Adornment adornment, String url, String toolTip, boolean mso) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"drawBox");
        adornment = HtmlUtils.correctBoxRoundingIfNecessary((int)width, (int)height, (boolean)mso, (Adornment)adornment);
        x2 = HtmlUtils.twipsToPixel((int)x2);
        y2 = HtmlUtils.twipsToPixel((int)y2);
        width = HtmlUtils.twipsToPixel((int)width);
        height = HtmlUtils.twipsToPixel((int)height);
        url = StringFunctions.encodeHTML((String)url);
        toolTip = StringFunctions.encodeHTML((String)toolTip);
        if (this.t != null) {
            this.t.a(this.q, x2, y2, width, height, adornment, url, toolTip);
        } else {
            this.r.a(this.q, x2, y2, width, height, adornment, url, toolTip);
        }
    }

    public void drawLine(int x2, int y2, int width, int height, Adornment adornment) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"drawLine");
        boolean bl = false;
        boolean bl2 = false;
        if (width == 0) {
            bl2 = true;
        } else if (width < 0) {
            x2 += width;
            width = -width;
        }
        if (height == 0) {
            bl = true;
        } else if (height < 0) {
            y2 += height;
            height = -height;
        }
        if (bl2 && bl) {
            return;
        }
        HtmlUtils.correctLineStyles((boolean)bl, (Adornment)adornment);
        int n2 = adornment.getLineWidth();
        if (n2 < 15 && (adornment.getLeftStyle() != 0 || adornment.getTopStyle() != 0 || adornment.getRightStyle() != 0 || adornment.getBottomStyle() != 0)) {
            int n3 = adornment.getBorderColor();
            n3 = ColorUtils.setMinTransparenceLevel((int)n3, (float)0.3f);
            adornment = adornment.createAdornmentwithModifiedLineColorAndLineWidth(n3, 15);
        }
        x2 = HtmlUtils.twipsToPixel((int)x2);
        y2 = HtmlUtils.twipsToPixel((int)y2);
        width = HtmlUtils.twipsToPixel((int)width);
        height = HtmlUtils.twipsToPixel((int)height);
        if (this.t != null) {
            this.t.a(this.q, x2, y2, width, height, adornment);
        } else {
            this.r.a(this.q, x2, y2, width, height, adornment);
        }
    }

    public void startSignature(int x2, int y2, int width, int height, Adornment adornment, CertificateInfo certificateInfo) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startSignature");
    }

    public void endSignature() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endSignature");
    }

    public void drawFormField(int x2, int y2, int width, int height, Adornment adornment, int formFieldType, String[] values, FontContext fontContext, String formName) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"drawFormField");
    }

    public void drawSorting(int x2, int y2, int width, int height, Adornment adornment, String url, String toolTip, boolean down, boolean alphaNumeric) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"drawSorting");
    }

    public byte[] drawImage(Image img, byte[] imgData, String imageKey, Rectangle borderRect, Rectangle imageRect, Adornment adornment, String url, String toolTip) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"drawImage");
        borderRect = new Rectangle(HtmlUtils.twipsToPixel((int)borderRect.x), HtmlUtils.twipsToPixel((int)borderRect.y), HtmlUtils.twipsToPixel((int)borderRect.width), HtmlUtils.twipsToPixel((int)borderRect.height));
        imageRect = new Rectangle(HtmlUtils.twipsToPixel((int)imageRect.x), HtmlUtils.twipsToPixel((int)imageRect.y), HtmlUtils.twipsToPixel((int)imageRect.width), HtmlUtils.twipsToPixel((int)imageRect.height));
        url = StringFunctions.encodeHTML((String)url);
        toolTip = StringFunctions.encodeHTML((String)toolTip);
        if (imgData == null && img != null) {
            try {
                imgData = IOFunctions.getDataURL((BufferedImage)((BufferedImage)img));
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace((Throwable)iOException);
            }
        }
        f f2 = new f(this.q, (BufferedImage)img, imgData, borderRect, imageRect, adornment, url, toolTip);
        if (this.t != null) {
            this.t.a(f2);
        } else {
            this.r.a(f2);
        }
        return imgData;
    }

    public Graphics2D createGraphics(int x2, int y2, int width, int height, Adornment adornment, String url, String toolTip) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"createGraphics");
        return null;
    }

    public void removeGraphics(Graphics2D g2, Exception ex) {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"removeGraphics");
    }

    public void startTable(int x2, int y2, int[] colWidths, int[] rowHeights, Adornment adornment, String url, String toolTip, Insets cellMargins) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startTable");
        y2 -= adornment.getTopBorderSize();
        x2 = HtmlUtils.twipsToPixel((int)x2);
        y2 = HtmlUtils.twipsToPixel((int)y2);
        colWidths = HtmlUtils.twipsToPixel((int[])colWidths);
        rowHeights = HtmlUtils.twipsToPixel((int[])rowHeights);
        url = StringFunctions.encodeHTML((String)url);
        toolTip = StringFunctions.encodeHTML((String)toolTip);
        this.t = com.inet.report.adhoc.designer.layouter.j.a(this.q, x2, y2, colWidths, rowHeights, adornment, url, toolTip);
    }

    public void startRow() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startRow");
        this.t.startRow();
    }

    public void startCell(int col, int row, int colSpan, int rowSpan, CellAdornment cellAdornment, Adornment textboxAdornment, Insets insets, int vAlign, int rotation, int glyphOrientation, String url, String toolTip) throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startCell");
        url = StringFunctions.encodeHTML((String)url);
        toolTip = StringFunctions.encodeHTML((String)toolTip);
        this.s = this.t.a(this.q, col, row, colSpan, rowSpan, vAlign, cellAdornment, textboxAdornment, insets, url, toolTip);
    }

    public void endCell() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endCell");
        if (this.s != null) {
            this.s.k();
            this.t.a(this.s);
            this.s = null;
        }
        this.t.endCell();
    }

    public void endRow() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endRow");
        this.t.endRow();
    }

    public void endTable() throws ReportException {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endTable");
        this.t.k();
        this.r.a(this.t);
        this.t = null;
    }

    public void startMulticolumnRegion(int[] columnPositions, boolean isAcrossThenDown) {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"startMulticolumnRegion");
    }

    public void endMulticolumnRegion() {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"endMulticolumnRegion");
    }

    public void repeatGroupHeaders() {
        AdHocServerPlugin.DESIGNER_LOGGER.debug((Object)"repeatGroupHeaders");
    }

    public void startBand(int y2, int[] heights) throws ReportException {
    }

    public void endBand() throws ReportException {
    }
}

