/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.FallbackFormatter;
import com.inet.viewer.PromptValue;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent a;
    private int b;
    private boolean c;
    private Timer d;
    private Popup e;
    private JLabel f;
    private JPanel g;
    private boolean h;
    private Point i;
    private JComboBox j;
    private boolean k;
    private boolean l;
    private Class m;
    private Constructor n;
    private Class[] o = new Class[]{String.class};
    private Color p;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format q;

    private RealtimeValidationPopup(int promptType) {
        this.b = promptType;
        this.f = new JLabel();
        this.g = new JPanel();
        this.g.setOpaque(true);
        this.g.add(this.f);
        this.g.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.g.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.d = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.a();
        if (this.q == null) {
            return;
        }
        this.k = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.j = surroundingBox;
        }
        this.a = textcomponent;
        this.a.addFocusListener(this);
        this.p = this.a.getBackground();
    }

    private void a() {
        this.q = null;
        switch (this.b % 128) {
            case 6: 
            case 7: {
                this.q = this.k ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.q = this.k ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.q = this.k ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.q = this.k ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void b() {
        if (this.a instanceof JPasswordField) {
            return;
        }
        Object object = this.d();
        String string = object.toString();
        if (!this.a.isEnabled() || !this.a.isShowing() || object.toString().length() == 0 || this.a instanceof JComboBox && ((JComboBox)this.a).isPopupVisible() || (this.b % 128 == 6 || this.b % 128 == 7) && string.equals("-")) {
            if (!this.a.isEnabled()) {
                this.a.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.a.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.q.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.l && this.m != null) {
                if (this.m == Object.class) {
                    this.m = String.class;
                }
                this.n = this.m.getConstructor(this.o);
                this.n.newInstance(string);
            }
            this.c = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.a.getLocationOnScreen();
                point.y += this.a.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.a.invalidate();
            this.a.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.q, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.q.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl = false;
        if (format instanceof FallbackFormatter) {
            format = ((FallbackFormatter)format).getPrimaryFormat();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl;
    }

    public void showErrorPopup() {
        Point point = this.a.getLocationOnScreen();
        point.y += this.a.getHeight();
        this.c = true;
        String string = com.inet.viewer.i18n.a.a("prompt.invalid_input");
        string = string + this.c();
        this.a(string, POPUP_BGCOLOR_ERROR, point);
        this.a.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.a.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.a.getLocationOnScreen();
        point.y += this.a.getHeight();
        this.c = true;
        String string = com.inet.viewer.i18n.a.a("prompt.incomplete_input");
        string = string + this.c();
        this.a(string, POPUP_BGCOLOR_INCOMPLETE, point);
        this.a.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.a.invalidate();
    }

    private String c() {
        Format format;
        switch (this.b) {
            case 9: {
                format = PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                format = PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                format = PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                format = null;
            }
        }
        if (format instanceof SimpleDateFormat) {
            return com.inet.viewer.i18n.a.a("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.b == 6 || this.b == 7) {
            return com.inet.viewer.i18n.a.a("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.a(string);
        this.f.setText(string);
        this.g.setBackground(color);
        if (!this.h) {
            this.i = point;
        } else {
            point = this.i;
        }
        if (this.e != null) {
            this.hidePopup();
        }
        this.e = PopupFactory.getSharedInstance().getPopup(this.a, this.g, point.x, point.y);
        this.e.show();
        this.h = true;
        if (this.d.isRunning()) {
            this.d.restart();
        } else {
            this.d.start();
        }
    }

    private String a(String string) {
        string = this.c ? "<html>" + string + "</html>" : com.inet.viewer.i18n.a.a("prompt.interpreted_as", string);
        return string;
    }

    private Object d() {
        if (this.a instanceof JPasswordField) {
            return new String(((JPasswordField)this.a).getPassword());
        }
        if (this.a instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.a).getText();
            if (this.j == null) {
                return string2;
            }
            Object object = this.j.getSelectedItem();
            if (this.a != null && this.j.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.a instanceof JComboBox) {
            return ((JComboBox)this.a).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.e != null) {
            this.e.hide();
        }
        this.h = false;
        if (this.d.isRunning()) {
            this.d.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.l = checkClassType;
        this.m = classtype;
    }

    public void setPromptType(int promptType) {
        this.b = promptType;
        this.a();
    }

    public void unregister() {
        if (this.a == null) {
            return;
        }
        if (this.a instanceof JTextField) {
            ((JTextField)this.a).getDocument().removeDocumentListener(this);
        } else if (this.a instanceof JComboBox) {
            ((JComboBox)this.a).removeActionListener(this);
            ((JComboBox)this.a).removePopupMenuListener(this);
        }
        this.a.removeFocusListener(this);
        if (this.j != null) {
            this.j.removeActionListener(this);
            this.j.removePopupMenuListener(this);
        }
        this.a.setBackground(this.p);
    }

    public boolean isPopupError() {
        return this.c;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.b();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.b();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.b();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.b();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.b();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.q = format;
    }
}

