/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.Loader;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.ag;
import com.inet.viewer.al;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.zip.Adler32;
import java.util.zip.GZIPInputStream;
import javax.annotation.SuppressFBWarnings;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

@PublicApi
public class URLRenderData
implements RenderData {
    private static final String a = com.inet.viewer.i18n.a.a("error.renderdata.ignoring_timeout");
    private final Properties b = new Properties();
    private Properties c;
    private boolean d;
    private String e;
    private String f;
    private long g = System.currentTimeMillis() / 1000L;
    private String h = TimeZone.getDefault().getID();
    private boolean i;
    private boolean j;
    private a k;
    private boolean l;
    private String m;
    private SSLSocketFactory n;
    private HostnameVerifier o;
    private WeakHashMap<HttpURLConnection, ?> p = new WeakHashMap();
    private final Object q = new Object();
    private static final Hashtable<String, String> r = new Hashtable();

    public URLRenderData(String requestURL) {
        this.setReportLocation(requestURL);
    }

    public URLRenderData(URL url) {
        this.setReportLocation(url.toString());
    }

    @Override
    public void setReportLocation(String url) {
        if (url == null) {
            return;
        }
        int n2 = url.indexOf(63);
        if (n2 >= 0) {
            String string = url.substring(n2 + 1);
            url = url.substring(0, n2 + 1);
            this.a(string);
        } else {
            url = url + "?";
        }
        this.f = url;
        this.a();
    }

    private void a(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&=", true);
        boolean bl = true;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.equals("&")) {
                this.a(string2, string3);
                string2 = "";
                string3 = "";
                bl = true;
                continue;
            }
            if (string4.equals("=")) {
                bl = false;
                continue;
            }
            if (bl) {
                string2 = string4;
                continue;
            }
            string3 = string4;
        }
        this.a(string2, string3);
    }

    private void a(String string, String string2) {
        try {
            String string3;
            String string4;
            if ("promptonrefresh".equalsIgnoreCase(string)) {
                if ("true".equalsIgnoreCase(string2)) {
                    this.setPromptOnRefresh(true);
                } else if ("false".equalsIgnoreCase(string2)) {
                    this.setPromptOnRefresh(false);
                }
                return;
            }
            try {
                string4 = URLDecoder.decode(string, "UTF-8").toLowerCase();
                string4 = URLRenderData.b(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewerUtils.debug("Error: " + string + " could not be decoded. Reason: ");
                illegalArgumentException.printStackTrace(ViewerUtils.getLogStream());
                string4 = string;
            }
            try {
                string3 = URLDecoder.decode(string2, "UTF-8");
                string3 = URLRenderData.b(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewerUtils.debug("Error: " + string2 + " could not be decoded. Reason: ");
                illegalArgumentException.printStackTrace(ViewerUtils.getLogStream());
                string3 = string2;
            }
            this.b.put(string4, string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ViewerUtils.error(unsupportedEncodingException.toString());
            this.b.put(string, string2);
        }
    }

    private static String b(String string) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string);
        int n3 = 0;
        while ((n3 = stringBuilder.indexOf("&#", n3)) >= 0 && (n2 = stringBuilder.indexOf(";", n3)) >= 0) {
            try {
                char c2 = (char)Integer.parseInt(stringBuilder.substring(n3 + 2, n2));
                stringBuilder.delete(n3, n2 + 1);
                stringBuilder.insert(n3, c2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public String getReportLocation() {
        return this.f;
    }

    private static String b(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            if (!enumeration.hasMoreElements()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private static void a(Properties properties, URLConnection uRLConnection) throws IOException {
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            printWriter.print(string + "=" + string2 + "&");
        }
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(HttpURLConnection httpURLConnection, Properties properties, boolean bl, boolean bl2) throws IOException {
        Object object;
        if (httpURLConnection instanceof HttpsURLConnection) {
            object = (HttpsURLConnection)httpURLConnection;
            if (this.n != null) {
                ((HttpsURLConnection)object).setSSLSocketFactory(this.n);
            }
            if (this.o != null) {
                ((HttpsURLConnection)object).setHostnameVerifier(this.o);
            }
        }
        if (this.m != null) {
            httpURLConnection.setRequestProperty("Cookie", this.m);
        }
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, identity");
        httpURLConnection.setRequestProperty("timezone", this.h);
        object = this.q;
        synchronized (object) {
            this.p.put(httpURLConnection, null);
        }
        if (!bl || bl2) {
            URLRenderData.a(properties, httpURLConnection);
        }
        httpURLConnection.connect();
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only used on client side")
    void a(a a2, Properties properties, String string, boolean bl) throws IOException, ViewerException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2 = false;
        Object object5 = this.f;
        boolean bl3 = bl = bl || this.l;
        if (bl) {
            object4 = this.a(properties);
            if (object4 != null) {
                object5 = object4;
            } else {
                bl2 = true;
            }
        }
        object4 = new URL((String)object5);
        HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object4).openConnection();
        this.a(httpURLConnection, properties, bl, bl2);
        a2.c = httpURLConnection;
        try {
            a2.a = httpURLConnection.getInputStream();
        }
        catch (ProtocolException protocolException) {
            httpURLConnection = URLRenderData.a(httpURLConnection);
            if (httpURLConnection == null) {
                throw protocolException;
            }
            this.a(httpURLConnection, properties, bl, bl2);
            a2.c = httpURLConnection;
            a2.a = httpURLConnection.getInputStream();
        }
        this.c();
        String string2 = httpURLConnection.getHeaderField("Set-Cookie");
        if (string2 != null) {
            try {
                Map<String, List<String>> map;
                object3 = CookieHandler.getDefault();
                if (object3 == null) {
                    object3 = new CookieManager();
                    CookieHandler.setDefault((CookieHandler)object3);
                    ((CookieHandler)object3).put(httpURLConnection.getURL().toURI(), httpURLConnection.getHeaderFields());
                }
                if (this.getCookie() != null && (map = ((CookieHandler)object3).get(httpURLConnection.getURL().toURI(), httpURLConnection.getHeaderFields())).containsKey("Cookie") && (object2 = map.get("Cookie")) != null && object2.size() > 0 && (object = (String)object2.get(0)) != null && ((String)object).length() > 0) {
                    this.setCookie(null);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ViewerUtils.printStackTrace(uRISyntaxException);
            }
        }
        a2.b = httpURLConnection.getContentLength();
        object3 = httpURLConnection.getContentType();
        if (object3 == null) {
            throw new ViewerException(com.inet.viewer.i18n.a.a("error.renderdata.contentType_returns_null") + " " + httpURLConnection.getContentLength());
        }
        if ("gzip".equals(httpURLConnection.getContentEncoding())) {
            a2.a = new GZIPInputStream(a2.a, 8192);
            a2.b = -1;
        }
        if ((n2 = ((String)object3).indexOf(59)) != -1) {
            object3 = ((String)object3).substring(0, n2);
        }
        if ((object2 = r.get(object3)) == null || !this.b(string, (String)object2)) {
            if ("bin".equals(object2)) {
                object = new Loader();
                ((Loader)object).data = this.a(a2);
                ((Loader)object).readTokens();
            }
            this.c();
            object = null;
            try {
                byte[] byArray = new byte[1024];
                int n3 = a2.a.read(byArray);
                a2.a.close();
                object = n3 > 0 ? Loader.a(byArray, 0, n3) : "no data";
            }
            catch (Throwable throwable) {
                ViewerUtils.printStackTrace(throwable);
            }
            throw new ViewerException(0, com.inet.viewer.i18n.a.a("error.renderdata.wrong_mime_type") + " " + (String)object3, string, null, null, null, 0, (String)object);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only used on client side")
    private static HttpURLConnection a(HttpURLConnection httpURLConnection) {
        try {
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            List<String> list = map.get("WWW-Authenticate");
            for (String string : list) {
                URL uRL;
                PasswordAuthentication passwordAuthentication;
                if (!string.toUpperCase().startsWith("BASIC") || (passwordAuthentication = Authenticator.requestPasswordAuthentication((uRL = httpURLConnection.getURL()).getHost(), null, uRL.getPort(), uRL.getProtocol(), "", "BASIC", uRL, Authenticator.RequestorType.SERVER)) == null) continue;
                byte[] byArray = (passwordAuthentication.getUserName() + ':' + new String(passwordAuthentication.getPassword())).getBytes("UTF-8");
                string = Base64.getEncoder().encodeToString(byArray);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestProperty("Authorization", "Basic " + string);
                return httpURLConnection;
            }
        }
        catch (IOException iOException) {
            ViewerUtils.printStackTrace(iOException);
        }
        return null;
    }

    String a(Properties properties) {
        String string = this.f;
        String string2 = URLRenderData.b(properties);
        if (!string.endsWith("?")) {
            string = string + "&";
        }
        if ((string = string + string2).length() > 1023 && !this.l) {
            return null;
        }
        return string;
    }

    private boolean b(String string, String string2) {
        if (string.equalsIgnoreCase("data")) {
            string = "csv";
        } else if ("zip".equals(string2) && ("jpg".equals(string) || "png".equals(string) || "gif".equals(string) || "bmp".equals(string))) {
            return true;
        }
        return string.toLowerCase().startsWith(string2);
    }

    private byte[] a(Properties properties, String string) throws ViewerException {
        return this.a(properties, string, true, null);
    }

    private byte[] a(Properties properties, String string, boolean bl, a a2) throws ViewerException {
        if (EventQueue.isDispatchThread()) {
            ViewerUtils.debug("contacting server on EDT...");
            ViewerUtils.printStackTrace(new ViewerException("debug info"));
        }
        while (bl) {
            Object object;
            a a3 = a2 == null ? new a() : a2;
            try {
                Object object2;
                boolean bl2 = true;
                try {
                    this.a(a3, properties, string, false);
                    bl2 = false;
                }
                catch (ViewerException viewerException) {
                    try {
                        bl2 = this.a(a3, properties, string);
                    }
                    catch (ViewerException viewerException2) {
                        object = viewerException2;
                    }
                    if (bl2) {
                        if (this.l || ((ViewerException)object).srvVersion != null && ((ViewerException)object).srvVersion.length() > 0 || this.j) {
                            throw object;
                        }
                        ViewerUtils.debug("Encountered: " + ((Throwable)object).getMessage() + " while trying POST request.");
                    }
                }
                catch (IOException iOException) {
                    if (a3.c instanceof HttpURLConnection) {
                        InputStream inputStream;
                        object2 = (HttpURLConnection)a3.c;
                        int n2 = ((HttpURLConnection)object2).getResponseCode();
                        if (n2 == 401) {
                            throw iOException;
                        }
                        if (n2 >= 300 && n2 <= 399) {
                            ViewerUtils.debug("encountered HTTP " + n2 + " --> " + ((URLConnection)object2).getHeaderField("Location"));
                        }
                        if ((inputStream = ((HttpURLConnection)object2).getErrorStream()) != null) {
                            String string2 = ((URLConnection)object2).getContentType();
                            if ("gzip".equals(((URLConnection)object2).getContentEncoding())) {
                                inputStream = new GZIPInputStream(inputStream, 8192);
                            }
                            ViewerUtils.debug(this.a(this.a(inputStream), string2));
                        }
                    }
                    if (this.l || this.j) {
                        throw iOException;
                    }
                    ViewerUtils.debug("Encountered: " + iOException.getMessage() + " while trying POST request.");
                }
                if (!bl2) {
                    if (a2 != null) {
                        return null;
                    }
                    object = this.a(a3);
                    object2 = properties.get("cmd").toString();
                    if (object2 != null && (((String)object2).equals("get_pg_count") || ((String)object2).equals("ping")) || this.a((byte[])object) || this.l) {
                        return object;
                    }
                    ViewerUtils.debug("Encountered Checksum Problem!");
                }
                ViewerUtils.debug(" => Fallback to HTTP GET Request instead of POST");
                this.a(a3, properties, string, true);
                return a2 == null ? this.a(a3) : null;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.c();
                ViewerUtils.debug(a);
            }
            catch (IOException iOException) {
                ViewerUtils.error("Problem when attemping to connect via GET with URL '" + this.f + "'");
                this.c();
                try {
                    if (a3.c instanceof HttpURLConnection) {
                        Object object3;
                        object = (HttpURLConnection)a3.c;
                        if (((HttpURLConnection)object).getResponseCode() == 504) {
                            ViewerUtils.debug(a);
                            continue;
                        }
                        InputStream inputStream = ((HttpURLConnection)object).getErrorStream();
                        String string3 = ((URLConnection)object).getContentType();
                        if ("gzip".equals(((URLConnection)object).getContentEncoding())) {
                            inputStream = new GZIPInputStream(inputStream, 8192);
                        }
                        ByteArrayOutputStream byteArrayOutputStream = this.a(inputStream);
                        String string4 = r.get(string3);
                        if ("bin".equals(string4)) {
                            try {
                                object3 = new Loader();
                                ((Loader)object3).data = byteArrayOutputStream.toByteArray();
                                ((Loader)object3).readTokens();
                            }
                            catch (ViewerException viewerException) {
                                throw viewerException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        object3 = this.a(byteArrayOutputStream, string3);
                        ViewerUtils.debug((String)object3);
                        if (((String)object3).startsWith("<html>")) {
                            throw ViewerException.createViewerExceptionWithMessage((String)object3, iOException);
                        }
                        ViewerException viewerException = ViewerException.createViewerException(iOException);
                        if (((String)object3).length() > 5) {
                            viewerException.stacktrace = object3;
                        }
                        throw viewerException;
                    }
                    if (a3.a != null) {
                        a3.a.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw ViewerException.createViewerException(iOException);
            }
            catch (Exception exception) {
                try {
                    a3.a.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.c();
                throw ViewerException.createViewerException(exception);
            }
        }
        return null;
    }

    private boolean a(a a2, Properties properties, String string) throws ViewerException, IOException {
        String string2;
        HttpURLConnection httpURLConnection;
        int n2;
        if (a2.c instanceof HttpURLConnection && (n2 = (httpURLConnection = (HttpURLConnection)a2.c).getResponseCode()) >= 300 && n2 <= 399 && (string2 = httpURLConnection.getHeaderField("Location")) != null && !string2.equals(this.f)) {
            ViewerUtils.debug("Redirect from: " + this.f + " to: " + string2);
            this.f = string2;
            this.a(a2, properties, string, false);
            return false;
        }
        return true;
    }

    private ByteArrayOutputStream a(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (inputStream == null) {
            return byteArrayOutputStream;
        }
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream;
    }

    private String a(ByteArrayOutputStream byteArrayOutputStream, String string) {
        String string2;
        if (string != null) {
            int n2 = string.indexOf("charset=");
            if (n2 > 0) {
                char c2;
                char c3;
                string2 = string.substring(n2 + "charset=".length());
                int n3 = string2.length();
                if (n3 > 2 && (c3 = string2.charAt(0)) == (c2 = string2.charAt(n3 - 1)) && (c3 == '\'' || c3 == '\"')) {
                    string2 = string2.substring(1, n3 - 1);
                }
            } else {
                string2 = "utf8";
            }
        } else {
            string2 = "utf8";
        }
        try {
            return byteArrayOutputStream.toString(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byteArrayOutputStream.toString();
        }
    }

    private boolean a(byte[] byArray) {
        int n2 = byArray.length - 4;
        if (n2 < 0) {
            return false;
        }
        int n3 = (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF);
        Adler32 adler32 = new Adler32();
        adler32.update(byArray, 0, byArray.length - 4);
        int n4 = (int)adler32.getValue();
        return n4 == n3;
    }

    void a() {
        this.k = null;
    }

    private byte[] a(a a2) throws IOException {
        return this.a(a2, a2.b, true);
    }

    private byte[] a(a a2, int n2, boolean bl) throws IOException {
        this.c();
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n2 > 0) {
                int n4 = a2.a.read(byArray, n3, n2);
                if (n4 < 0) {
                    if (bl) {
                        throw new ViewerException(com.inet.viewer.i18n.a.a("error.renderdata.wrong_packet_size_received") + " " + n3 + " " + com.inet.viewer.i18n.a.a("error.renderdata.bytes_expected") + " " + (n2 + n3));
                    }
                    if (n3 > 0) {
                        byte[] byArray2 = new byte[n3];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        return byArray2;
                    }
                    return null;
                }
                n2 -= n4;
                n3 += n4;
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n5;
        while ((n5 = a2.a.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n5);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        if (page < 1) {
            throw new ViewerException("Page out of allowed range: " + page);
        }
        byte[] byArray = this.a(this.a("get_pg", page), "bin");
        Loader loader = new Loader();
        loader.data = byArray;
        loader.readTokens();
        return byArray;
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        this.i = true;
        this.j = false;
        return this.a(this.a("rfsh", page), "bin");
    }

    @Override
    public int getPageCount() throws ViewerException {
        byte[] byArray = this.a(this.g(), "bin");
        if (byArray.length == 4) {
            return (byArray[0] << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        }
        Loader loader = new Loader();
        loader.data = byArray;
        loader.readTokens();
        throw new ViewerException(new String("unknown data from the server: " + byArray));
    }

    @Override
    public boolean isPageLimitExceeded() throws ViewerException {
        Properties properties = this.e();
        properties.put("cmd", "get_pg_limit");
        byte[] byArray = this.a(properties, "bin");
        ag ag2 = new ag();
        ag2.data = byArray;
        ag2.readTokens();
        return ag2.a();
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        if (this.c == null) {
            throw new ViewerException(com.inet.viewer.i18n.a.a("error.renderdata.getChunkCount_needed"));
        }
        while (true) {
            try {
                if (this.k == null) {
                    return null;
                }
                if (this.k.b < 0) {
                    byte[] byArray = this.a(this.k, 4096, false);
                    if (byArray == null) {
                        this.k = null;
                    }
                    return byArray;
                }
                if (this.k.b < 4096) {
                    byte[] byArray = this.a(this.k);
                    this.k = null;
                    return byArray;
                }
                this.k.b -= 4096;
                return this.a(this.k, 4096, true);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.c();
                ViewerUtils.debug(a);
                continue;
            }
            catch (Exception exception) {
                try {
                    this.k.a.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.c();
                throw ViewerException.createViewerException(exception);
            }
            break;
        }
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        this.c = this.e();
        this.c.put("cmd", "export");
        if (expProps != null) {
            Enumeration<?> enumeration = expProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.c.put(string, ViewerUtils.encode(expProps.getProperty(string)));
            }
        } else {
            throw new IllegalArgumentException("Null is not supported as argument for getExportChunkCount.");
        }
        this.k = new a();
        this.a(this.c, this.c.getProperty("export_fmt"), true, this.k);
        return (int)Math.ceil((double)this.k.b / 4096.0);
    }

    private void c() throws ViewerException {
        if (this.j) {
            this.j = false;
            throw new ViewerException(com.inet.viewer.i18n.a.a("error.renderdata.page_rendering_canceled"));
        }
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        return this.a(this.f(), "bin");
    }

    @Override
    public void setReportTitle(String title) {
        this.e = title;
    }

    @Override
    public String getReportTitle() {
        return this.e;
    }

    private Properties d() {
        Properties properties = new Properties();
        properties.put("viewer", "java2");
        properties.put("vgen", String.valueOf(this.g));
        properties.put("timezone", String.valueOf(this.h));
        return properties;
    }

    private Properties e() {
        Properties properties = this.d();
        if (this.b != null) {
            Enumeration<?> enumeration = this.b.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                properties.put(ViewerUtils.encode(string), ViewerUtils.encode(this.b.getProperty(string)));
            }
        }
        return properties;
    }

    private Properties a(String string, int n2) {
        Properties properties = this.e();
        if (this.i && this.isPromptOnRefresh()) {
            properties.put("promptOnRefresh", "1");
        } else if (this.i && !this.isPromptOnRefresh()) {
            properties.put("promptOnRefresh", "0");
        }
        this.i = false;
        properties.put("cmd", string);
        properties.put("page", String.valueOf(n2));
        return properties;
    }

    private Properties f() {
        Properties properties = this.e();
        properties.put("cmd", "get_grouptree");
        return properties;
    }

    private Properties g() {
        Properties properties = this.e();
        properties.put("cmd", "get_pg_count");
        return properties;
    }

    @Override
    public final void setReportProperty(String key, String value) {
        if (value == null) {
            this.b.remove(key.toLowerCase());
        } else {
            this.b.put(key.toLowerCase(), value);
        }
        this.a();
    }

    @Override
    public final Properties getProperties() {
        this.a();
        return this.b;
    }

    @Override
    public final String getReportProperty(String key) {
        return this.b.getProperty(key);
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.a();
        this.d = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.d;
    }

    @Override
    public RenderData getCopy() {
        URLRenderData uRLRenderData = new URLRenderData(this.getReportLocation());
        uRLRenderData.i = this.i;
        uRLRenderData.l = this.l;
        uRLRenderData.b.putAll((Map<?, ?>)this.b);
        uRLRenderData.m = this.m;
        uRLRenderData.n = this.n;
        uRLRenderData.o = this.o;
        return uRLRenderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        WeakHashMap<HttpURLConnection, ?> weakHashMap;
        this.j = true;
        this.a(this.a("stop", 1), "bin", false, null);
        Iterator<HttpURLConnection> iterator = this.q;
        synchronized (iterator) {
            weakHashMap = this.p;
            this.p = new WeakHashMap();
        }
        for (URLConnection uRLConnection : weakHashMap.keySet()) {
            if (uRLConnection == null || !(uRLConnection instanceof HttpURLConnection)) continue;
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        Properties properties = this.e();
        properties.put("cmd", "search");
        properties.put("phrase", ViewerUtils.encode(phrase));
        properties.put("page", Integer.toString(startPage));
        properties.put("flags", Integer.toString(flags));
        return this.a(properties, "bin");
    }

    @Override
    public byte[] getFontData(int fontID) {
        Properties properties = this.e();
        properties.put("export_fmt", "font");
        properties.put("cmd", "get_pg");
        properties.put("page", Integer.toString(fontID));
        return this.a(properties, "bin");
    }

    @Override
    public void resetServerCacheTimeout() {
        Properties properties = this.e();
        properties.put("cmd", "ping");
        byte[] byArray = this.a(properties, "bin");
        al al2 = new al();
        al2.data = byArray;
        al2.readTokens();
    }

    public void setForceUseGET(boolean force) {
        this.l = force;
    }

    public boolean isForceUseGET() {
        return this.l;
    }

    public void setCookie(String cookie) {
        this.m = cookie;
    }

    public String getCookie() {
        return this.m;
    }

    void b() {
        this.j = false;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.n = sslSocketFactory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.o = hostnameVerifier;
    }

    static {
        r.put("application/crystalclear", "bin");
        r.put("application/clearreports", "bin");
        r.put("application/pdf", "pdf");
        r.put("application/ps", "ps");
        r.put("application/msword", "rtf");
        r.put("application/rtf", "rtf");
        r.put("application/jra", "jra");
        r.put("application/jar", "jar");
        r.put("application/json", "json");
        r.put("text/rtf", "rtf");
        r.put("application/vnd.ms-excel", "xls");
        r.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        r.put("text/x-comma-separated-values", "csv");
        r.put("text/comma-separated-values", "csv");
        r.put("text/xml", "xml");
        r.put("text/plain", "txt");
        r.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        r.put("text/html", "htm");
        r.put("image/svg+xml", "svg");
        r.put("image/bmp", "bmp");
        r.put("image/gif", "gif");
        r.put("image/png", "png");
        r.put("image/jpeg", "jpg");
        r.put("application/zip", "zip");
        r.put("application/vnd.oasis.opendocument.spreadsheet", "ods");
    }

    private static class a {
        private InputStream a;
        private int b;
        private URLConnection c;

        private a() {
        }
    }
}

