/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.css.HTML;
import com.inet.html.utils.Logger;
import com.inet.html.views.ControlView;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;

public class ObjectView
extends ControlView
implements ContainerListener {
    private HashMap<String, String> cacheParams;
    private JComponent control = null;
    private boolean initialized = false;

    public ObjectView(Element elem) {
        super(elem);
    }

    public boolean canLoad() {
        return this.getComponentClass() != null;
    }

    private Class<?> getComponentClass() {
        block6: {
            AttributeSet atts = this.getElement().getAttributes();
            if (atts.isDefined((Object)HTML.Attribute.CLASSID)) {
                try {
                    Class<?> component;
                    URI classURI = new URI(atts.getAttribute((Object)HTML.Attribute.CLASSID).toString());
                    if ("java".equalsIgnoreCase(classURI.getScheme()) && JComponent.class.isAssignableFrom(component = this.loadClass(classURI.getSchemeSpecificPart()))) {
                        return component;
                    }
                }
                catch (URISyntaxException e) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!Logger.doesLog(1)) break block6;
                    Logger.error(e);
                }
            }
        }
        return null;
    }

    @Override
    protected JComponent createControl() {
        if (this.control == null && !this.initialized) {
            Class<?> component = this.getComponentClass();
            if (component != null) {
                this.control = this.createControlFromClass(component);
                if (this.control != null) {
                    this.setParametersToComponent(this.control);
                    this.persistSize(this.control);
                    this.control.addContainerListener(this);
                }
            }
            this.initialized = true;
        }
        return this.control;
    }

    private HashMap<String, String> getParameters() {
        if (this.cacheParams != null) {
            return this.cacheParams;
        }
        this.cacheParams = new HashMap();
        Element elem = this.getElement();
        for (int i = 0; i < elem.getElementCount(); ++i) {
            Element child = elem.getElement(i);
            if (child.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.PARAM) continue;
            Object name = child.getAttributes().getAttribute((Object)HTML.Attribute.NAME);
            Object value = child.getAttributes().getAttribute((Object)HTML.Attribute.VALUE);
            Object valueType = child.getAttributes().getAttribute((Object)HTML.Attribute.VALUETYPE);
            if (name == null || value == null || valueType != null && !"data".equalsIgnoreCase(valueType.toString())) continue;
            this.cacheParams.put(name.toString().toLowerCase(), value.toString());
        }
        return this.cacheParams;
    }

    private void setParametersToComponent(JComponent target) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(target.getClass());
        }
        catch (IntrospectionException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
            return;
        }
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        HashMap<String, String> attr = this.getParameters();
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName().toLowerCase();
            String val = attr.get(propName);
            if (val == null || !(val instanceof String)) continue;
            String value = val;
            Method writer = props[i].getWriteMethod();
            if (writer == null) {
                return;
            }
            Class<?>[] params = writer.getParameterTypes();
            if (params.length != 1) {
                return;
            }
            Object[] args = new Object[]{value};
            try {
                writer.invoke((Object)target, args);
                continue;
            }
            catch (Exception ex) {
                if (!Logger.doesLog(1)) continue;
                Logger.error(ex);
            }
        }
    }

    private JComponent createControlFromClass(Class<?> component) {
        block5: {
            if (component != null && JComponent.class.isAssignableFrom(component)) {
                try {
                    return (JComponent)component.newInstance();
                }
                catch (InstantiationException e) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (!Logger.doesLog(1)) break block5;
                    Logger.error(e);
                }
            }
        }
        return null;
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> documentClass = this.getDocument().getClass();
        ClassLoader loader = documentClass.getClassLoader();
        Class<?> clazz = loader != null ? loader.loadClass(className) : Class.forName(className);
        return clazz;
    }

    @Override
    public boolean isSubmit() {
        return false;
    }

    @Override
    public boolean isSuccessful(ControlView activator) {
        return false;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.setStatus(2);
        this.forceLayout(300L);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.setStatus(2);
        this.forceLayout(300L);
    }
}

