/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.utils.Logger;
import com.inet.html.views.ContentView;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class ContentPainter {
    private ContentView view;
    private boolean charOffsetsSet;
    private float[] charOffsets;
    private float width = -1.0f;
    private int ascent;
    private int descent;
    private boolean isReversed;
    private int height;
    private static final Font FALLBACK_FONT = new Font("Sans Serif", 0, 12);

    public ContentPainter(ContentView view) {
        this.view = view;
    }

    public void setView(ContentView view) {
        this.view = view;
    }

    public float getSpan() {
        if (this.charOffsetsSet) {
            if (this.charOffsets != null) {
                return this.charOffsets[this.charOffsets.length - 1];
            }
            return 0.0f;
        }
        if (this.width < 0.0f) {
            this.width = this.calculateWidth();
        }
        return this.width;
    }

    protected float calculateWidth() {
        try {
            Segment text = this.view.getSegment();
            Rectangle2D bounds = this.view.getFont().getStringBounds(text.array, text.offset, text.offset + text.count, this.view.getRenderContext().getFontRenderContext());
            return (float)bounds.getWidth();
        }
        catch (Throwable e1) {
            if (Logger.doesLog(1)) {
                Logger.error(e1);
            }
            return 1.0f;
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.height;
    }

    protected Metrics getFontMetrics() {
        FontMetrics metrics;
        Font f = this.view.getFont();
        float scaleFactor = 100.0f;
        f = f.deriveFont(f.getSize2D() * scaleFactor);
        JEditorPane c = this.view.getRenderContext().getTextContainer();
        FontMetrics fontMetrics = metrics = c != null ? ((Component)c).getFontMetrics(f) : Toolkit.getDefaultToolkit().getFontMetrics(f);
        if (metrics.getHeight() == 0 && f.getSize() > 0) {
            f = FALLBACK_FONT.deriveFont(f.getSize2D()).deriveFont(f.getStyle());
            metrics = c != null ? ((Component)c).getFontMetrics(f) : Toolkit.getDefaultToolkit().getFontMetrics(f);
        }
        return new Metrics(metrics, scaleFactor);
    }

    public void paint(Graphics g, Shape a, int start, int length, int baseline) {
        try {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            int x = alloc.x;
            int y = alloc.y + baseline;
            Segment text = this.view.getSegment();
            g.setFont(this.view.getFont());
            g.drawString(text.toString().substring(start, start + length), x, y);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Shape modelToView(int pos, Position.Bias bias, Shape a) throws BadLocationException {
        float[] charOffsets = this.getCharOffsets();
        Rectangle rect = a.getBounds();
        int offset = this.view.getStartOffset();
        if (charOffsets == null || charOffsets.length == 0) {
            if (!this.view.isNativeLTR() && bias == Position.Bias.Forward || this.view.isNativeLTR() && bias == Position.Bias.Backward) {
                rect.x += rect.width;
            }
            if (rect.width == 0) {
                rect.width = 1;
            }
            return rect;
        }
        rect.x = (int)((float)rect.x + charOffsets[Math.min(pos - offset, charOffsets.length - 1)]);
        rect.width = 0;
        return rect;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        int textOffset;
        Rectangle rect = a.getBounds();
        if (x < (float)rect.x) {
            return this.view.isNativeLTR() ? this.view.getStartOffset() : this.view.getEndOffset();
        }
        if (x > (float)rect.x + this.getSpan()) {
            return this.view.isNativeLTR() ? this.view.getEndOffset() : this.view.getStartOffset();
        }
        float[] charOffsets = this.getCharOffsets();
        int offset = this.view.getStartOffset();
        if (charOffsets == null || charOffsets.length == 0) {
            return offset;
        }
        float prevPos = charOffsets[0];
        float nextPos = charOffsets[0];
        if (this.view.isNativeLTR()) {
            for (textOffset = 1; nextPos + (float)rect.x <= x && textOffset < charOffsets.length; ++textOffset) {
                prevPos = nextPos;
                nextPos = charOffsets[textOffset];
                float diff = nextPos - prevPos;
                if (!(nextPos + (float)rect.x >= x)) continue;
                if (prevPos + (float)rect.x + diff / 2.0f >= x) {
                    biasReturn[0] = Position.Bias.Forward;
                    return textOffset + offset - 1;
                }
                biasReturn[0] = Position.Bias.Backward;
                return textOffset + offset;
            }
        } else {
            while (nextPos + (float)rect.x >= x && textOffset < charOffsets.length) {
                prevPos = nextPos;
                nextPos = charOffsets[textOffset];
                float diff = nextPos - prevPos;
                if (nextPos + (float)rect.x < x) {
                    if (prevPos + (float)rect.x + diff / 2.0f < x) {
                        biasReturn[0] = Position.Bias.Forward;
                        return textOffset + offset - 1;
                    }
                    biasReturn[0] = Position.Bias.Backward;
                    return textOffset + offset;
                }
                ++textOffset;
            }
        }
        if (textOffset == charOffsets.length) {
            return textOffset + offset - 1;
        }
        return offset;
    }

    public void sync() {
        Metrics metrics = this.getFontMetrics();
        float lead = metrics.getLeading();
        float localAscent = metrics.getAscent();
        float localDescent = metrics.getDescent();
        this.height = Math.round((localAscent += lead / 2.0f) + (localDescent += lead / 2.0f));
        this.ascent = Math.round(localAscent);
        this.descent = Math.round(localDescent);
        float ascD = (float)this.ascent - localAscent;
        float desD = (float)this.descent - localDescent;
        if (this.ascent + this.descent > this.height) {
            if (ascD > desD) {
                --this.ascent;
            } else {
                --this.descent;
            }
        }
        if (this.ascent + this.descent < this.height) {
            if (ascD > desD) {
                ++this.descent;
            } else {
                ++this.ascent;
            }
        }
        this.width = this.calculateWidth();
        this.charOffsetsSet = false;
    }

    protected void calculateCharOffsets(Segment text) {
        float[] charOffsets = new float[text.count + 1];
        charOffsets[0] = 0.0f;
        Font font = this.view.getFont();
        FontRenderContext frc = this.view.getRenderContext().getFontRenderContext();
        for (int i = 1; i <= text.count; ++i) {
            charOffsets[i] = font.getStringBounds((char[])text.array, (int)text.offset, (int)(text.offset + i), (FontRenderContext)frc).getBounds().width;
        }
        this.setCharOffsets(charOffsets);
    }

    public float[] getCharOffsets() {
        if (!this.charOffsetsSet) {
            this.charOffsetsSet = true;
            try {
                Segment text = this.view.getSegment();
                if (text.count == 0) {
                    return new float[]{0.0f};
                }
                this.calculateCharOffsets(text);
            }
            catch (BadLocationException e) {
                Logger.error(e);
            }
            catch (StringIndexOutOfBoundsException e2) {
                Logger.error(e2);
            }
        }
        return this.charOffsets;
    }

    public void setCharOffsets(float[] charOffsets) {
        this.charOffsetsSet = true;
        if (this.isReversed) {
            float[] reverse = new float[charOffsets.length];
            for (int i = 0; i < charOffsets.length; ++i) {
                reverse[charOffsets.length - i - 1] = charOffsets[i];
            }
            charOffsets = reverse;
        }
        this.charOffsets = charOffsets;
    }

    public boolean isCharOffsetsSet() {
        return this.charOffsetsSet;
    }

    public ContentPainter copy(ContentView target) {
        ContentPainter copy = new ContentPainter(target);
        return copy;
    }

    public void setReversed() {
        this.isReversed = true;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public void reset() {
        this.charOffsetsSet = false;
        this.width = -1.0f;
    }

    protected static class Metrics {
        private FontMetrics metrics;
        private float scale;

        public Metrics(FontMetrics metrics, float scale) {
            this.metrics = metrics;
            this.scale = scale;
        }

        public float getAscent() {
            return (float)this.metrics.getAscent() / this.scale;
        }

        public float getDescent() {
            return (float)this.metrics.getDescent() / this.scale;
        }

        public float getHeight() {
            return (float)this.metrics.getHeight() / this.scale;
        }

        public float getLeading() {
            return (float)this.metrics.getLeading() / this.scale;
        }

        public float charWidth(char c) {
            return (float)this.metrics.charWidth(c) / this.scale;
        }
    }
}

