/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.utils.AbstractDecoder;
import com.inet.html.utils.Logger;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;

public class BMPDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = -8230871491045063636L;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    public static final int BI_JPEG = 4;
    public static final int BI_PNG = 5;

    public BMPDecoder() {
    }

    public BMPDecoder(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        try {
            this.decodeImage(0, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Image decodeImage(int suggestedWidth, int suggestedHeight) throws IOException {
        MemoryImageSource source = null;
        this.setIndexTo(this.getOffset());
        this.skipBytes(14);
        int bInfoSize = this.readInt();
        if (bInfoSize < 40) {
            throw new IOException("bmi size < 40 : " + bInfoSize);
        }
        int width = this.readInt();
        int height = this.readInt();
        this.skipBytes(2);
        int bitPerPixel = this.readShort();
        int scan = width / 4 * 4;
        if (width % 4 > 0) {
            scan += 4;
        }
        int bInfoCompression = this.readInt();
        this.skipBytes(4);
        this.setPpmx(this.readInt());
        this.setPpmy(this.readInt());
        int color_num = this.readInt();
        this.skipBytes(4);
        this.skipBytes(bInfoSize - 40);
        switch (bitPerPixel) {
            case 1: {
                IndexColorModel model = this.getColorModel(bitPerPixel, color_num);
                byte[] pixBuf = new byte[width * height];
                scan = width + 31 >> 3 & 0xFFFFFFFC;
                for (int h = height - 1; h >= 0; --h) {
                    for (int w = 0; w < width; w += 8) {
                        byte b = this.readByte();
                        for (int k = 0; k < 8 && k < width - w; ++k) {
                            byte colorIndex;
                            pixBuf[h * width + w + k] = colorIndex = (byte)(b >> 7 - k & 1);
                        }
                    }
                }
                source = new MemoryImageSource(width, height, (ColorModel)model, pixBuf, 0, width);
                break;
            }
            case 4: {
                IndexColorModel model = this.getColorModel(bitPerPixel, color_num);
                byte[] pixBuf = new byte[width * height];
                if (bInfoCompression == 2) {
                    Logger.warning("can not read bmp compression: " + bInfoCompression);
                    return null;
                }
                for (int h = height - 1; h >= 0; --h) {
                    int readValue = 0;
                    int pixel = 0;
                    for (int w = 0; w < width; ++w) {
                        if ((w & 1) == 0) {
                            readValue = this.readByte();
                            pixel = readValue >> 4;
                        } else {
                            pixel = readValue;
                        }
                        pixBuf[h * width + w] = (byte)(pixel &= 0xF);
                    }
                }
                source = new MemoryImageSource(width, height, (ColorModel)model, pixBuf, 0, width);
                break;
            }
            case 8: {
                IndexColorModel model = this.getColorModel(bitPerPixel, color_num);
                int scanDiff = scan - width;
                byte[] pixels = new byte[width * height];
                for (int i = height - 1; i >= 0; --i) {
                    for (int k = 0; k < width; ++k) {
                        pixels[i * width + k] = this.readByte();
                    }
                    this.skipBytes(scanDiff);
                }
                source = new MemoryImageSource(width, height, (ColorModel)model, pixels, 0, width);
                break;
            }
            case 16: {
                this.skipColorTable(color_num);
                if (bInfoCompression != 0) {
                    Logger.warning("can not read bmp compression: " + bInfoCompression);
                    return null;
                }
                int scanDiff = (2 - width % 2) % 2 * 2;
                int[] pixels = new int[width * height];
                for (int i = height - 1; i >= 0; --i) {
                    for (int k = 0; k < width; ++k) {
                        pixels[i * width + k] = this.readRGB16();
                    }
                    this.skipBytes(scanDiff);
                }
                source = new MemoryImageSource(width, height, pixels, 0, width, null);
                break;
            }
            case 24: {
                int scanDiff = width % 4;
                int[] pixels = new int[width * height];
                for (int i = height - 1; i >= 0; --i) {
                    for (int k = 0; k < width; ++k) {
                        pixels[i * width + k] = this.readRGB24();
                    }
                    this.skipBytes(scanDiff);
                }
                source = new MemoryImageSource(width, height, pixels, 0, width, null);
                break;
            }
            case 32: {
                int[] pixels = new int[width * height];
                for (int i = height - 1; i >= 0; --i) {
                    for (int k = 0; k < width; ++k) {
                        pixels[i * width + k] = this.readRGB24();
                        this.skipBytes(1);
                    }
                }
                source = new MemoryImageSource(width, height, pixels, 0, width, null);
                break;
            }
            default: {
                String errorMessage = "Invalid BMP Bpp=" + bitPerPixel;
                Logger.info(errorMessage);
                return null;
            }
        }
        Image image = Toolkit.getDefaultToolkit().createImage(source);
        return image;
    }

    private IndexColorModel getColorModel(int bpp, int size) throws IOException {
        if (size == 0) {
            size = 1 << bpp;
        }
        byte[] cmap = new byte[4 * size];
        for (int i = 0; i < size; ++i) {
            cmap[4 * i + 2] = this.readByte();
            cmap[4 * i + 1] = this.readByte();
            cmap[4 * i] = this.readByte();
            cmap[4 * i + 3] = -1;
            this.skipBytes(1);
        }
        IndexColorModel model = new IndexColorModel(bpp, size, cmap, 0, true);
        return model;
    }

    private void skipColorTable(int size) throws IOException {
        this.skipBytes(size * 4);
    }
}

