/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;

public class FloatValue
extends HtmlAttribute {
    public static final byte NONE = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;
    public static final byte LEFT = 3;
    private byte value;
    public static final FloatValue PARSER = new FloatValue();

    public FloatValue() {
    }

    public FloatValue(byte floating) {
        this.value = floating;
        switch (this.value) {
            case 3: {
                this.setString("left");
                break;
            }
            case 1: {
                this.setString("center");
                break;
            }
            case 2: {
                this.setString("right");
                break;
            }
            default: {
                this.setString("none");
            }
        }
    }

    public byte getFloat() {
        return this.value;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String valueStr) {
        return this.parseCssValue(valueStr, false);
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        int val;
        if ("inherit".equals(valueStr = valueStr.toLowerCase())) {
            return AttributeValue.INHERIT;
        }
        if ("left".equals(valueStr)) {
            val = 3;
        } else if ("right".equals(valueStr)) {
            val = 2;
        } else if ("none".equals(valueStr)) {
            val = 0;
        } else if ("center".equals(valueStr)) {
            val = 1;
        } else {
            return null;
        }
        FloatValue floatValue = new FloatValue();
        floatValue.value = (byte)val;
        floatValue.setString(valueStr);
        floatValue.setImportant(important);
        return floatValue;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FloatValue)) {
            return false;
        }
        FloatValue other = (FloatValue)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.value == other.value;
    }
}

