/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.css.CSS;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.BorderWidthValue;
import com.inet.html.parser.converter.ColorValue;
import javax.swing.text.MutableAttributeSet;

class BorderSide
extends AttributeValue {
    static final BorderSide PARSER = new BorderSide();

    BorderSide() {
    }

    @Override
    protected boolean parseCssValue(MutableAttributeSet attrs, CSS.Attribute attr, String strValues, boolean important) {
        attrs.removeAttribute((Object)this.getStyleAttr(attr));
        attrs.removeAttribute((Object)this.getColorAttr(attr));
        attrs.removeAttribute((Object)this.getWidthAttr(attr));
        String[] values = AttributeValue.split(strValues);
        boolean valid = false;
        for (String value : values) {
            valid |= BorderStyleValue.PARSER.parseCssValue(attrs, this.getStyleAttr(attr), value, important);
            valid |= ColorValue.PARSER.parseCssValue(attrs, this.getColorAttr(attr), value, important);
            valid |= BorderWidthValue.PARSER.parseCssValue(attrs, this.getWidthAttr(attr), value, important);
        }
        return valid;
    }

    private CSS.Attribute getStyleAttr(CSS.Attribute attr) {
        if (attr == CSS.Attribute.BORDER_TOP) {
            return CSS.Attribute.BORDER_TOP_STYLE;
        }
        if (attr == CSS.Attribute.BORDER_RIGHT) {
            return CSS.Attribute.BORDER_RIGHT_STYLE;
        }
        if (attr == CSS.Attribute.BORDER_BOTTOM) {
            return CSS.Attribute.BORDER_BOTTOM_STYLE;
        }
        if (attr == CSS.Attribute.BORDER_LEFT) {
            return CSS.Attribute.BORDER_LEFT_STYLE;
        }
        throw new IllegalArgumentException(String.valueOf((Object)attr));
    }

    private CSS.Attribute getColorAttr(CSS.Attribute attr) {
        if (attr == CSS.Attribute.BORDER_TOP) {
            return CSS.Attribute.BORDER_TOP_COLOR;
        }
        if (attr == CSS.Attribute.BORDER_RIGHT) {
            return CSS.Attribute.BORDER_RIGHT_COLOR;
        }
        if (attr == CSS.Attribute.BORDER_BOTTOM) {
            return CSS.Attribute.BORDER_BOTTOM_COLOR;
        }
        if (attr == CSS.Attribute.BORDER_LEFT) {
            return CSS.Attribute.BORDER_LEFT_COLOR;
        }
        throw new IllegalArgumentException(String.valueOf((Object)attr));
    }

    private CSS.Attribute getWidthAttr(CSS.Attribute attr) {
        if (attr == CSS.Attribute.BORDER_TOP) {
            return CSS.Attribute.BORDER_TOP_WIDTH;
        }
        if (attr == CSS.Attribute.BORDER_RIGHT) {
            return CSS.Attribute.BORDER_RIGHT_WIDTH;
        }
        if (attr == CSS.Attribute.BORDER_BOTTOM) {
            return CSS.Attribute.BORDER_BOTTOM_WIDTH;
        }
        if (attr == CSS.Attribute.BORDER_LEFT) {
            return CSS.Attribute.BORDER_LEFT_WIDTH;
        }
        throw new IllegalArgumentException(String.valueOf((Object)attr));
    }
}

