/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.parser.converter.Background;
import com.inet.html.parser.converter.BackgroundPosition;
import com.inet.html.parser.converter.BackgroundRepeat;
import com.inet.html.parser.converter.BackgroundSize;
import com.inet.html.parser.converter.Border;
import com.inet.html.parser.converter.BorderCollapseValue;
import com.inet.html.parser.converter.BorderColor;
import com.inet.html.parser.converter.BorderSide;
import com.inet.html.parser.converter.BorderStyle;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.BorderWidth;
import com.inet.html.parser.converter.BorderWidthValue;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.parser.converter.ClearValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.Direction;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.EmptyValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.FontValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.parser.converter.ListStyle;
import com.inet.html.parser.converter.ListStyleType;
import com.inet.html.parser.converter.Margin;
import com.inet.html.parser.converter.MultiIntegerValue;
import com.inet.html.parser.converter.Overflow;
import com.inet.html.parser.converter.OverflowWrap;
import com.inet.html.parser.converter.Padding;
import com.inet.html.parser.converter.Position;
import com.inet.html.parser.converter.StringValue;
import com.inet.html.parser.converter.TextAlign;
import com.inet.html.parser.converter.TextDecoration;
import com.inet.html.parser.converter.TransformValue;
import com.inet.html.parser.converter.UnicodeBidi;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.parser.converter.VerticalAlign;
import com.inet.html.parser.converter.VisibilityValue;
import com.inet.html.parser.converter.WhiteSpace;
import com.inet.html.parser.converter.ZIndexValue;
import com.inet.html.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;

public abstract class AttributeValue {
    public static final AttributeValue INHERIT = new AttributeValue(){

        @Override
        protected boolean parseCssValue(MutableAttributeSet attrs, CSS.Attribute attr, String value, boolean important) {
            return true;
        }
    };
    private static final Pattern WHITE_SPACES;
    private static final Hashtable<CSS.Attribute, AttributeValue> CONVERTERS;
    private static final Hashtable<HTML.Tag, Hashtable<HTML.Attribute, HtmlToCSSResolution>> HTML_ATTRS_CONVERTER;
    private static final Hashtable<HTML.Attribute, HtmlToCSSResolution> HTML_GENERIC_CONVERTER;
    private String stringValue;
    private boolean isImportant;

    private static void addHtmlAttrConverter(HTML.Tag tag, HTML.Attribute attr, HtmlAttribute converter, TemporaryStyle.Attribute ... cssAttributes) {
        Hashtable<HTML.Attribute, HtmlToCSSResolution> attrsConverters = HTML_ATTRS_CONVERTER.get((Object)tag);
        if (attrsConverters == null) {
            attrsConverters = new Hashtable();
            HTML_ATTRS_CONVERTER.put(tag, attrsConverters);
        }
        ArrayList list = null;
        if (cssAttributes != null && cssAttributes.length > 0 && (cssAttributes.length != 1 || cssAttributes[0] != null)) {
            list = new ArrayList(cssAttributes.length);
            Collections.addAll(list, cssAttributes);
        }
        attrsConverters.put(attr, new HtmlToCSSResolution(converter, list));
    }

    private static void addHtmlGenericConverter(HTML.Attribute attr, HtmlAttribute converter, TemporaryStyle.Attribute ... cssAttributes) {
        ArrayList list = null;
        if (cssAttributes != null && cssAttributes.length > 0 && (cssAttributes.length != 1 || cssAttributes[0] != null)) {
            list = new ArrayList(cssAttributes.length);
            Collections.addAll(list, cssAttributes);
        }
        HTML_GENERIC_CONVERTER.put(attr, new HtmlToCSSResolution(converter, list));
    }

    public static final AttributeValue convertValue(InetHtmlDocument doc, HTML.Tag tag, HTML.Attribute attr, String strValue) {
        HtmlAttribute converter;
        HtmlToCSSResolution htmlToCSSResolution;
        boolean isEmpty = false;
        if (attr == null) {
            return null;
        }
        if (strValue == null || strValue.length() == 0) {
            isEmpty = true;
        }
        if ((htmlToCSSResolution = HTML_GENERIC_CONVERTER.get((Object)attr)) == null && tag != null) {
            Hashtable<HTML.Attribute, HtmlToCSSResolution> attrsConverters = HTML_ATTRS_CONVERTER.get((Object)tag);
            if (attrsConverters == null) {
                if (Logger.doesLog(2)) {
                    Logger.warning("TODO HTML Attr Converter for " + (Object)((Object)tag) + " " + (Object)((Object)attr));
                }
                return null;
            }
            htmlToCSSResolution = attrsConverters.get((Object)attr);
        }
        if (htmlToCSSResolution != null && (converter = htmlToCSSResolution.attribute) != null) {
            if (!isEmpty || converter.allowesEmptyValue()) {
                return converter.parseHtmlValue(doc, strValue);
            }
            return null;
        }
        if (Logger.doesLog(2)) {
            Logger.warning("TODO HTML Attr Converter for " + (Object)((Object)tag) + " " + (Object)((Object)attr));
        }
        return null;
    }

    public static final void addCssAtrributes(MutableAttributeSet attrs, CSS.Attribute attr, String strValue, boolean important) {
        AttributeValue converter = AttributeValue.getConverter((Object)attr, strValue);
        if (converter == null) {
            attrs.addAttribute((Object)attr, new StringValue(strValue));
            return;
        }
        converter.parseCssValue(attrs, attr, strValue, important);
    }

    public static final AttributeValue getConverter(Object attr, String value) {
        if (attr == null || value == null || value.length() == 0) {
            return null;
        }
        AttributeValue converter = CONVERTERS.get(attr);
        if (converter == null) {
            if (Logger.doesLog(2)) {
                Logger.warning("TODO CSS ValueConverter for " + attr);
            }
            return null;
        }
        return converter;
    }

    public static Hashtable<HTML.Attribute, HtmlToCSSResolution> getConverterTable(Object tag) {
        if (HTML_ATTRS_CONVERTER != null && tag != null) {
            return HTML_ATTRS_CONVERTER.get(tag);
        }
        return null;
    }

    protected abstract boolean parseCssValue(MutableAttributeSet var1, CSS.Attribute var2, String var3, boolean var4);

    protected final void setString(String value) {
        this.stringValue = value;
    }

    public String toString() {
        return String.valueOf(this.stringValue);
    }

    public boolean isImportant() {
        return this.isImportant;
    }

    protected void setImportant(boolean important) {
        this.isImportant = important;
    }

    public static String[] split(String raw) {
        int end;
        if (raw == null) {
            return new String[0];
        }
        if (raw.indexOf(32) < 0 && raw.indexOf(9) < 0) {
            return new String[]{raw};
        }
        if (raw.indexOf(40) < 0) {
            return WHITE_SPACES.split(raw);
        }
        ArrayList<String> parts = new ArrayList<String>();
        raw = raw.replaceAll("\\s+", " ");
        int start = 0;
        int bCount = 0;
        block5: for (end = start; end < raw.length(); ++end) {
            char c = raw.charAt(end);
            switch (c) {
                case '(': {
                    ++bCount;
                    continue block5;
                }
                case ')': {
                    bCount = Math.max(0, bCount - 1);
                    continue block5;
                }
                case ' ': {
                    if (bCount != 0 || end <= start) continue block5;
                    parts.add(raw.substring(start, end).trim());
                    start = end + 1;
                }
            }
        }
        if (end > start) {
            parts.add(raw.substring(start, end).trim());
            start = end + 1;
        }
        return parts.toArray(new String[parts.size()]);
    }

    public boolean isWriteValue() {
        return true;
    }

    static {
        INHERIT.setString("inherit");
        WHITE_SPACES = Pattern.compile("\\s+");
        CONVERTERS = new Hashtable(47);
        HTML_ATTRS_CONVERTER = new Hashtable(47);
        HTML_GENERIC_CONVERTER = new Hashtable(2);
        AttributeValue.addHtmlGenericConverter(HTML.Attribute.CLASS, ClassValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlGenericConverter(HTML.Attribute.DIR, Direction.PARSER, TemporaryStyle.Attribute.DIRECTION);
        AttributeValue.addHtmlGenericConverter(HTML.Attribute.UNICODE_BIDI, UnicodeBidi.PARSER, TemporaryStyle.Attribute.UNICODEBIDI);
        AttributeValue.addHtmlGenericConverter(HTML.Attribute.NOWRAP, WhiteSpace.PARSER, TemporaryStyle.Attribute.WHITE_SPACE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.P, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.H1, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.H2, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.H3, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.H4, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.H5, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.H6, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.HR, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TR, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TBODY, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.THEAD, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TFOOT, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COL, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COLGROUP, HTML.Attribute.ALIGN, TextAlign.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.ALIGN, FloatValue.PARSER, TemporaryStyle.Attribute.TEXT_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.ALIGN, FloatValue.PARSER, TemporaryStyle.Attribute.FLOAT);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.A, HTML.Attribute.HREF, UrlValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.BASE, HTML.Attribute.HREF, UrlValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.BASEFONT, HTML.Attribute.COLOR, ColorValue.PARSER, TemporaryStyle.Attribute.COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.BASEFONT, HTML.Attribute.SIZE, FontValue.FONT_SIZE, TemporaryStyle.Attribute.FONT_SIZE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.BASEFONT, HTML.Attribute.FACE, FontValue.FONT_FAMILY, TemporaryStyle.Attribute.FONT_FAMILY);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.BODY, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.BODY, HTML.Attribute.BACKGROUND, UriValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_IMAGE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.BR, HTML.Attribute.CLEAR, ClearValue.PARSER, TemporaryStyle.Attribute.CLEAR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.BORDER, LengthUnit.PARSER, TemporaryStyle.Attribute.BORDER_BOTTOM_WIDTH, TemporaryStyle.Attribute.BORDER_LEFT_WIDTH, TemporaryStyle.Attribute.BORDER_TOP_WIDTH, TemporaryStyle.Attribute.BORDER_RIGHT_WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.COLSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.CELLPADDING, MultiIntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.CELLSPACING, MultiIntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.HEIGHT, LengthUnit.PARSER, TemporaryStyle.Attribute.HEIGHT);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.NOWRAP, EmptyValue.PARSER, TemporaryStyle.Attribute.WHITE_SPACE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.ROWSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.SPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.VALIGN, VerticalAlign.PARSER, TemporaryStyle.Attribute.VERTICAL_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.DIV, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.OBJECT, HTML.Attribute.BORDER, LengthUnit.PARSER, TemporaryStyle.Attribute.BORDER_BOTTOM_WIDTH, TemporaryStyle.Attribute.BORDER_LEFT_WIDTH, TemporaryStyle.Attribute.BORDER_TOP_WIDTH, TemporaryStyle.Attribute.BORDER_RIGHT_WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.FONT, HTML.Attribute.FACE, FontValue.FONT_FAMILY, TemporaryStyle.Attribute.FONT_FAMILY);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.FONT, HTML.Attribute.COLOR, ColorValue.PARSER, TemporaryStyle.Attribute.COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.FONT, HTML.Attribute.SIZE, FontValue.FONT_SIZE, TemporaryStyle.Attribute.FONT_SIZE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.FORM, HTML.Attribute.ACTION, StringValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.FORM, HTML.Attribute.METHOD, StringValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.SELECT, HTML.Attribute.NAME, StringValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.SELECT, HTML.Attribute.SIZE, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.OPTION, HTML.Attribute.SELECTED, EmptyValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.OPTION, HTML.Attribute.VALUE, StringValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.OL, HTML.Attribute.TYPE, ListStyleType.PARSER, TemporaryStyle.Attribute.LIST_STYLE_TYPE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.OL, HTML.Attribute.START, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.UL, HTML.Attribute.TYPE, ListStyleType.PARSER, TemporaryStyle.Attribute.LIST_STYLE_TYPE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.LINK, HTML.Attribute.TYPE, StringValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.LI, HTML.Attribute.TYPE, ListStyleType.PARSER, TemporaryStyle.Attribute.LIST_STYLE_TYPE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.LI, HTML.Attribute.VALUE, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.ALT, StringValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.BORDER, LengthUnit.PARSER, TemporaryStyle.Attribute.BORDER_BOTTOM_WIDTH, TemporaryStyle.Attribute.BORDER_LEFT_WIDTH, TemporaryStyle.Attribute.BORDER_TOP_WIDTH, TemporaryStyle.Attribute.BORDER_RIGHT_WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.HEIGHT, LengthUnit.PARSER, TemporaryStyle.Attribute.HEIGHT);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.HSPACE, IntegerValue.PARSER, TemporaryStyle.Attribute.MARGIN_LEFT, TemporaryStyle.Attribute.MARGIN_RIGHT);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.SRC, UrlValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.VSPACE, IntegerValue.PARSER, TemporaryStyle.Attribute.MARGIN_BOTTOM, TemporaryStyle.Attribute.MARGIN_TOP);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.IMG, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.INPUT, HTML.Attribute.SRC, UrlValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.HR, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.HR, HTML.Attribute.NOSHADE, EmptyValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.HR, HTML.Attribute.SIZE, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.HR, HTML.Attribute.COLOR, ColorValue.PARSER, TemporaryStyle.Attribute.COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.PRE, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.PRE, HTML.Attribute.WRAP, WhiteSpace.PARSER, TemporaryStyle.Attribute.WHITE_SPACE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.BACKGROUND, UriValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_IMAGE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.BORDER, IntegerValue.PARSER, TemporaryStyle.Attribute.BORDER_BOTTOM_WIDTH, TemporaryStyle.Attribute.BORDER_LEFT_WIDTH, TemporaryStyle.Attribute.BORDER_TOP_WIDTH, TemporaryStyle.Attribute.BORDER_RIGHT_WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.CELLPADDING, MultiIntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.CELLSPACING, MultiIntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TABLE, HTML.Attribute.HEIGHT, LengthUnit.PARSER, TemporaryStyle.Attribute.HEIGHT);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COLGROUP, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COLGROUP, HTML.Attribute.COLSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COLGROUP, HTML.Attribute.SPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COLGROUP, HTML.Attribute.VALIGN, VerticalAlign.PARSER, TemporaryStyle.Attribute.VERTICAL_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COLGROUP, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COL, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COL, HTML.Attribute.COLSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COL, HTML.Attribute.SPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COL, HTML.Attribute.VALIGN, VerticalAlign.PARSER, TemporaryStyle.Attribute.VERTICAL_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.COL, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TR, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TR, HTML.Attribute.VALIGN, VerticalAlign.PARSER, TemporaryStyle.Attribute.VERTICAL_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TR, HTML.Attribute.NOWRAP, WhiteSpace.PARSER, TemporaryStyle.Attribute.WHITE_SPACE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.COLSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.HEIGHT, LengthUnit.PARSER, TemporaryStyle.Attribute.HEIGHT);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.NOWRAP, WhiteSpace.PARSER, TemporaryStyle.Attribute.WHITE_SPACE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.ROWSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.VALIGN, VerticalAlign.PARSER, TemporaryStyle.Attribute.VERTICAL_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TH, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.BGCOLOR, ColorValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_COLOR);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.CLASS, ClassValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.COLSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.HEIGHT, LengthUnit.PARSER, TemporaryStyle.Attribute.HEIGHT);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.NOWRAP, WhiteSpace.PARSER, TemporaryStyle.Attribute.WHITE_SPACE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.ROWSPAN, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.VALIGN, VerticalAlign.PARSER, TemporaryStyle.Attribute.VERTICAL_ALIGN);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.WIDTH, LengthUnit.PARSER, TemporaryStyle.Attribute.WIDTH);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TD, HTML.Attribute.BACKGROUND, UriValue.PARSER, TemporaryStyle.Attribute.BACKGROUND_IMAGE);
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TEXTAREA, HTML.Attribute.COLS, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TEXTAREA, HTML.Attribute.ROWS, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        AttributeValue.addHtmlAttrConverter(HTML.Tag.TEXTAREA, HTML.Attribute.TABINDEX, IntegerValue.PARSER, new TemporaryStyle.Attribute[]{null});
        CONVERTERS.put(CSS.Attribute.COLOR, ColorValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BACKGROUND, Background.PARSER);
        CONVERTERS.put(CSS.Attribute.BACKGROUND_COLOR, ColorValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BACKGROUND_IMAGE, UriValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BACKGROUND_REPEAT, BackgroundRepeat.PARSER);
        CONVERTERS.put(CSS.Attribute.BACKGROUND_POSITION, BackgroundPosition.PARSER);
        CONVERTERS.put(CSS.Attribute.BACKGROUND_SIZE, BackgroundSize.PARSER);
        CONVERTERS.put(CSS.Attribute.FONT_SIZE, FontValue.FONT_SIZE);
        CONVERTERS.put(CSS.Attribute.LINE_HEIGHT, FontValue.LINE_HEIGHT);
        CONVERTERS.put(CSS.Attribute.FONT_STYLE, FontValue.FONT_STYLE);
        CONVERTERS.put(CSS.Attribute.FONT_WEIGHT, FontValue.FONT_WEIGHT);
        CONVERTERS.put(CSS.Attribute.FONT_VARIANT, FontValue.FONT_VARIANT);
        CONVERTERS.put(CSS.Attribute.FONT_FAMILY, FontValue.FONT_FAMILY);
        CONVERTERS.put(CSS.Attribute.FONT, new FontValue());
        CONVERTERS.put(CSS.Attribute.WIDTH, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.HEIGHT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.MAX_HEIGHT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.MAX_WIDTH, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.MIN_HEIGHT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.MIN_WIDTH, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.LETTER_SPACING, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.TEXT_ALIGN, TextAlign.PARSER);
        CONVERTERS.put(CSS.Attribute.VERTICAL_ALIGN, VerticalAlign.PARSER);
        CONVERTERS.put(CSS.Attribute.TEXT_DECORATION, TextDecoration.PARSER);
        CONVERTERS.put(CSS.Attribute.DISPLAY, DisplayValue.INLINE_VALUE);
        CONVERTERS.put(CSS.Attribute.VISIBILITY, VisibilityValue.PARSER);
        CONVERTERS.put(CSS.Attribute.FLOAT, new FloatValue());
        CONVERTERS.put(CSS.Attribute.CLEAR, new ClearValue());
        CONVERTERS.put(CSS.Attribute.BORDER_COLLAPSE, new BorderCollapseValue());
        CONVERTERS.put(CSS.Attribute.MARGIN, new Margin());
        CONVERTERS.put(CSS.Attribute.MARGIN_TOP, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.MARGIN_RIGHT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.MARGIN_BOTTOM, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.MARGIN_LEFT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.TEXT_INDENT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.PADDING, new Padding());
        CONVERTERS.put(CSS.Attribute.PADDING_TOP, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.PADDING_RIGHT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.PADDING_BOTTOM, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.PADDING_LEFT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_WIDTH, new BorderWidth());
        CONVERTERS.put(CSS.Attribute.BORDER_TOP_WIDTH, BorderWidthValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_RIGHT_WIDTH, BorderWidthValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_BOTTOM_WIDTH, BorderWidthValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_LEFT_WIDTH, BorderWidthValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_COLOR, new BorderColor());
        CONVERTERS.put(CSS.Attribute.BORDER_TOP_COLOR, ColorValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_RIGHT_COLOR, ColorValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_BOTTOM_COLOR, ColorValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_LEFT_COLOR, ColorValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_STYLE, new BorderStyle());
        CONVERTERS.put(CSS.Attribute.BORDER_TOP_STYLE, BorderStyleValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_RIGHT_STYLE, BorderStyleValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_BOTTOM_STYLE, BorderStyleValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_LEFT_STYLE, BorderStyleValue.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER, new Border());
        CONVERTERS.put(CSS.Attribute.BORDER_TOP, BorderSide.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_RIGHT, BorderSide.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_BOTTOM, BorderSide.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_LEFT, BorderSide.PARSER);
        CONVERTERS.put(CSS.Attribute.BORDER_SPACING, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.LIST_STYLE_TYPE, ListStyleType.PARSER);
        CONVERTERS.put(CSS.Attribute.LIST_STYLE_POSITION, ListPositionValue.PARSER);
        CONVERTERS.put(CSS.Attribute.LIST_STYLE_IMAGE, UriValue.PARSER);
        CONVERTERS.put(CSS.Attribute.LIST_STYLE, ListStyle.PARSER);
        CONVERTERS.put(CSS.Attribute.UNICODEBIDI, UnicodeBidi.PARSER);
        CONVERTERS.put(CSS.Attribute.WHITE_SPACE, WhiteSpace.PARSER);
        CONVERTERS.put(CSS.Attribute.OVERFLOW_WRAP, OverflowWrap.PARSER);
        CONVERTERS.put(CSS.Attribute.OVERFLOW, Overflow.PARSER);
        CONVERTERS.put(CSS.Attribute.POSITION, Position.PARSER);
        CONVERTERS.put(CSS.Attribute.ZINDEX, ZIndexValue.PARSER);
        CONVERTERS.put(CSS.Attribute.LEFT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.RIGHT, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.TOP, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.BOTTOM, LengthUnit.PARSER);
        CONVERTERS.put(CSS.Attribute.DIRECTION, Direction.PARSER);
        CONVERTERS.put(CSS.Attribute.UNICODEBIDI, UnicodeBidi.PARSER);
        CONVERTERS.put(CSS.Attribute.TRANSFORM, TransformValue.PARSER);
        CONVERTERS.put(CSS.Attribute.TRANSFORM_ORIGIN, BackgroundPosition.PARSER);
    }

    public static class HtmlToCSSResolution {
        private HtmlAttribute attribute;
        private ArrayList<TemporaryStyle.Attribute> cssAttributes;

        public HtmlToCSSResolution(HtmlAttribute attribute, ArrayList<TemporaryStyle.Attribute> cssAttributes) {
            this.attribute = attribute;
            this.cssAttributes = cssAttributes == null ? new ArrayList(0) : cssAttributes;
        }

        public ArrayList<TemporaryStyle.Attribute> getCssAttributes() {
            return this.cssAttributes;
        }

        public HtmlAttribute getAttribute() {
            return this.attribute;
        }
    }
}

