/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.image;

import com.inet.html.image.AnimationObserver;
import com.inet.html.parser.URLResolver;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemoteImage {
    public static final int STATUS_NEW = 0;
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_FINISHED = 2;
    public static final int STATUS_INVALID = 3;
    public static final int DELAY_INFINITE = -1;
    private List<ImageStepInfo> images = new ArrayList<ImageStepInfo>(1);
    private URLResolver resolver;
    private int timeout = -4242;
    private int height = 0;
    private int width = 0;
    private Set<AnimationObserver> observers = new HashSet<AnimationObserver>();
    private int status = 0;
    private Thread animator;

    public RemoteImage(URL location, int timeout) {
        this(new URLResolver(location), timeout);
    }

    public RemoteImage(URLResolver resolver, int timeout) {
        this.resolver = resolver;
        this.timeout = timeout;
    }

    public RemoteImage(Image content) {
        if (content != null) {
            this.images.add(new ImageStepInfo(content, -1, null));
        }
        this.status = 2;
    }

    public int getConnectionTimeout() {
        return this.timeout;
    }

    @Deprecated
    public URL getLocation() {
        try {
            return this.resolver.getFullURL();
        }
        catch (MalformedURLException e) {
            return this.resolver.getBaseURL();
        }
    }

    public String getLocationString() {
        try {
            return this.resolver.getFullURL().toString();
        }
        catch (MalformedURLException e) {
            return this.resolver.getOriginalURI();
        }
    }

    public URLResolver getResolver() {
        return this.resolver;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(AnimationObserver observer) {
        if (observer == null) {
            return;
        }
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            RemoteImage remoteImage = this;
            synchronized (remoteImage) {
                if (!(this.status <= 1 || this.images.size() > 1 && observer.doAnimate())) {
                    int sendStat = this.status == 2 ? 32 : 64;
                    observer.imageUpdate(this.getContent(), sendStat, 0, 0, this.width, this.height);
                    return;
                }
            }
            if (!this.observers.contains(observer)) {
                this.observers.add(observer);
            }
            this.checkAnimator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(AnimationObserver observer) {
        if (observer == null) {
            return;
        }
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            this.observers.remove(observer);
        }
        this.checkAnimator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageUpdate(int infoflags, int x, int y, int width, int height) {
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            if (this.status == 0) {
                this.status = 1;
            }
            for (AnimationObserver obs : this.observers) {
                obs.imageUpdate(this.getContent(), infoflags, x, y, width, height);
            }
            if ((infoflags & 0x20) > 0 || (infoflags & 0x40) > 0 || (infoflags & 0x80) > 0) {
                this.status = (infoflags & 0x20) > 0 ? 2 : 3;
                this.observers.clear();
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(Image content) {
        RemoteImage remoteImage = this;
        synchronized (remoteImage) {
            this.images.clear();
            if (content != null) {
                this.images.add(new ImageStepInfo(content, -1, null));
                this.width = content.getWidth(null);
                this.height = content.getHeight(null);
                this.status = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getContent() {
        RemoteImage remoteImage = this;
        synchronized (remoteImage) {
            if (this.images.size() > 0) {
                return this.images.get(0).content;
            }
        }
        return null;
    }

    public String toString() {
        String status;
        switch (this.status) {
            case 0: {
                status = "pending";
                break;
            }
            case 1: {
                status = "loading";
                break;
            }
            case 2: {
                status = "loaded";
                break;
            }
            default: {
                status = "error";
            }
        }
        return "RemoteImage(" + status + "): " + this.resolver.getOriginalURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(Image content, int delay, Rectangle bounds) {
        RemoteImage remoteImage = this;
        synchronized (remoteImage) {
            this.images.add(new ImageStepInfo(content, delay, bounds));
            if (this.images.size() == 1) {
                this.width = content.getWidth(null);
                this.height = content.getHeight(null);
            }
            this.status = 2;
        }
        this.checkAnimator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countAnimatedObserver() {
        int animated = 0;
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            for (AnimationObserver obs : this.observers) {
                if (!obs.doAnimate()) continue;
                ++animated;
            }
        }
        return animated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAnimator() {
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            RemoteImage remoteImage = this;
            synchronized (remoteImage) {
                if (this.countAnimatedObserver() > 0) {
                    if (this.images.size() > 1) {
                        if (this.animator == null) {
                            this.animator = new Thread(new Animator());
                            try {
                                this.animator.setName("Image Animator");
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                            this.animator.start();
                        }
                    } else if (this.images.size() == 1) {
                        ImageStepInfo info = this.images.get(0);
                        if (this.animator == null) {
                            for (AnimationObserver obs : this.observers) {
                                obs.imageUpdate(info.content, 16, 0, 0, this.width, this.height);
                            }
                        }
                    } else if (this.animator != null) {
                        this.animator.interrupt();
                    }
                } else {
                    if (this.animator != null) {
                        this.animator.interrupt();
                    }
                    if (this.observers.size() > 0 && this.images.size() == 1) {
                        ImageStepInfo info = this.images.get(0);
                        for (AnimationObserver obs : this.observers) {
                            obs.imageUpdate(info.content, 32, 0, 0, this.width, this.height);
                        }
                    }
                }
            }
        }
    }

    private static class ImageStepInfo {
        private Image content;
        private int delay;
        private final Rectangle bounds;

        public ImageStepInfo(Image content, int delay, Rectangle bounds) {
            this.content = content;
            this.delay = delay;
            this.bounds = bounds;
        }
    }

    private class Animator
    implements Runnable {
        private Animator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int pos = 0;
            while (true) {
                ImageStepInfo info;
                Object object = RemoteImage.this;
                synchronized (object) {
                    int size = RemoteImage.this.images.size();
                    if (size == 0) {
                        RemoteImage.this.animator = null;
                        return;
                    }
                    if (pos >= size) {
                        pos = 0;
                    }
                    info = (ImageStepInfo)RemoteImage.this.images.get(pos);
                    ++pos;
                }
                object = RemoteImage.this.observers;
                synchronized (object) {
                    if (RemoteImage.this.observers.size() == 0) {
                        RemoteImage.this.animator = null;
                        return;
                    }
                    for (AnimationObserver obs : RemoteImage.this.observers) {
                        if (info.bounds == null) {
                            obs.imageUpdate(info.content, 16, 0, 0, RemoteImage.this.width, RemoteImage.this.height);
                            continue;
                        }
                        obs.imageUpdate(info.content, 16, ((ImageStepInfo)info).bounds.x, ((ImageStepInfo)info).bounds.y, ((ImageStepInfo)info).bounds.width, ((ImageStepInfo)info).bounds.height);
                    }
                }
                try {
                    Thread.sleep(info.delay * 10);
                }
                catch (InterruptedException e) {
                    RemoteImage.this.animator = null;
                    return;
                }
            }
        }
    }
}

