/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.css.CSSChangeListener;
import com.inet.html.css.HTML;
import com.inet.html.css.Selector;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.finder.GenericFinder;
import com.inet.html.parser.CssParser;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.utils.Logger;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class StyleResolver
implements CSSChangeListener {
    private static final TemporaryStyle.Attribute[] TEMP_ATTRIBUTE_VALUES;
    private static final TemporaryStyle.Attribute[] TEMP_ATTRIBUTE_VALUES_CONTENT;
    private static Styles defaultStyles;
    private static Styles userAgentStyles;
    private Styles styles = new Styles("INLINE");

    public static <T> T getAttributeValue(Element elem, AttributeFinder<T> finder) {
        return StyleResolver.getAttributeValue(elem, finder, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T getAttributeValue(Element elem, AttributeFinder<T> finder, boolean useCache) {
        CSS.Attribute cssAttribute = finder.getCSSAttribute();
        if (cssAttribute != null) {
            void var8_11;
            MutableAttributeSet set;
            AttributeSet attributes;
            TemporaryStyle.Attribute att = TemporaryStyle.getAttribute(cssAttribute);
            Object result = null;
            Element currentNode = elem;
            while (currentNode != null && att != null && useCache && (attributes = currentNode.getAttributes()).isDefined(InetHtmlDocument.FLAG_INIT)) {
                if (attributes.isDefined((Object)att)) {
                    Object object = currentNode.getAttributes().getAttribute((Object)att);
                    if (object == AttributeValue.INHERIT) {
                        currentNode = currentNode.getParentElement();
                        continue;
                    }
                    result = object;
                    break;
                }
                currentNode = currentNode.getParentElement();
            }
            if (result != null) {
                if (!(result instanceof AttributeValue)) return null;
                return (T)result;
            }
            CssDocument doc = (CssDocument)elem.getDocument();
            T t = doc.getStyleResolver().getAttributeValueInternal(elem, finder);
            if (t != null || (set = defaultStyles.getDefaultSet(elem.getAttributes().getAttribute(StyleConstants.NameAttribute))) == null || att == null) return var8_11;
            Object object = set.getAttribute((Object)att);
            return var8_11;
        }
        if (!elem.getAttributes().isDefined((Object)finder.getHTMLAttribute())) return null;
        return (T)finder.findHtmlAttribute(elem);
    }

    public static boolean matchesAttributes(Element element, AttributeSet requirements) {
        if (requirements == null) {
            return true;
        }
        if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT && !requirements.isDefined(StyleConstants.NameAttribute)) {
            element = element.getParentElement();
        }
        Enumeration<?> names = requirements.getAttributeNames();
        while (names.hasMoreElements()) {
            Object currentValue;
            Object elemValue;
            Object elemValue2;
            AttributeFinder<AttributeValue> finder;
            Object key = names.nextElement();
            Object value = requirements.getAttribute(key);
            if (key == CSS.Attribute.FONT_SIZE) {
                finder = GenericFinder.getFinder((CSS.Attribute)((Object)key));
                elemValue2 = finder.findStyleAttribute(element);
                if (value instanceof FontSize && !(elemValue2 instanceof FontSize)) {
                    value = requirements.getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
                }
                if (value != null && value.equals(elemValue2)) continue;
                return false;
            }
            if (key instanceof HTML.Attribute) {
                if (key == HTML.Attribute.STYLE) continue;
                if (!element.getAttributes().isDefined(key)) {
                    return false;
                }
                elemValue = element.getAttributes().getAttribute(key);
                if (value.equals(elemValue)) continue;
                return false;
            }
            if (!(key instanceof CSS.Attribute && !(key instanceof TemporaryStyle) ? !value.equals(elemValue2 = StyleResolver.getAttributeValue(element, finder = GenericFinder.getFinder((CSS.Attribute)((Object)key)))) : (key == StyleConstants.NameAttribute ? value != (elemValue = element.getAttributes().getAttribute(StyleConstants.NameAttribute)) : ((currentValue = element.getAttributes().getAttribute(key)) == null ? value != null : !currentValue.equals(value))))) continue;
            return false;
        }
        return true;
    }

    protected <T> T getAttributeValueInternal(Element element, AttributeFinder<T> finder) {
        if (element == null) {
            return null;
        }
        CssDocument doc = (CssDocument)element.getDocument();
        boolean allowInherit = finder.isInherited();
        if (doc.readStylesOfVirtualTags()) {
            Object tag;
            while (element != null && allowInherit && ((tag = element.getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.CONTENT || tag == HTML.Tag.IMPLIED)) {
                element = element.getParentElement();
            }
        }
        boolean runOnce = true;
        for (Element e = element; e != null && allowInherit || runOnce; e = e.getParentElement()) {
            runOnce = false;
            Object obj = finder.findStyleAttribute(e);
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) continue;
                if (obj instanceof AttributeValue && ((AttributeValue)obj).isImportant()) {
                    return (T)obj;
                }
            }
            if (this.styles != null && (obj = finder.findCssAttribute(this.styles, e, true)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            if (userAgentStyles != null && (obj = finder.findCssAttribute(userAgentStyles, e, true)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            obj = finder.findCssAttribute(defaultStyles, e, true);
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) {
                    return null;
                }
                return (T)obj;
            }
            obj = finder.findStyleAttribute(e);
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            if (this.styles != null && (obj = finder.findCssAttribute(this.styles, e, false)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            obj = finder.findHtmlAttribute(e);
            if (obj != null) {
                return (T)obj;
            }
            if (userAgentStyles != null && (obj = finder.findCssAttribute(userAgentStyles, e, false)) != null) {
                if (obj == AttributeValue.INHERIT) continue;
                return (T)obj;
            }
            if (!allowInherit) break;
        }
        runOnce = true;
        TemporaryStyle.Attribute att = finder.getCSSAttribute() != null ? TemporaryStyle.getAttribute(finder.getCSSAttribute()) : null;
        for (Element e = element; e != null && allowInherit || runOnce; e = e.getParentElement()) {
            MutableAttributeSet set;
            runOnce = false;
            Object obj = finder.findCssAttribute(defaultStyles, e, false);
            if (obj == null && att != null && (set = defaultStyles.getDefaultSet(e.getAttributes().getAttribute(StyleConstants.NameAttribute))) != null) {
                obj = set.getAttribute((Object)att);
            }
            if (obj != null) {
                if (obj == AttributeValue.INHERIT) {
                    return null;
                }
                return (T)obj;
            }
            if (!allowInherit) break;
        }
        return null;
    }

    public <T> T getAttributeValueNonInherit(Element element, AttributeFinder<T> finder) {
        List<Selector> localMatches;
        HTML.Tag tag;
        Object name = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        HTML.Tag tag2 = tag = name instanceof HTML.Tag ? (HTML.Tag)((Object)name) : null;
        if (this.styles != null) {
            localMatches = this.styles.createMatchList(element, tag);
            if (localMatches != null && localMatches.size() == 0) {
                localMatches = null;
            }
        } else {
            localMatches = null;
        }
        List<Selector> userAgentMatches = userAgentStyles != null ? userAgentStyles.createMatchList(element, tag) : null;
        List<Selector> defaultMatches = defaultStyles.createMatchList(element, tag);
        return this.getAttributeValueNonInherit(element, finder, localMatches, userAgentMatches, defaultMatches);
    }

    private <T> T getAttributeValueNonInherit(Element element, AttributeFinder<T> finder, List<Selector> localMatches, List<Selector> userAgentMatches, List<Selector> defaultMatches) {
        Object styleAttribute = finder.findStyleAttribute(element);
        if (styleAttribute != null && styleAttribute instanceof AttributeValue && ((AttributeValue)styleAttribute).isImportant()) {
            return (T)(styleAttribute == AttributeValue.INHERIT ? null : styleAttribute);
        }
        Object obj = null;
        if (this.styles != null && localMatches != null && (obj = finder.findCssAttribute(this.styles, element, true, localMatches)) != null) {
            return (T)(obj == AttributeValue.INHERIT ? null : obj);
        }
        if (userAgentStyles != null && userAgentMatches != null && (obj = finder.findCssAttribute(userAgentStyles, element, true, userAgentMatches)) != null) {
            return (T)(obj == AttributeValue.INHERIT ? null : obj);
        }
        if (styleAttribute != null) {
            return (T)(styleAttribute == AttributeValue.INHERIT ? null : styleAttribute);
        }
        if (this.styles != null && localMatches != null && (obj = finder.findCssAttribute(this.styles, element, false, localMatches)) != null) {
            return (T)(obj == AttributeValue.INHERIT ? null : obj);
        }
        obj = finder.findHtmlAttribute(element);
        if (obj != null) {
            return (T)(obj == AttributeValue.INHERIT ? null : obj);
        }
        if (userAgentStyles != null && userAgentMatches != null && (obj = finder.findCssAttribute(userAgentStyles, element, false, userAgentMatches)) != null) {
            return (T)(obj == AttributeValue.INHERIT ? null : obj);
        }
        obj = finder.findCssAttribute(defaultStyles, element, false, defaultMatches);
        if (obj != null) {
            return (T)(obj == AttributeValue.INHERIT ? null : obj);
        }
        return null;
    }

    private boolean isDefaultInline(Object name) {
        return name == HTML.Tag.SPAN || name == HTML.Tag.SUP || name == HTML.Tag.SUB;
    }

    public void fillAttributesNonLocked(Element root, HashMap<TemporaryStyle.Attribute, Object> parentSet) {
        List<Selector> defaultMatches;
        List<Selector> userAgentMatches;
        FontSize size;
        List<Selector> localMatches;
        Object name;
        Element parent = root.getParentElement();
        if (parent != null && !parent.getAttributes().isDefined(InetHtmlDocument.FLAG_INIT)) {
            this.fillAttributesNonLocked(parent, null);
            return;
        }
        MutableAttributeSet attrs = (MutableAttributeSet)root.getAttributes();
        attrs.addAttribute(InetHtmlDocument.FLAG_INIT, Boolean.TRUE);
        int n = root.getElementCount();
        HashMap<TemporaryStyle.Attribute, Object> localSet = null;
        if (n > 1) {
            localSet = new HashMap<TemporaryStyle.Attribute, Object>(TEMP_ATTRIBUTE_VALUES.length);
        }
        HTML.Tag tag = (name = attrs.getAttribute(StyleConstants.NameAttribute)) instanceof HTML.Tag ? (HTML.Tag)((Object)name) : null;
        boolean isContent = name == HTML.Tag.CONTENT;
        boolean skipContent = true;
        MutableAttributeSet defaultSet = defaultStyles.getDefaultSet(name);
        attrs.addAttributes(defaultSet);
        if (isContent) {
            if (root.getParentElement() != null && this.isDefaultInline(root.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute))) {
                attrs.removeAttribute((Object)TemporaryStyle.Attribute.VERTICAL_ALIGN);
            }
            boolean bl = skipContent = !((CssDocument)root.getDocument()).readStylesOfVirtualTags();
            if (skipContent) {
                return;
            }
        }
        if (this.styles != null) {
            localMatches = this.styles.createMatchList(root, tag);
            if (localMatches != null && localMatches.size() == 0) {
                localMatches = null;
            }
        } else {
            localMatches = null;
        }
        if ((size = this.getAttributeValueNonInherit(root, AttributeFinder.FONT_SIZE, localMatches, userAgentMatches = userAgentStyles != null ? userAgentStyles.createMatchList(root, tag) : null, defaultMatches = defaultStyles.createMatchList(root, tag))) == null) {
            Object attribute = null;
            if (parentSet != null) {
                attribute = parentSet.get((Object)TemporaryStyle.Attribute.FONT_SIZE);
            }
            if (attribute == null && attrs.isDefined((Object)TemporaryStyle.Attribute.FONT_SIZE)) {
                attribute = attrs.getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
            }
            FontSize fontSize = size = attribute instanceof FontSize ? (FontSize)attribute : null;
        }
        if (size != null) {
            Float parentSize = null;
            if (parent != null) {
                parentSize = (Float)parent.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
            }
            Float fontSize = new Float(size.getValue((parentSize != null ? parentSize : new Float(16.0f)).floatValue()));
            FontSize inheritValue = StyleResolver.getAttributeValue(root, AttributeFinder.FONT_SIZE);
            if (inheritValue == null || !(inheritValue instanceof Float) || fontSize.floatValue() != ((Float)((Object)inheritValue)).floatValue()) {
                attrs.addAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE, fontSize);
            }
        }
        TemporaryStyle.Attribute[] fillList = isContent ? TEMP_ATTRIBUTE_VALUES_CONTENT : TEMP_ATTRIBUTE_VALUES;
        for (TemporaryStyle.Attribute cssAttribute : fillList) {
            AttributeFinder<? extends AttributeValue> finder = cssAttribute.getFinder();
            if (finder == null || finder.isInherited() && isContent && skipContent) continue;
            AttributeValue attributeValueInternal = this.getAttributeValueNonInherit(root, finder, localMatches, userAgentMatches, defaultMatches);
            if (attributeValueInternal == AttributeValue.INHERIT) {
                if (finder.isInherited()) continue;
                attrs.addAttribute((Object)cssAttribute, attributeValueInternal);
                continue;
            }
            Object inheritValue = null;
            if (parent != null) {
                if (parentSet != null) {
                    inheritValue = parentSet.get((Object)cssAttribute);
                }
                if (inheritValue == null) {
                    inheritValue = StyleResolver.getAttributeValue(parent, finder);
                }
            }
            if (attributeValueInternal == null) continue;
            if (!attributeValueInternal.equals(inheritValue)) {
                attrs.addAttribute((Object)cssAttribute, attributeValueInternal);
            } else if (inheritValue != null) {
                attrs.removeAttribute((Object)cssAttribute);
            }
            if (localSet == null) continue;
            localSet.put(cssAttribute, attributeValueInternal);
        }
        for (int i = 0; i < n; ++i) {
            this.fillAttributesNonLocked(root.getElement(i), localSet);
        }
    }

    public static void setAttribute(AttributeSet attrs, Object name, Object value) {
        if (value != null && attrs != null && name != null && attrs instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attrs).addAttribute(name, value);
        }
    }

    public Styles getStyles() {
        return this.styles;
    }

    public void setStyles(Styles styles) {
        this.styles = styles;
    }

    public void clearStyles() {
        if (this.styles != null) {
            this.styles.clear();
        }
    }

    public Enumeration<?> getStyleNames() {
        Vector<String> names = new Vector<String>();
        if (defaultStyles != null) {
            names.add(defaultStyles.getName());
        }
        if (userAgentStyles != null && userAgentStyles.getRuleCount() > 0) {
            names.add(defaultStyles.getName());
        }
        if (this.styles != null && this.styles.getRuleCount() > 0) {
            names.add(this.styles.getName());
        }
        return names.elements();
    }

    public Styles getStyleSheet(String nm) {
        if (nm != null) {
            if (defaultStyles != null && nm.equals(defaultStyles.getName())) {
                return defaultStyles;
            }
            if (userAgentStyles != null && nm.equals(userAgentStyles.getName())) {
                return userAgentStyles;
            }
            if (this.styles != null && nm.equals(this.styles.getName())) {
                return this.styles;
            }
        }
        return null;
    }

    @Override
    public void handleNewCSSEntry(Selector selector) {
    }

    public static boolean hasRelevantInlineStyles(Element element) {
        Element parent = element.getParentElement();
        if (parent == null) {
            return true;
        }
        AttributeSet atts = element.getAttributes();
        AttributeSet parentAtts = parent.getAttributes();
        Enumeration<?> names = atts.getAttributeNames();
        Object name = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (name != HTML.Tag.SPAN) {
            return true;
        }
        block3: while (names.hasMoreElements()) {
            name = names.nextElement();
            if (name instanceof TemporaryStyle.Attribute) {
                CSS.Attribute cssAtt = ((TemporaryStyle.Attribute)((Object)name)).getOrigAttrib();
                AttributeFinder<AttributeValue> finder = GenericFinder.getFinder(cssAtt);
                if (!finder.isInherited() && name != TemporaryStyle.Attribute.FONT_SIZE && name != TemporaryStyle.Attribute.BACKGROUND_COLOR) continue;
                Object value = atts.getAttribute(name);
                Object pvalue = parentAtts.getAttribute(name);
                if (value != null && pvalue == null) {
                    return true;
                }
                if (value == null || pvalue == null || value == pvalue || value.equals(pvalue) || name == TemporaryStyle.Attribute.BACKGROUND_COLOR && ((ColorValue)value).isTransparent()) continue;
                return true;
            }
            if (name instanceof CSS.Attribute || name instanceof StyleConstants) continue;
            if (name instanceof HTML.Attribute) {
                HTML.Attribute att = (HTML.Attribute)((Object)name);
                switch (att) {
                    case ALIGN: 
                    case BACKGROUND: 
                    case BGCOLOR: 
                    case BORDER: 
                    case CLASS: 
                    case COLOR: 
                    case STYLE: 
                    case NOWRAP: 
                    case WRAP: {
                        continue block3;
                    }
                }
                return true;
            }
            if (name instanceof String && "CR".equals(name)) continue;
            return true;
        }
        return false;
    }

    public MutableAttributeSet getDefaultSet(Object tag) {
        return defaultStyles.getDefaultSet(tag);
    }

    public void optimize() {
    }

    static {
        String msg;
        TEMP_ATTRIBUTE_VALUES = new TemporaryStyle.Attribute[TemporaryStyle.Attribute.values().length - 1];
        TEMP_ATTRIBUTE_VALUES_CONTENT = new TemporaryStyle.Attribute[]{TemporaryStyle.Attribute.DISPLAY, TemporaryStyle.Attribute.COLOR, TemporaryStyle.Attribute.WHITE_SPACE, TemporaryStyle.Attribute.VISIBILITY, TemporaryStyle.Attribute.FONT_FAMILY, TemporaryStyle.Attribute.FONT_WEIGHT, TemporaryStyle.Attribute.FLOAT, TemporaryStyle.Attribute.LINE_HEIGHT, TemporaryStyle.Attribute.TEXT_DECORATION};
        defaultStyles = new Styles("DEFAULT");
        int index = 0;
        TemporaryStyle.Attribute[] values = TemporaryStyle.Attribute.values();
        for (int i = 0; i < values.length; ++i) {
            TemporaryStyle.Attribute att = values[i];
            if (att == TemporaryStyle.Attribute.FONT_SIZE) continue;
            StyleResolver.TEMP_ATTRIBUTE_VALUES[index++] = att;
        }
        try {
            URL defaultResource = InetHtmlDocument.class.getResource("default.css");
            if (defaultResource == null) {
                throw new IllegalStateException("Cannot load default CSS for JWebEngine. The resource URL is null. Please check the classpath of the application for whether com.inet.html.default.css is included.");
            }
            new CssParser(defaultResource, defaultStyles, false, null).parse();
            if (Logger.doesLog(4)) {
                Logger.debug("Defaul CSS loaded");
            }
            defaultStyles.compile();
        }
        catch (Error err) {
            Logger.error(err);
            throw err;
        }
        catch (Throwable th) {
            msg = "The default style sheet cannot be loaded, " + th.getMessage();
            if (Logger.doesLog(1)) {
                Logger.error(msg);
            }
            Logger.error(th);
            throw new Error(msg, th);
        }
        try {
            URL url = InetHtmlDocument.class.getResource("userAgent.css");
            if (url != null) {
                userAgentStyles = new Styles("USERAGENT");
                new CssParser(url, userAgentStyles, false, null).parse();
                if (Logger.doesLog(4)) {
                    Logger.debug("User Agent CSS loaded");
                }
                if (userAgentStyles.getRuleCount() == 0) {
                    userAgentStyles = null;
                }
            }
        }
        catch (Throwable th) {
            msg = "The user agent sytle sheet cannot be loaded.";
            if (Logger.doesLog(1)) {
                Logger.error(msg);
            }
            Logger.error(th);
            throw new ExceptionInInitializerError(msg);
        }
    }
}

