/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.annotations.PublicApi;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@PublicApi
public class HTML {
    private static Map<String, Tag> TAG_MAPPING = null;

    public static Tag getTag(String name) {
        if (name == null) {
            return null;
        }
        String upperCase = name.toUpperCase(Locale.US);
        try {
            Tag tag = Tag.valueOf(upperCase);
            if (!tag.isSynthesized) {
                return tag;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (TAG_MAPPING != null) {
            return TAG_MAPPING.get(upperCase);
        }
        return null;
    }

    public static void addTagMapping(String tagName, Tag tag) {
        if (tagName == null || tag == null) {
            return;
        }
        if (TAG_MAPPING == null) {
            TAG_MAPPING = new HashMap<String, Tag>();
        }
        TAG_MAPPING.put(tagName.toUpperCase(Locale.US), tag);
    }

    public static Attribute getAttributeKey(String name) {
        String upperCase = name.toUpperCase(Locale.US).replace('-', '_');
        try {
            return Attribute.valueOf(upperCase);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    static {
        HTML.addTagMapping("v:imagedata", Tag.IMG);
    }

    public static enum Tag {
        A,
        ADDRESS,
        APPLET,
        AREA,
        B,
        BASE,
        BASEFONT,
        BIG,
        BLOCKQUOTE,
        BODY,
        BR,
        CAPTION,
        CENTER,
        CITE,
        CODE,
        COL,
        COLGROUP,
        DD,
        DFN,
        DIR,
        DIV,
        DL,
        DT,
        EM,
        FONT,
        FORM,
        FRAME,
        FRAMESET,
        H1,
        H2,
        H3,
        H4,
        H5,
        H6,
        HEAD,
        HR,
        HTML,
        I,
        IMG,
        INPUT,
        ISINDEX,
        KBD,
        LABEL,
        LI,
        LINK,
        MAP,
        MENU,
        META,
        NOBR,
        NOFRAMES,
        NOSCRIPT,
        OBJECT,
        OL,
        OPTION,
        P,
        PARAM,
        PRE,
        SAMP,
        SCRIPT,
        SELECT,
        SMALL,
        SPAN,
        STRIKE,
        S,
        STRONG,
        STYLE,
        SUB,
        SUP,
        TABLE,
        TBODY,
        TD,
        TEXTAREA,
        TFOOT,
        TH,
        THEAD,
        TITLE,
        TR,
        TT,
        U,
        UL,
        VAR,
        CONTENT(true),
        IMPLIED(true),
        CSSALL(true);

        private final String name;
        private final boolean isSynthesized;

        private Tag() {
            this(false);
        }

        private Tag(boolean isSynthesized) {
            this.isSynthesized = isSynthesized;
            this.name = this.name().toLowerCase();
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Attribute {
        SIZE,
        COLOR,
        CLEAR,
        BACKGROUND,
        BGCOLOR,
        TEXT,
        LINK,
        VLINK,
        ALINK,
        WIDTH,
        HEIGHT,
        ALIGN,
        NAME,
        HREF,
        REL,
        REV,
        TITLE,
        TARGET,
        SHAPE,
        COORDS,
        ISMAP,
        NOHREF,
        ALT,
        ID,
        SRC,
        HSPACE,
        VSPACE,
        USEMAP,
        LOWSRC,
        CODEBASE,
        CODE,
        ARCHIVE,
        VALUE,
        VALUETYPE,
        TYPE,
        CLASS,
        STYLE,
        LANG,
        FACE,
        DIR,
        DECLARE,
        CLASSID,
        DATA,
        CODETYPE,
        STANDBY,
        BORDER,
        SHAPES,
        NOSHADE,
        COMPACT,
        START,
        ACTION,
        METHOD,
        ENCTYPE,
        CHECKED,
        MAXLENGTH,
        MULTIPLE,
        SELECTED,
        ROWS,
        TABINDEX,
        COLS,
        DUMMY,
        CELLSPACING,
        CELLPADDING,
        VALIGN,
        HALIGN,
        NOWRAP,
        ROWSPAN,
        COLSPAN,
        PROMPT,
        HTTP_EQUIV,
        CONTENT,
        LANGUAGE,
        VERSION,
        N,
        FRAMEBORDER,
        MARGINWIDTH,
        MARGINHEIGHT,
        SCROLLING,
        NORESIZE,
        ENDTAG,
        COMMENT,
        SPAN,
        WRAP,
        UNICODE_BIDI,
        CHARSET,
        MEDIA;

        private String name = this.name().toLowerCase().replace('_', '-');

        public String toString() {
            return this.name;
        }
    }

    public static class UnknownAttribute
    extends HTML {
        private String name;

        public UnknownAttribute(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UnknownAttribute)) {
                return false;
            }
            return this.name.equals(((UnknownAttribute)obj).name);
        }
    }
}

