/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.InetHtmlDocument;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.utils.Logger;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ListAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private boolean numberedList;

    public ListAction(boolean numberedList) {
        super(numberedList ? "numberedListAction" : "bulletListAction");
        this.numberedList = numberedList;
    }

    @Override
    public Object getValue(String key) {
        if (key == "ShortDescription") {
            if (this.numberedList) {
                return InetHtmlAction.getTranslation("numbered_list");
            }
            return InetHtmlAction.getTranslation("bulled_list");
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block3: {
            JEditorPane editor = this.getHtmlEditor(e);
            if (editor != null && editor.getDocument() instanceof InetHtmlDocument) {
                Document doc = editor.getDocument();
                int start = editor.getSelectionStart();
                int end = editor.getSelectionEnd();
                try {
                    ((InetHtmlDocument)doc).changeListStatus(start, end - start, this.numberedList);
                }
                catch (BadLocationException e1) {
                    if (!Logger.doesLog(1)) break block3;
                    Logger.error(e1);
                }
            }
        }
    }
}

