/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.InetHtmlDocument;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.css.CSS;
import com.inet.html.parser.converter.FontWeight;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class BoldAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;

    public BoldAction() {
        super("font-bold");
    }

    @Override
    public Object getValue(String key) {
        if (key == "ShortDescription") {
            return InetHtmlAction.getTranslation("bold");
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JEditorPane editor = this.getHtmlEditor(e);
        if (editor != null && editor.getDocument() instanceof InetHtmlDocument) {
            Document doc = editor.getDocument();
            Caret c = editor.getCaret();
            if (c.getDot() - c.getMark() != 0) {
                Element paragraph;
                int pos = c.getMark();
                if (c.getDot() < c.getMark()) {
                    --pos;
                }
                if ((paragraph = ((InetHtmlDocument)doc).getParagraphElement(pos)).getEndOffset() - 1 == pos) {
                    --pos;
                }
                Element characterElement = ((InetHtmlDocument)doc).getCharacterElement(pos);
                boolean bold = CSS.isBold(characterElement);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                CSS.setFontWeight(sas, !bold);
                int start = Math.min(c.getDot(), c.getMark());
                int end = Math.max(c.getDot(), c.getMark());
                ((InetHtmlDocument)doc).setCharacterAttributes(start, end - start, sas, false);
            }
            if (editor instanceof JTextPane) {
                MutableAttributeSet atts;
                Object value = (atts = ((JTextPane)editor).getInputAttributes()).getAttribute((Object)CSS.Attribute.FONT_WEIGHT);
                CSS.setFontWeight(atts, value == null || value instanceof FontWeight && !((FontWeight)value).isBold());
                this.updateCaretListeners(editor);
            }
        }
    }
}

