/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.annotations.PublicApi;
import com.inet.html.css.HTML;

@PublicApi
public class InetHtmlConfiguration
implements Cloneable {
    private boolean inlineBoxCompatible = false;
    private boolean allowInternalImages = true;
    private HTML.Tag defaultBlock = HTML.Tag.P;
    private boolean transformEmptyBlocks = true;
    private boolean doAlwaysBreak = true;
    private boolean shouldBeEditable = true;

    public InetHtmlConfiguration(boolean inlineBoxCompatible, boolean allowInternalImages, boolean transformEmptyBlocks, boolean doAlwaysBreak, boolean shouldBeEditable, HTML.Tag defaultBlock) {
        this.inlineBoxCompatible = inlineBoxCompatible;
        this.allowInternalImages = allowInternalImages;
        this.transformEmptyBlocks = transformEmptyBlocks;
        this.doAlwaysBreak = doAlwaysBreak;
        this.shouldBeEditable = shouldBeEditable;
        this.defaultBlock = defaultBlock;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(140);
        toString.append("InlineBoxCompatibleMode    : ").append(this.inlineBoxCompatible).append("\n");
        toString.append("Allows to paste images     : ").append(this.allowInternalImages).append("\n");
        toString.append("Empty Block transformation : ").append(this.transformEmptyBlocks).append("\n");
        toString.append("Do always break on BR      : ").append(this.doAlwaysBreak).append("\n");
        toString.append("Should be editable         : ").append(this.shouldBeEditable).append("\n");
        toString.append("Default block element type : ").append((Object)this.defaultBlock).append("\n");
        return toString.toString();
    }

    public static InetHtmlConfiguration getBrowserConfig() {
        return new InetHtmlConfiguration(false, false, false, false, false, HTML.Tag.P);
    }

    public static InetHtmlConfiguration getHtmlEditorConfig() {
        return new InetHtmlConfiguration(false, true, true, false, true, HTML.Tag.P);
    }

    public static InetHtmlConfiguration getMailEditorConfig() {
        return new InetHtmlConfiguration(false, true, true, true, true, HTML.Tag.P);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new InetHtmlConfiguration(this.inlineBoxCompatible, this.allowInternalImages, this.transformEmptyBlocks, this.doAlwaysBreak, this.shouldBeEditable, this.defaultBlock);
    }

    public boolean isInlineBoxCompatible() {
        return this.inlineBoxCompatible;
    }

    public void setInlineBoxCompatible(boolean inlineBoxCompatible) {
        this.inlineBoxCompatible = inlineBoxCompatible;
    }

    public boolean isAllowInternalImages() {
        return this.allowInternalImages;
    }

    public void setAllowInternalImages(boolean allowInternalImages) {
        this.allowInternalImages = allowInternalImages;
    }

    public HTML.Tag getDefaultBlock() {
        return this.defaultBlock;
    }

    public void setDefaultBlock(HTML.Tag defaultBlock) {
        this.defaultBlock = defaultBlock;
    }

    public boolean isTransformEmptyBlocks() {
        return this.transformEmptyBlocks;
    }

    public void setTransformEmptyBlocks(boolean transformEmptyBlocks) {
        this.transformEmptyBlocks = transformEmptyBlocks;
    }

    public boolean isDoAlwaysBreak() {
        return this.doAlwaysBreak;
    }

    public void setDoAlwaysBreak(boolean doAlwaysBreak) {
        this.doAlwaysBreak = doAlwaysBreak;
    }

    public boolean isShouldBeEditable() {
        return this.shouldBeEditable;
    }

    public void setShouldBeEditable(boolean shouldBeEditable) {
        this.shouldBeEditable = shouldBeEditable;
    }
}

