/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ActionPool;
import com.inet.viewer.CustomPromptEditor;
import com.inet.viewer.ProgressPool;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ReportViewChangeListener;
import com.inet.viewer.ReportViewer;
import com.inet.viewer.SwingReportView;
import com.inet.viewer.SwingToolBar;
import com.inet.viewer.SwingViewerContext;
import com.inet.viewer.ToolBar;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.l;
import com.inet.viewer.n;
import com.inet.viewer.props.DefaultSetting;
import com.inet.viewer.y;
import java.applet.Applet;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PublicApi
public class SwingReportViewer
extends JPanel
implements ReportViewer {
    private ChangeListener bJo = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent evt) {
            JTabbedPane jTabbedPane = (JTabbedPane)evt.getSource();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 == -1) {
                return;
            }
            SwingReportViewer.this.setCurrentReportView((SwingReportView)jTabbedPane.getComponentAt(n2));
            SwingReportViewer.this.repaint();
        }
    };
    private int bJp;
    public static final int VERSION_MAJOR = 25;
    public static final int VERSION_MINOR = 4;
    private com.inet.viewer.props.a bJq = new com.inet.viewer.props.b();
    static final Dimension bFD = new Dimension(640, 480);
    private ArrayList bJr = new ArrayList();
    private boolean bJs = true;
    private boolean bJt = true;
    private boolean bJu;
    private SwingReportView bJv;
    private y bJw;
    private ActionPool bJx;
    private ArrayList bJy = new ArrayList();
    private SwingToolBar bJz;
    private Map bJA = new HashMap();
    private ProgressPool bJB = new ProgressPool();
    private PropertyChangeSupport bCz = new PropertyChangeSupport(this);
    private String bJC;
    private ViewerContext byS;
    public static final int PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR = 0;
    public static final int PRINTER_USE_REPORT_FORMAT = 1;
    private Throwable bJD;
    private final HashMap bGT = new HashMap();
    private Boolean bJE = null;

    public SwingReportViewer() {
        this((ViewerContext)null);
    }

    public SwingReportViewer(ViewerContext context) {
        this.bJx = new ActionPool(this);
        this.bJz = new SwingToolBar(this);
        if (context == null) {
            context = new SwingViewerContext(this);
        }
        this.setViewerContext(context);
        SwingUtilities.invokeLater(new Runnable(){
            private final String[] bJG = new String[]{"notfound.gif", "rootnode.gif", "groupnode_magnifier.gif", "groupnodeexp.gif", "groupnode.gif"};
            private int MY;

            @Override
            public void run() {
                ViewerUtils.getImageIcon(this.bJG[this.MY++]);
                if (this.MY < this.bJG.length) {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        ViewerUtils.logClientData(SwingReportViewer.getVersion());
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        if (this.getLayout() instanceof FlowLayout) {
            this.setLayout(new BorderLayout());
        }
        this.add((Component)this.bJz, "North");
        this.setPreferredSize(bFD);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.RG();
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.Sf()));
        this.a(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.RH();
            }
        };
        abstractAction2.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.Sf() | 0x40));
        this.a(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.bJu = !SwingReportViewer.this.bJu;
                for (int i2 = 0; i2 < SwingReportViewer.this.bJr.size(); ++i2) {
                    ((b)SwingReportViewer.this.bJr.get((int)i2)).bJH.RB().df(SwingReportViewer.this.bJu);
                }
            }
        };
        abstractAction3.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, ViewerUtils.Sf() | 0x40));
        this.a(abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingReportViewer.this.bJw != null && SwingReportViewer.this.bJw.indexOfComponent(SwingReportViewer.this.bJv) > 0) {
                    SwingReportViewer.this.closeReportView(SwingReportViewer.this.bJv);
                }
            }
        };
        abstractAction4.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, ViewerUtils.Sf()));
        this.a(abstractAction4);
        ActionPool actionPool = this.getActionPool();
        this.a(actionPool.getViewerAction(17));
        this.a(actionPool.getViewerAction(16));
        this.a(actionPool.getViewerAction(15));
        this.a(actionPool.getViewerAction(13));
        this.a(actionPool.getViewerAction(14));
        this.a(actionPool.getViewerAction(18));
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AWTPermission("accessClipboard"));
            }
        }
        catch (SecurityException securityException) {
            actionPool.getViewerAction(1).setEnabled(false);
            actionPool.getViewerAction(2).setEnabled(false);
        }
    }

    @Override
    public void setViewerContext(ViewerContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (context instanceof SwingViewerContext) {
            ((SwingViewerContext)context).setViewer(this);
        }
        this.byS = context;
    }

    @Override
    public ViewerContext getViewerContext() {
        return this.byS;
    }

    private void a(Action action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        this.getInputMap(2).put(keyStroke, action);
        this.getActionMap().put(action, action);
    }

    @Override
    public void closeAllReportViews() {
        ViewerUtils.debug("closing and disposing of all ReportViews...");
        for (b b2 : this.bJr) {
            b2.bJH.unregister();
        }
        this.bJr.clear();
        this.setCurrentReportView(null);
        this.removeAll();
        this.add((Component)this.bJz, "North");
        this.bJw = new y(this);
        this.add((Component)this.bJw, "Center");
        this.repaint();
    }

    @Override
    public void closeReportView(int index) {
        Component component = ((b)this.bJr.get((int)index)).bJH.getComponent();
        this.closeReportView((SwingReportView)component);
    }

    @Override
    public void closeReportView(ReportView view) {
        if (view == null) {
            throw new IllegalArgumentException();
        }
        if (this.bJw == null) {
            return;
        }
        int n2 = this.bJw.indexOfComponent((SwingReportView)view);
        this.bJw.removeTabAt(n2);
        this.bJr.remove(n2);
        this.setCurrentReportView((SwingReportView)this.bJw.getSelectedComponent());
        ((SwingReportView)view).unregister();
    }

    @Override
    public ToolBar getToolBar() {
        return this.bJz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView addNewReportView(RenderData data, boolean isClosable) {
        if (data == null) {
            throw new IllegalArgumentException("RenderData is null");
        }
        ReportView reportView = this.c(data);
        if (reportView != null) {
            return reportView;
        }
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            ReportView reportView2 = this.createReportView(data);
            this.addReportView(reportView2, isClosable);
            return reportView2;
        }
    }

    @Override
    public void addReportView(ReportView repView, boolean isClosable) {
        if (repView == null) {
            throw new IllegalArgumentException();
        }
        RenderData renderData = repView.getReportData();
        this.a(repView, renderData, isClosable);
    }

    @Override
    public ReportView addNewReportView(RenderData data) {
        boolean bl2 = this.bJr.size() > 0;
        return this.addNewReportView(data, bl2);
    }

    public ReportView createReportView(RenderData data) {
        SwingReportView swingReportView = new SwingReportView(this, this.bJq, this.getViewerContext());
        swingReportView.init(data);
        return swingReportView;
    }

    @Override
    public void addReportView(ReportView repView) {
        boolean bl2 = this.bJr.size() > 0;
        this.addReportView(repView, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ReportView reportView, RenderData renderData, boolean bl2) {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            boolean bl3;
            this.setPreferredSize(null);
            this.requestFocusInWindow();
            if (this.c(renderData) != null) {
                return;
            }
            this.bJr.add(new b((SwingReportView)reportView, renderData.getReportLocation(), renderData.getProperties()));
            this.setCurrentReportView(reportView);
            boolean bl4 = bl3 = this.bJw == null;
            if (bl3) {
                this.bJw = new y(this);
                this.add((Component)this.bJw, "Center");
                this.bJw.addChangeListener(this.bJo);
            }
            String string = SwingReportViewer.ee(renderData.getReportTitle());
            this.bJw.a(string, reportView.getComponent(), bl2);
            this.bJw.setSelectedComponent(reportView.getComponent());
            PropertyChangeListener[] propertyChangeListenerArray = this.bCz.getPropertyChangeListeners();
            for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
                reportView.getStatusBar().addStateChangeListener(propertyChangeListenerArray[i2]);
            }
        }
    }

    private ReportView c(RenderData renderData) {
        Iterator iterator = this.bJr.iterator();
        if (this.bJw != null) {
            while (iterator.hasNext()) {
                b b2 = (b)iterator.next();
                if (!b2.Mx.equals(renderData.getReportLocation()) || !"adhoc".equals(b2.Mx) && !b2.JN.equals(renderData.getProperties())) continue;
                this.bJw.setSelectedComponent(b2.bJH.getComponent());
                return b2.bJH;
            }
        }
        return null;
    }

    private static String ee(String string) {
        if (string != null && string.length() > 20) {
            String string2 = string.substring(0, 17) + "...";
            return string2;
        }
        return string;
    }

    @Override
    public void removeNotify() {
        if (this.bJw != null) {
            this.bJw.removeChangeListener(this.bJo);
        }
        for (b b2 : this.bJr) {
            b2.bJH.unregister();
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Object object2;
        if (this.bJw != null) {
            this.bJw.addChangeListener(this.bJo);
        }
        if (this.getRootPane() == null) {
            throw new ViewerException("The top window must be a Swing component - you cannot add the Viewer to a Frame or Dialog, use a JFrame or JDialog instead.");
        }
        for (Object object2 : this.bJr) {
            ((b)object2).bJH.OK();
        }
        object2 = SwingReportViewer.a(this);
        if (object2 instanceof Applet && ((Applet)object2).getAppletContext() != null) {
            this.setViewerContext(new com.inet.viewer.b(this.getViewerContext(), (Applet)object2));
        } else if (this.getViewerContext() == null) {
            this.setViewerContext(new SwingViewerContext(this));
        }
        super.addNotify();
    }

    private static Component a(Component component) {
        Container container = component.getParent();
        if (!(container == null || container instanceof Applet && ((Applet)container).getAppletContext() != null)) {
            return SwingReportViewer.a(container);
        }
        return container;
    }

    void b(n n2, RenderData renderData) {
        RenderData renderData2;
        if (n2 != null && (renderData2 = l.a(n2, renderData)) != null) {
            this.addNewReportView(renderData2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView getCurrentReportView() {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            return this.bJv;
        }
    }

    @Override
    public void setCurrentReportView(ReportView rv) {
        int n2;
        if (rv != null && this.bJw != null && (n2 = this.bJw.indexOfComponent(rv.getComponent())) != -1 && n2 != this.bJw.getSelectedIndex()) {
            this.bJw.removeChangeListener(this.bJo);
            this.bJw.setSelectedComponent(rv.getComponent());
            this.bJw.addChangeListener(this.bJo);
            this.repaint();
        }
        this.bJv = (SwingReportView)rv;
        this.RF();
    }

    @Override
    public void setHasGroupTree(boolean hasGroupTree) {
        this.a(hasGroupTree ? Boolean.TRUE : Boolean.FALSE);
        this.dd(hasGroupTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dd(boolean bl2) {
        this.bJs = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bJr.size(); ++i2) {
                ((b)this.bJr.get((int)i2)).bJH.setHasGroupTree(bl2);
            }
        }
    }

    @Override
    public boolean hasGroupTree() {
        return this.bJs;
    }

    @Override
    public void setHasStatusBar(boolean hasStatusBar) {
        this.de(hasStatusBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void de(boolean bl2) {
        this.bJt = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bJr.size(); ++i2) {
                ((b)this.bJr.get((int)i2)).bJH.da(bl2);
            }
        }
    }

    @Override
    public boolean hasStatusBar() {
        return this.bJt;
    }

    boolean RE() {
        return this.bJu;
    }

    public static int getMajorVersion() {
        return 25;
    }

    public static int getMinorVersion() {
        return 4;
    }

    public static String getVersionSuffix() {
        String string = "";
        return string;
    }

    public static String getVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(25);
        stringBuffer.append(".");
        stringBuffer.append(4);
        stringBuffer.append(".");
        stringBuffer.append("399");
        stringBuffer.append(SwingReportViewer.getVersionSuffix());
        return stringBuffer.toString();
    }

    public ActionPool getActionPool() {
        return this.bJx;
    }

    void d(Throwable throwable) {
        this.bJD = throwable;
    }

    public Throwable getLastError() {
        return this.bJD;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void RF() {
        for (int i2 = 0; i2 < this.bJy.size(); ++i2) {
            ((ReportViewChangeListener)this.bJy.get(i2)).reportViewChanged(this.bJv);
        }
    }

    @Override
    public void addReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bJy.add(rvcl);
    }

    @Override
    public void removeReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bJy.remove(rvcl);
    }

    public static PrintStream getLoggingStream() {
        return ViewerUtils.getLogStream();
    }

    public static void setLoggingStream(PrintStream stream) {
        ViewerUtils.setLogStream(stream);
    }

    void a(SwingReportView swingReportView, String string) {
        int n2;
        if (this.bJw != null && (n2 = this.bJw.indexOfComponent(swingReportView)) != -1) {
            String string2 = SwingReportViewer.ee(string);
            this.bJw.setTitleAt(n2, string2);
            if (!string.equals(string2)) {
                this.bJw.setToolTipTextAt(n2, string);
            }
            this.bJw.revalidate();
        }
    }

    @Override
    public ReportView getReportView(int i2) {
        return ((b)this.bJr.get((int)i2)).bJH;
    }

    @Override
    public int getReportViewCount() {
        return this.bJr.size();
    }

    @Override
    public void addStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bCz.addPropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().addStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public void removeStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bCz.removePropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().removeStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public ProgressPool getProgressPool() {
        return this.bJB;
    }

    public String getDefaultExportDirectory() {
        return this.RI();
    }

    public void setDefaultExportDirectory(String directory) {
        this.ef(directory);
    }

    private void RG() {
        if (this.bJw != null) {
            int n2 = this.bJw.indexOfComponent(this.bJv);
            SwingReportView swingReportView = (SwingReportView)this.bJw.getComponentAt((n2 + 1) % this.bJw.getTabCount());
            this.bJw.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    private void RH() {
        if (this.bJw != null) {
            int n2 = this.bJw.indexOfComponent(this.bJv);
            if (n2 == 0) {
                n2 = this.bJw.getTabCount();
            }
            SwingReportView swingReportView = (SwingReportView)this.bJw.getComponentAt((n2 - 1) % this.bJw.getTabCount());
            this.bJw.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    void showError(Throwable th, Object source) {
        this.d(th);
        this.getViewerContext().showError(th, source);
    }

    @Override
    public void setCustomPromptEditor(String promptName, int valueType, CustomPromptEditor editor) {
        promptName = promptName.toLowerCase();
        if (editor == null) {
            this.bJA.remove(new a(promptName, valueType));
        } else {
            this.bJA.put(new a(promptName, valueType), editor);
        }
    }

    CustomPromptEditor z(String string, int n2) {
        CustomPromptEditor customPromptEditor = (CustomPromptEditor)this.bJA.get(new a(string.toLowerCase(), n2));
        if (customPromptEditor != null) {
            return customPromptEditor;
        }
        return (CustomPromptEditor)this.bJA.get(new a(string.toLowerCase(), -1));
    }

    void ef(String string) {
        this.bJC = string;
    }

    String RI() {
        return this.bJC;
    }

    HashMap RJ() {
        return this.bGT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void c(PromptData[] promptDataArray) {
        HashMap hashMap = this.bGT;
        synchronized (hashMap) {
            for (int i2 = 0; i2 < promptDataArray.length; ++i2) {
                String string = promptDataArray[i2].getName();
                if (string == null) continue;
                this.bGT.put(string.toLowerCase(), promptDataArray[i2].getPromptValueObject());
            }
        }
    }

    public void setPrinterDefaultFormatHandling(int printerDefaultFormatHandling) {
        if (printerDefaultFormatHandling != 0 && printerDefaultFormatHandling != 1) {
            throw new IllegalArgumentException("parameter must be either PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR or PRINTER_USE_REPORT_FORMAT!");
        }
        this.bJp = printerDefaultFormatHandling;
    }

    public int getPrinterDefaultFormatHandling() {
        return this.bJp;
    }

    void a(Boolean bl2) {
        this.bJE = bl2;
    }

    Boolean RK() {
        return this.bJE;
    }

    public DefaultSetting getDefaultSetting(DefaultSetting.a key) {
        return this.bJq.a(key);
    }

    public void setDefaultSetting(DefaultSetting.a key, DefaultSetting value) {
        this.bJq.a(key, value);
    }

    private static class b {
        private SwingReportView bJH;
        private String Mx;
        private Properties JN;

        private b(SwingReportView swingReportView, String string, Properties properties) {
            this.bJH = swingReportView;
            this.Mx = string;
            this.JN = properties;
        }

        public boolean equals(Object obj) {
            return this.bJH.equals(obj) || super.equals(obj);
        }
    }

    private static class a {
        private final String aXq;
        private final int btG;

        private a(String string, int n2) {
            this.aXq = string;
            this.btG = n2;
        }

        public boolean equals(Object obj) {
            return obj instanceof a && ((a)obj).btG == this.btG && (((a)obj).aXq == null && this.aXq == null || ((a)obj).aXq.equals(this.aXq));
        }

        public int hashCode() {
            return this.aXq.hashCode() + this.btG * 17;
        }
    }
}

