/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bCS;
    private int bCM;
    private boolean bCT;
    private Timer bCU;
    private Popup bCV;
    private JLabel bCW;
    private JPanel bCX;
    private boolean bCY;
    private Point bCZ;
    private JComboBox bDa;
    private boolean bDb;
    private boolean bDc;
    private Class bDd;
    private Constructor bDe;
    private Class[] bDf = new Class[]{String.class};
    private Color bDg;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bDh;

    private RealtimeValidationPopup(int promptType) {
        this.bCM = promptType;
        this.bCW = new JLabel();
        this.bCX = new JPanel();
        this.bCX.setOpaque(true);
        this.bCX.add(this.bCW);
        this.bCX.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bCX.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bCU = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bDh == null) {
            return;
        }
        this.bDb = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bDa = surroundingBox;
        }
        this.bCS = textcomponent;
        this.bCS.addFocusListener(this);
        this.bDg = this.bCS.getBackground();
    }

    private void initFormats() {
        this.bDh = null;
        switch (this.bCM % 128) {
            case 6: 
            case 7: {
                this.bDh = this.bDb ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bDh = this.bDb ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bDh = this.bDb ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bDh = this.bDb ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void Px() {
        if (this.bCS instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bCS.isEnabled() || !this.bCS.isShowing() || object.toString().length() == 0 || this.bCS instanceof JComboBox && ((JComboBox)this.bCS).isPopupVisible() || (this.bCM % 128 == 6 || this.bCM % 128 == 7) && string.equals("-")) {
            if (!this.bCS.isEnabled()) {
                this.bCS.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bCS.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bDh.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bDc && this.bDd != null) {
                if (this.bDd == Object.class) {
                    this.bDd = String.class;
                }
                this.bDe = this.bDd.getConstructor(this.bDf);
                this.bDe.newInstance(string);
            }
            this.bCT = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bCS.getLocationOnScreen();
                point.y += this.bCS.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bCS.invalidate();
            this.bCS.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bDh, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bDh.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).Ou();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bCS.getLocationOnScreen();
        point.y += this.bCS.getHeight();
        this.bCT = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.Py();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bCS.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bCS.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bCS.getLocationOnScreen();
        point.y += this.bCS.getHeight();
        this.bCT = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.Py();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bCS.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bCS.invalidate();
    }

    private String Py() {
        Format format = switch (this.bCM) {
            case 9 -> PromptValue.DATEFORMAT;
            case 15 -> PromptValue.DATETIMEFORMAT;
            case 10 -> PromptValue.TIMEFORMAT;
            default -> null;
        };
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bCM == 6 || this.bCM == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.ec(string);
        this.bCW.setText(string);
        this.bCX.setBackground(color);
        if (!this.bCY) {
            this.bCZ = point;
        } else {
            point = this.bCZ;
        }
        if (this.bCV != null) {
            this.hidePopup();
        }
        this.bCV = PopupFactory.getSharedInstance().getPopup(this.bCS, this.bCX, point.x, point.y);
        this.bCV.show();
        this.bCY = true;
        if (this.bCU.isRunning()) {
            this.bCU.restart();
        } else {
            this.bCU.start();
        }
    }

    private String ec(String object) {
        object = this.bCT ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bCS instanceof JPasswordField) {
            return new String(((JPasswordField)this.bCS).getPassword());
        }
        if (this.bCS instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bCS).getText();
            if (this.bDa == null) {
                return string2;
            }
            Object object = this.bDa.getSelectedItem();
            if (this.bCS != null && this.bDa.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bCS instanceof JComboBox) {
            return ((JComboBox)this.bCS).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bCV != null) {
            this.bCV.hide();
        }
        this.bCY = false;
        if (this.bCU.isRunning()) {
            this.bCU.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bDc = checkClassType;
        this.bDd = classtype;
    }

    public void setPromptType(int promptType) {
        this.bCM = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bCS == null) {
            return;
        }
        if (this.bCS instanceof JTextField) {
            ((JTextField)this.bCS).getDocument().removeDocumentListener(this);
        } else if (this.bCS instanceof JComboBox) {
            ((JComboBox)this.bCS).removeActionListener(this);
            ((JComboBox)this.bCS).removePopupMenuListener(this);
        }
        this.bCS.removeFocusListener(this);
        if (this.bDa != null) {
            this.bDa.removeActionListener(this);
            this.bDa.removePopupMenuListener(this);
        }
        this.bCS.setBackground(this.bDg);
    }

    public boolean isPopupError() {
        return this.bCT;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.Px();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.Px();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.Px();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.Px();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.Px();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bDh = format;
    }
}

