/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int bxr = -1;
    protected final PropertyChangeSupport bCz = new PropertyChangeSupport(this);
    private int type;
    private int bCA;
    private int progress;
    private boolean bCB = false;
    private String age;
    private ReportView bCC;
    private ViewerContext byS;
    private Component bAT;
    Thread bCD;

    public Progress(ReportView reportView, int type) {
        this.type = type;
        this.bCC = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.bAT = reportView.getComponent();
            this.byS = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.type = type;
        this.byS = viewerContext;
        this.bAT = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.bCD != null && this.bCD.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.bCD = new Thread((Runnable)this, this.getName());
        this.bCD.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.bCB) {
            this.bCD.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.bCD.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.bCB;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl2 = this.bCB;
        this.bCB = indeterminate;
        this.bCz.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl2, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.bxr;
        this.bxr = status;
        this.bCz.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.bxr);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.bxr == 3 || this.bxr == 2 || this.bxr == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.bxr == 3;
    }

    public boolean isErrored() {
        return this.bxr == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.bCA;
        this.bCA = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.bCz.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.bCA;
    }

    public void setProgress(int step) {
        int n2 = this.progress;
        this.progress = step;
        this.bCz.firePropertyChange(PROP_PROGRESS_STEP, n2, this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public ReportView getReportView() {
        return this.bCC;
    }

    public int getStatus() {
        return this.bxr;
    }

    public String getErrorMessage() {
        return this.age;
    }

    public void setErrorMessage(String msg) {
        this.age = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.byS == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.byS.showError(th, this.bAT);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.bCz.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.bCz.removePropertyChangeListener(l2);
    }

    protected void Pq() {
        PropertyChangeListener[] propertyChangeListenerArray = this.bCz.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.bCz.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

