/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.error.HasErrorCode;
import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.SwingViewerContext;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.bn;
import com.inet.viewer.i18n.a;
import com.inet.viewer.u;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;

@InternalApi
public final class JErrorDialog
extends JDialog
implements ActionListener {
    private JButton bAQ;
    private JButton bAR;
    private JPanel bAS;
    private Properties JN;
    private Component bAT;
    private JScrollPane bAU;
    private ViewerContext bAV;
    private String supportEmail;
    private u bAW;
    private u bAX;

    private JErrorDialog(ViewerContext context, Component parent, Frame frame, String title, Throwable th) {
        super(frame, title, true);
        this.bAV = context;
        this.bAT = parent;
        this.setName("errordialog");
        this.b(th);
    }

    private JErrorDialog(ViewerContext context, Component parent, Dialog dialog, String title, Throwable th) {
        super(dialog, title, true);
        this.bAV = context;
        this.bAT = parent;
        this.b(th);
    }

    private JErrorDialog(ViewerContext context, Component parent, Frame frame, String title, String message, String detailData) {
        super(frame, title, true);
        this.bAV = context;
        this.bAT = parent;
        this.setName("errordialog");
        this.a(0, message, detailData);
    }

    private JErrorDialog(ViewerContext context, Component parent, Dialog dialog, String title, String message, String detailData) {
        super(dialog, title, true);
        this.bAV = context;
        this.bAT = parent;
        this.a(0, message, detailData);
    }

    public static void showError(Component parent, String title, Throwable th) {
        ViewerContext viewerContext = parent instanceof SwingReportViewer ? ((SwingReportViewer)parent).getViewerContext() : new SwingViewerContext(parent);
        Window window = bn.b(parent);
        if (window instanceof Frame) {
            new JErrorDialog(viewerContext, parent, (Frame)window, title, th).setVisible(true);
        } else {
            new JErrorDialog(viewerContext, parent, (Dialog)window, title, th).setVisible(true);
        }
    }

    public static void showError(Component parent, Throwable th) {
        JErrorDialog.showError(parent, a.getMsg("errordialog.error"), th);
    }

    public static void showError(Component parent, String title, String message, String detailData) {
        ViewerContext viewerContext = parent instanceof SwingReportViewer ? ((SwingReportViewer)parent).getViewerContext() : new SwingViewerContext(parent);
        Window window = bn.b(parent);
        if (window instanceof Frame) {
            new JErrorDialog(viewerContext, parent, (Frame)window, title, message, detailData).setVisible(true);
        } else {
            new JErrorDialog(viewerContext, parent, (Dialog)window, title, message, detailData).setVisible(true);
        }
    }

    public static void showError(Component parent, String message, String detailData) {
        JErrorDialog.showError(parent, a.getMsg("errordialog.error"), message, detailData);
    }

    private void b(Throwable throwable) {
        this.setFocusable(true);
        int n2 = throwable instanceof HasErrorCode ? ((HasErrorCode)throwable).getErrorCode() : 0;
        if (throwable instanceof ViewerException) {
            String string;
            ViewerException viewerException = (ViewerException)throwable;
            if (viewerException.getCause() != null) {
                throwable = viewerException.getCause();
            }
            if ((string = viewerException.stacktrace) == null) {
                string = JErrorDialog.c(throwable);
            }
            this.supportEmail = this.dY(viewerException.getSupportEmail());
            this.a(n2, ViewerException.getErrorMessage(viewerException), string);
            this.JN.setProperty("version", this.dY(viewerException.srvVersion));
            this.JN.setProperty("format", this.dY(viewerException.format));
            this.JN.setProperty("server_java_version", this.dY(viewerException.srvJVM));
            this.JN.setProperty("os", this.dY(viewerException.srvOS));
            this.JN.setProperty("cache", String.valueOf(viewerException.srvCache));
        } else {
            this.a(n2, ViewerException.getErrorMessage(throwable), JErrorDialog.c(throwable));
        }
        ViewerUtils.printStackTrace(throwable);
    }

    private String dY(String string) {
        return string == null ? "" : string;
    }

    private static final String c(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private final void a(int n2, String string, String string2) {
        JComponent jComponent;
        this.setDefaultCloseOperation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(keyStroke, "escape");
        this.getRootPane().getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JErrorDialog.this.dispose();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        Insets insets = new Insets(8, 8, 0, 8);
        this.JN = new Properties();
        if (string != null) {
            this.JN.setProperty("message", string);
        }
        if (string2 != null) {
            this.JN.setProperty("stacktrace", string2);
        }
        string = this.dY(string);
        string2 = this.dY(string2);
        JLabel jLabel = new JLabel();
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        if (icon != null && icon.getIconHeight() > 0 && icon.getIconWidth() > 0) {
            jLabel = new JLabel(icon);
            container.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 3, 0.0, 0.0, 11, 0, insets, 0, 0));
        }
        if (n2 != 0) {
            this.JN.setProperty("errnumber", String.valueOf(n2));
            container.add((Component)new JLabel(a.getMsg("errordialog.error") + ":"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            container.add((Component)new JLabel(String.valueOf(n2)), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        }
        container.add((Component)new JLabel(a.getMsg("description") + ":"), new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        if (string.startsWith("<html>")) {
            jComponent = new JEditorPane();
            ((JTextComponent)jComponent).setEditable(false);
            ((JEditorPane)jComponent).setContentType("text/html");
            jComponent.setPreferredSize(new Dimension(500, 180));
            ((JEditorPane)jComponent).addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e2) {
                    if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            JErrorDialog.this.bAV.showUrl(e2.getURL().toString(), null);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ViewerUtils.printStackTrace(malformedURLException);
                        }
                    }
                }
            });
            ((JTextComponent)jComponent).getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            ((JEditorPane)jComponent).setText(string);
            this.bAU = new JScrollPane(jComponent, 20, 31);
        } else {
            jComponent = new JTextArea();
            ((JTextArea)jComponent).setLineWrap(true);
            ((JTextArea)jComponent).setWrapStyleWord(true);
            ((JTextComponent)jComponent).setText(string);
            ((JTextComponent)jComponent).setEditable(false);
            jComponent.setBackground(jLabel.getBackground());
            ((JTextArea)jComponent).setRows(5);
            ((JTextArea)jComponent).setColumns(45);
            ((JTextArea)jComponent).setFont(UIManager.getFont("OptionPane.messageFont"));
            this.bAU = new JScrollPane(jComponent, 20, 31);
            this.bAU.setBorder(null);
        }
        container.add((Component)this.bAU, new GridBagConstraints(1, 4, 3, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(2, 8, 8));
        container.add((Component)jComponent, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 13, 0, new Insets(0, 80, 0, 0), 0, 0));
        this.bAQ = new JButton(a.getMsg("ok"));
        this.bAQ.addActionListener(this);
        this.bAQ.setRequestFocusEnabled(true);
        this.bAQ.setName("lib.inet.ok");
        jComponent.add(this.bAQ);
        this.getRootPane().setDefaultButton(this.bAQ);
        this.bAR = new JButton(a.getMsg("errordialog.details") + " >>");
        this.bAR.addActionListener(this);
        this.bAR.setEnabled(string2.trim().length() > 0);
        jComponent.add(this.bAR);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("MONOSPACED", 0, jTextArea.getFont().getSize() - 2));
        jTextArea.setText(string2);
        jTextArea.setEditable(false);
        jTextArea.setBackground(null);
        jTextArea.setRows(7);
        jTextArea.setColumns(45);
        this.bAS = new JPanel();
        this.bAS.setLayout(new GridBagLayout());
        this.bAS.setVisible(false);
        container.add((Component)this.bAS, new GridBagConstraints(1, 6, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        final JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        this.bAS.add((Component)jScrollPane, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 8, 0), 0, 0));
        if (this.supportEmail != null && this.supportEmail.length() > 0) {
            this.bAW = new u(a.getMsg("errordialog.support"));
            this.bAW.a(this);
            this.bAS.add((Component)this.bAW, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.bAX = new u(a.getMsg("errordialog.more_info"));
        this.bAX.a(this);
        this.bAS.add((Component)this.bAX, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.bAT);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JErrorDialog.this.bAQ.requestFocusInWindow();
                JErrorDialog.this.bAU.getVerticalScrollBar().setValue(0);
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            Object object = ev.getSource();
            if (object == this.bAQ) {
                this.dispose();
            } else if (object == this.bAW) {
                StringBuilder stringBuilder = new StringBuilder("mailto:" + this.supportEmail + "?subject=");
                Object object2 = this.JN.getProperty("message", "");
                if (((String)object2).length() > 60) {
                    object2 = ((String)object2).substring(0, 57) + "...";
                }
                stringBuilder.append(new URI("bla", (String)object2, null).getRawSchemeSpecificPart());
                stringBuilder.append("&body=");
                object2 = "<Your description>\r\n<Steps to reproduce error>\r\n\r\nThe following error occurred while running a report in the Viewer:\r\n" + this.JN.getProperty("stacktrace", "");
                stringBuilder.append(new URI("bla", (String)object2, null).getRawSchemeSpecificPart());
                this.bAV.showUrl(stringBuilder.toString(), null);
                this.dispose();
            } else if (object == this.bAX) {
                int n2 = JOptionPane.showConfirmDialog(this, a.getMsg("errordialog.confirm"), a.getMsg("errordialog.error"), 0);
                if (n2 == 0) {
                    this.JN.setProperty("client_java_version", System.getProperty("java.version") + "; " + System.getProperty("java.vm.name", "") + "; " + System.getProperty("java.vendor"));
                    this.JN.setProperty("client_os", System.getProperty("os.name", "") + " " + System.getProperty("os.version", ""));
                    this.dispose();
                    this.bAV.showUrl("https://www.inetsoftware.de/external-services/error", this.JN);
                }
            } else if (object == this.bAR) {
                GridBagLayout gridBagLayout = (GridBagLayout)this.getContentPane().getLayout();
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.bAU);
                if (this.bAS.isVisible()) {
                    this.bAR.setText(a.getMsg("errordialog.details") + " >>");
                    gridBagConstraints.weighty = 1.0;
                    this.bAS.setVisible(false);
                } else {
                    this.bAR.setText(a.getMsg("errordialog.details") + " <<");
                    gridBagConstraints.weighty = 0.0;
                    this.bAS.setVisible(true);
                }
                gridBagLayout.setConstraints(this.bAU, gridBagConstraints);
                this.pack();
            }
        }
        catch (Throwable throwable) {
            JErrorDialog.showError(this.bAT, throwable);
        }
    }
}

