/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.util;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.error.ErrorCodeHelper;
import com.inet.http.error.HttpFailedException;
import com.inet.http.error.ServletErrorHandler;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.report.BaseUtils;
import com.inet.report.CacheRenderData;
import com.inet.report.Engine;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportGenerator;
import com.inet.report.ReportKeyFactory;
import com.inet.report.bf;
import com.inet.report.by;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.plugins.ReportingServerPlugin;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.RendererFactoryManager;
import com.inet.report.renderer.api.implementation.g;
import com.inet.report.renderer.api.implementation.k;
import com.inet.report.renderer.base.i;
import com.inet.report.renderer.base.j;
import com.inet.report.renderer.html.HtmlSearchHandler;
import com.inet.report.renderer.java.e;
import com.inet.report.servlets.c;
import com.inet.report.util.NameValue;
import com.inet.report.util.ReportKeyUtils;
import com.inet.report.util.RuntimeUtilities;
import com.inet.report.util.ServletUtils;
import com.inet.report.util.SupplierWithException;
import com.inet.shared.utils.MemoryStream;
import com.inet.viewer.ViewerException;
import com.inet.viewer.archive.search.SearchHandler;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class WebUtils {
    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="redirect only to client if timeout")
    public static void execRequestCache(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull OutputStream out, @Nonnull Properties props, @Nullable PropertiesChecker checker) throws Exception {
        String string;
        Cache cache = Cache.getCache();
        final String string2 = props.getProperty("export_fmt");
        switch (string = props.getProperty("cmd", "")) {
            case "stop": {
                break;
            }
            case "ping": {
                EngineProgress engineProgress = WebUtils.a(cache, request, props, checker, false);
                MemoryStream memoryStream = new MemoryStream();
                e.W(memoryStream);
                memoryStream.writeUTF8Int(120);
                int n2 = memoryStream.size();
                memoryStream.writeUTF8Boolean(engineProgress.state != i.azx);
                memoryStream.writeUTF8Int(engineProgress.progress);
                memoryStream.writeStringJava2((CharSequence)ReportingServerPlugin.MSG.getMsg("EngineState" + String.valueOf((Object)engineProgress.state), new Object[0]));
                memoryStream.insertUTF8Int(n2, memoryStream.size() - n2);
                e.X(memoryStream);
                byte[] byArray = memoryStream.toByteArray();
                WebUtils.sendHeader(request, response, props, 200, byArray.length, "application/crystalclear");
                out.write(byArray);
                out.flush();
                break;
            }
            case "status": {
                EngineProgress engineProgress = WebUtils.a(cache, request, props, checker, false);
                WebUtils.sendHeader(request, response, props, 200, -1, "application/json");
                new Json().toJson((Object)engineProgress, out);
                break;
            }
            case "start": {
                EngineProgress engineProgress = WebUtils.a(cache, request, props, checker, true);
                WebUtils.sendHeader(request, response, props, 200, -1, "application/json");
                new Json().toJson((Object)engineProgress, out);
                break;
            }
            case "search": {
                byte[] byArray;
                String string3;
                int n3;
                int n4;
                String string4 = (String)props.remove("phrase");
                try {
                    n4 = Integer.parseInt((String)props.remove("flags"));
                }
                catch (Throwable throwable) {
                    n4 = 0;
                }
                try {
                    n3 = Integer.parseInt(props.getProperty("page"));
                }
                catch (Throwable throwable) {
                    n3 = 1;
                }
                try {
                    SearchHandler searchHandler;
                    if ("java2".equals(props.getProperty("viewer"))) {
                        CacheRenderData cacheRenderData = new CacheRenderData(props, checker, (Object)request);
                        searchHandler = new SearchHandler(cacheRenderData);
                        string3 = "application/crystalclear";
                    } else {
                        CacheRenderData cacheRenderData = new CacheRenderData(props, checker, request){

                            @Override
                            protected ReportCacheKey getKey(Properties props) throws ReportException {
                                props.put("export_fmt", string2);
                                return super.getKey(props);
                            }
                        };
                        searchHandler = new HtmlSearchHandler(cacheRenderData);
                        string3 = "application/json";
                    }
                    byArray = searchHandler.search(string4, n3, n4);
                }
                catch (ViewerException viewerException) {
                    Throwable throwable = viewerException.getCause();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw viewerException;
                }
                WebUtils.sendHeader(request, response, props, 200, byArray.length, string3);
                out.write(byArray);
                break;
            }
            default: {
                Object object;
                Objects.requireNonNull(cache);
                if ("rfsh".equals(string)) {
                    ReportCacheKey reportCacheKey = cache.createKey((Properties)props.clone(), checker, request);
                    BaseUtils.info("creating a new engine: " + reportCacheKey.getReport());
                    if (cache.isFinished(reportCacheKey)) {
                        cache.delete(reportCacheKey);
                        for (ReportCacheKey reportCacheKey2 : cache.getReports()) {
                            if (reportCacheKey2 == null || !reportCacheKey2.getReport().equals(reportCacheKey.getReport()) || !reportCacheKey2.getParameter().equals(reportCacheKey.getParameter())) continue;
                            cache.delete(reportCacheKey2);
                        }
                    } else {
                        object = props.getProperty("promptonrefresh", "false");
                        if ((((String)object).equals("1") || ((String)object).equals("true")) && ("java".equals(string2) || string2 == null)) {
                            Engine engine = Cache.getEngineFactory().createEngine(props);
                            bf.a(by.j(engine), props, true);
                        }
                        BaseUtils.warning("ignore rfsh");
                    }
                }
                if ("font".equals(string2)) {
                    props.put("export_fmt", "java");
                    props.put("page", "-" + props.getProperty("page", "1"));
                }
                try {
                    WebUtils.toClient(cache, request, response, out, props, checker);
                    break;
                }
                catch (ReportException reportException) {
                    if (reportException.getErrorCode() == ReportErrorCode.Timeout.getErrorCodeNumber()) {
                        props = com.inet.shared.servlet.ServletUtils.getAllParameters((HttpServletRequest)request);
                        ReportKeyFactory.decodeProps(props);
                        if ("rfsh".equals(props.getProperty("cmd"))) {
                            props.remove("cmd");
                        }
                        object = request.getRequestURI() + "?" + ReportKeyUtils.getRelevantParams(props, false, true);
                        if (BaseUtils.isWarning()) {
                            BaseUtils.warning(reportException);
                            BaseUtils.warning("Redirect to: " + (String)object);
                        }
                        response.sendRedirect((String)object);
                        break;
                    }
                    throw reportException;
                }
            }
        }
    }

    @Nonnull
    private static EngineProgress a(Cache cache, HttpServletRequest httpServletRequest, Properties properties, PropertiesChecker propertiesChecker, boolean bl2) throws ReportException {
        Serializable serializable;
        ReportCacheKey reportCacheKey = bl2 ? cache.getKey(properties, propertiesChecker, httpServletRequest) : cache.createKey(properties, propertiesChecker, httpServletRequest);
        String string = ReportKeyFactory.getRelevantParamsNoSort(properties);
        Logger logger = LogManager.getLogger((String)"Reporting");
        logger.debug((Object)reportCacheKey);
        logger.debug((Object)("Relevant Params: " + string));
        boolean bl3 = cache.exists(reportCacheKey);
        if (bl3) {
            cache.resetCacheTimeout(reportCacheKey);
        } else {
            BaseUtils.info("Viewer tried pinging report which no longer exists in the cache: " + String.valueOf(properties));
        }
        EngineProgress engineProgress = new EngineProgress();
        ReportGenerator reportGenerator = cache.getEngine(reportCacheKey);
        if (reportGenerator == null) {
            if (bl3) {
                engineProgress.state = i.azw;
                engineProgress.progress = 100;
            } else {
                engineProgress.state = i.azx;
                engineProgress.progress = 0;
            }
        } else {
            serializable = (j)reportGenerator.getStatistics();
            engineProgress.state = serializable.wY();
            engineProgress.progress = serializable.wZ();
        }
        if (bl3 && cache.isFailedReport(reportCacheKey) && (serializable = cache.getFailureCause(reportCacheKey)) != null) {
            engineProgress.error = StringFunctions.getUserFriendlyErrorMessage((Throwable)serializable);
        }
        return engineProgress;
    }

    static Properties b(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null || !"POST".equals(httpServletRequest.getMethod())) {
            return null;
        }
        Properties properties = com.inet.shared.servlet.ServletUtils.getAllParameters((HttpServletRequest)httpServletRequest);
        String string = httpServletRequest.getQueryString();
        if (string != null) {
            Properties properties2 = new Properties();
            by.c(string, properties2, false);
            for (Object object : properties2.keySet()) {
                properties.remove(object);
            }
        }
        if (properties.size() == 0) {
            return null;
        }
        return properties;
    }

    static String o(Properties properties) {
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            arrayList.add(new NameValue(entry.getKey(), entry.getValue()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        new Json().toJson(arrayList, stringBuilder);
        return stringBuilder.toString().replace("/", "\\/");
    }

    public static void toClient(@Nonnull Cache cache, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable OutputStream out, @Nonnull Properties props, @Nullable PropertiesChecker checker) throws Exception {
        Object object;
        if (out == null) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("scheduling, toClient canceled (out is null)");
            }
            return;
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("Request Properties:" + String.valueOf(props));
        }
        String string = props.getProperty("cmd");
        if (props.getProperty("init", "").length() > 0) {
            object = props.getProperty("init");
            Objects.requireNonNull(object);
            string = ((String)object).toLowerCase();
        } else if ((string == null || string.equals("rfsh")) && props.getProperty("export_fmt", "").length() > 0) {
            string = props.getProperty("export_fmt");
        }
        object = RendererFactoryManager.getInstance().getToClientHandlerByCommand(string);
        if (object == null) {
            throw new IllegalArgumentException("Unknown command:" + string);
        }
        String string2 = props.getProperty("page");
        SupplierWithException<ReportCacheKey> supplierWithException = () -> {
            ReportCacheKey reportCacheKey = cache.getKey(props, checker, request);
            Objects.requireNonNull(reportCacheKey);
            cache.resetCacheTimeout(reportCacheKey);
            return reportCacheKey;
        };
        object.handle(cache, request, response, out, supplierWithException, props, string2, checker);
        BaseUtils.info("End of toClient");
    }

    public static boolean isEncodedError(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response, ReportCacheKey key) throws Exception {
        Cache cache = Cache.getCache();
        Objects.requireNonNull(cache);
        Throwable throwable = cache.getFailureCause(key);
        if (throwable != null) {
            if (request == null || response == null) {
                throw new Exception(throwable);
            }
            ServletErrorHandler.sendErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (Throwable)throwable);
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file to get the name")
    public static boolean sendHeader(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Properties props, int statusCode, int length, String contentType) throws IOException {
        if ("GET".equals(request.getMethod())) {
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
        }
        response.setContentType(contentType);
        try {
            response.setStatus(statusCode);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (statusCode == 401 && !ServletErrorHandler.handleUnautorized((HttpServletRequest)request, (HttpServletResponse)response)) {
            return false;
        }
        if (length >= 0) {
            response.setContentLength(length);
        }
        boolean bl2 = !contentType.equals("text/html; charset=utf-8");
        String string = props.getProperty("export_fmt");
        RendererFactory rendererFactory = null;
        if (string != null) {
            try {
                rendererFactory = RendererFactoryManager.getInstance().getDocumentRenderer(string);
                bl2 = bl2 && !(rendererFactory instanceof k) && !(rendererFactory instanceof g);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bl2) {
            String string2 = props.getProperty("report");
            if (string2 == null) {
                string2 = props.getProperty("reports");
            }
            if (string2 != null && string2.trim().length() != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String bl3 : string2.split(";")) {
                    File file;
                    int n2 = bl3.lastIndexOf(58);
                    if (n2 > 2) {
                        bl3 = bl3.substring(n2 + 1);
                        bl3 = EncodingFunctions.decodeUrlPath((String)bl3);
                    }
                    if ((n2 = (string2 = (file = new File(bl3)).getName()).lastIndexOf(46)) > 0) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('-');
                        }
                        stringBuilder.append(string2, 0, n2);
                        continue;
                    }
                    stringBuilder.append(string2);
                }
                if (stringBuilder.length() > 0) {
                    String string3 = rendererFactory != null && string != null ? rendererFactory.getEngineExportFormat(string) : string;
                    String string4 = props.getProperty("filename");
                    if (string4 != null && string4.length() > 0) {
                        stringBuilder.setLength(0);
                        stringBuilder.append(string4.trim());
                    }
                    stringBuilder.append('.').append(string3);
                    String string5 = props.getProperty("disposition");
                    string2 = stringBuilder.toString();
                    boolean bl3 = "attachment".equalsIgnoreCase(string5) || string2.endsWith(".zip");
                    com.inet.shared.servlet.ServletUtils.setContentDisposition((HttpServletResponse)response, (String)string2, (!bl3 ? 1 : 0) != 0);
                }
            }
        }
        return true;
    }

    public static void writeString(OutputStream out, String s2) throws IOException {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            out.write(s2.charAt(i2));
        }
    }

    public static void sendErrorPage(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Throwable th) {
        try {
            Properties properties = com.inet.shared.servlet.ServletUtils.getAllParameters((HttpServletRequest)request);
            ServletUtils.setContextProperties(request, properties);
            c.m(properties);
            ServletOutputStream servletOutputStream = response.getOutputStream();
            WebUtils.a(request, response, th, (OutputStream)servletOutputStream, properties);
        }
        catch (EOFException eOFException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Could not send engine error page");
            }
        }
        catch (IOException iOException) {
            BaseUtils.warning("Could not send engine error page");
            BaseUtils.warning(iOException);
        }
    }

    private static void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull Throwable throwable, @Nonnull OutputStream outputStream, @Nonnull Properties properties) {
        BaseUtils.warning("sending engine message: " + String.valueOf(throwable));
        if (!ServletErrorHandler.isClientAbort((Throwable)throwable)) {
            BaseUtils.printStackTrace(throwable);
        }
        try {
            int n2;
            byte[] byArray = null;
            String string = null;
            try {
                String string2 = properties.getProperty("export_fmt", "");
                RendererFactory rendererFactory = RendererFactoryManager.getInstance().getDocumentRenderer(string2.toLowerCase());
                byArray = rendererFactory.getErrorData(throwable, properties);
                string = properties.getProperty("content", "application/crystalclear");
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (byArray == null) {
                byArray = RuntimeUtilities.getErrorData(throwable, properties);
                string = RuntimeUtilities.f(throwable, properties);
                properties.setProperty("content", string);
                properties.setProperty("disposition", "inline");
            }
            if (WebUtils.sendHeader(httpServletRequest, httpServletResponse, properties, n2 = ErrorCodeHelper.isUnauthorizedCode((Throwable)throwable) ? 401 : (throwable instanceof PromptRequestWarning ? 200 : ("application/javascript; charset=utf-8" != string && ErrorCodeHelper.isForbiddenCode((Throwable)throwable) ? 403 : ("application/javascript; charset=utf-8" != string && ErrorCodeHelper.isNotFoundCode((Throwable)throwable) ? 404 : (throwable instanceof HttpFailedException ? ((HttpFailedException)throwable).getHttpStatusCode() : 500)))), byArray.length, string)) {
                outputStream.write(byArray);
                outputStream.flush();
            }
        }
        catch (Exception exception) {
            if (ServletErrorHandler.isClientAbort((Throwable)exception)) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Could not send engine error page");
                }
            }
            BaseUtils.warning("Could not send engine error page");
            BaseUtils.warning(exception);
        }
    }

    public static int readHtmlInt(byte[] data, int off) throws IllegalStateException {
        if (off + 4 > data.length) {
            throw new IllegalStateException("Invalid HTML data: length=" + data.length + " at " + off);
        }
        return data[off] & 0xFF | (data[off + 1] & 0xFF) << 8 | (data[off + 2] & 0xFF) << 16 | data[off + 3] << 24;
    }

    @JsonData
    private static class EngineProgress {
        private int progress;
        private i state;
        @JsonExcludeNull
        private String error;

        private EngineProgress() {
        }
    }
}

