/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File axU;
    private static Hashtable<String, Object> bun;
    private static long buo;
    private static long bup;
    private static int buq;
    private static int bur;
    private static int bus;
    private static volatile int but;
    private static volatile int buu;
    private static Set<Integer> buv;
    private static Set<String> buw;
    private static Set<String> bux;
    private static double buy;
    private static int buz;
    private static int buA;
    private static double buB;
    private static double buC;
    private static int buD;
    private static int buE;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.NL();
        ++buq;
    }

    public static void incReportRequest() {
        ++bur;
    }

    public static void incRenderedReports() {
        ++bus;
        buu = Math.max(buu, ++but);
    }

    public static void decRenderedReports() {
        --but;
    }

    public static int getCurrentRenderingReports() {
        return but;
    }

    public static int getMaxRenderingReports() {
        return buu;
    }

    public static void countReportTemplates(URL reportUrl) {
        buv.add(reportUrl.hashCode());
    }

    public static void countClientLanguages(Locale locale) {
        buw.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        bux.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        buy += (double)pages;
        ++buz;
        buA = Math.max(buA, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        buB += (double)fetchedRecord;
        buC += (double)discardedRecords;
        buD = Math.max(buD, fetchedRecord);
        buE = Math.max(buE, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = bun.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void NL() {
        long l2 = System.currentTimeMillis();
        if (l2 > buo) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= buo) return;
                Accumulator.a(bun, "");
                Accumulator.save();
                buq = 0;
                bur = 0;
                bus = 0;
                buy = 0.0;
                buA = 0;
                buz = 0;
                buB = 0.0;
                buD = 0;
                buC = 0.0;
                buE = 0;
                buv.clear();
                buw.clear();
                bux.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= bup) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= bup) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (axU == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        bun.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(buq, hashtable, "Total Requests" + string);
        Accumulator.a(bur, hashtable, "Report Requests" + string);
        Accumulator.a(bus, hashtable, "Rendered Reports" + string);
        Accumulator.a(buy, hashtable, "Total Page Count" + string);
        Accumulator.a(buA, hashtable, "Maximal Page Count" + string);
        Accumulator.a(buB, hashtable, "Total fetched Records" + string);
        Accumulator.a(buD, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(buC, hashtable, "Total discarded Records" + string);
        Accumulator.a(buE, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(buv.size(), hashtable, "Report Templates");
            Accumulator.a(buw.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", buw);
            Accumulator.a(bux.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", bux);
            Accumulator.a(buy / (double)buz, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, buv);
            hashtable.put("Client Languages" + string, buw);
            hashtable.put("Report Formats" + string, bux);
            hashtable.put("Average Page Count" + string, buz);
        }
        hashtable.put("Next Day", buo);
    }

    private static Hashtable<String, Object> NM() {
        Hashtable<String, Object> hashtable = bun = new Hashtable<String, Object>();
        try {
            axU = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(axU));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    bun = hashtable;
                } else {
                    hashtable = bun;
                }
                buq = (int)Accumulator.dH("Total Requests");
                bur = (int)Accumulator.dH("Report Requests");
                bus = (int)Accumulator.dH("Rendered Reports");
                buy = Accumulator.dH("Total Page Count");
                buA = (int)Accumulator.dH("Maximal Page Count");
                buz = (int)Accumulator.dH("Average Page Count");
                buB = Accumulator.dH("Total fetched Records");
                buD = (int)Accumulator.dH("Maximal fetched Records");
                buC = Accumulator.dH("Total discarded Records");
                buE = (int)Accumulator.dH("Maximal discarded Records");
                buv = Accumulator.dI("Report Templates");
                buw = Accumulator.dI("Client Languages");
                bux = Accumulator.dI("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.NN();
                    buo = l2;
                    Accumulator.NL();
                }
            }
            catch (Throwable throwable) {
                bun = hashtable;
                buv = Collections.synchronizedSet(new HashSet());
                buw = Collections.synchronizedSet(new HashSet());
                bux = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.NN();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            buv = Collections.synchronizedSet(new HashSet());
            buw = Collections.synchronizedSet(new HashSet());
            bux = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void NN() {
        Date date = new Date();
        bup = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        buo = date.getTime();
    }

    private static synchronized void save() {
        if (axU == null) {
            return;
        }
        Accumulator.NN();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(axU));
            objectOutputStream.writeObject(bun);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dH(String string) {
        Number number = (Number)bun.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dI(String string) {
        Set set = (Set)bun.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, d2);
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, d4);
        }
    }

    static {
        bun = Accumulator.NM();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

