/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.svg;

import com.inet.annotations.InternalApi;
import com.inet.graphics.GraphicsBase;
import com.inet.report.renderer.svg.a;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;

@InternalApi
public class SvgGraphics
extends GraphicsBase {
    private final a bor;
    private OutputStream bos;

    public SvgGraphics(float width, float height, float scale) {
        this.bor = new a(width, height, scale);
    }

    public SvgGraphics(float width, float height, float scale, OutputStream target) {
        this(width, height, scale);
        this.bos = target;
    }

    public void writeTo(OutputStream output) throws IOException {
        this.bor.writeTo(output);
    }

    public void dispose() {
        this.bor.dispose();
        OutputStream outputStream = this.bos;
        this.bos = null;
        if (outputStream != null) {
            try {
                this.writeTo(outputStream);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected void setTransformImpl(AffineTransform tx) {
    }

    protected void transformImpl(AffineTransform tx) {
    }

    public void draw(Shape s2) {
        this.bor.a(this.getInternalTransform(), this.getClip());
        this.bor.a(s2, this.getPaint(), this.getStroke());
    }

    public void drawRect(int x2, int y2, int width, int height) {
        Rectangle rectangle = new Rectangle(x2, y2, width, height);
        this.draw(rectangle);
    }

    public void drawString(String str, int x2, int y2) {
        this.drawString(str, (float)x2, (float)y2);
    }

    public void drawString(String str, float x2, float y2) {
        this.bor.a(this.getInternalTransform(), this.getClip());
        this.bor.a(str, x2, y2, this.getFont(), this.getPaint());
    }

    public void drawString(AttributedCharacterIterator iterator, int x2, int y2) {
        this.drawString(iterator, (float)x2, (float)y2);
    }

    public void drawString(AttributedCharacterIterator iterator, float x2, float y2) {
        this.bor.a(this.getInternalTransform(), this.getClip());
        this.bor.a(iterator, x2, y2, this.getPaint());
    }

    public void drawGlyphVector(GlyphVector g2, float x2, float y2) {
        this.fill(g2.getOutline(x2, y2));
    }

    public void fill(Shape shape) {
        this.bor.a(this.getInternalTransform(), this.getClip());
        this.bor.a(shape, this.getPaint());
    }

    public Graphics create() {
        try {
            SvgGraphics svgGraphics = (SvgGraphics)((Object)this.clone());
            return svgGraphics;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    public void copyArea(int x2, int y2, int width, int height, int dx, int dy) {
        SvgGraphics.notSupported((String)"copyArea(int,int,int,int,int,int)");
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        int n2 = img.getWidth(obs);
        int n3 = img.getHeight(obs);
        if (n2 == -1 || n3 == -1) {
            return false;
        }
        AffineTransform affineTransform = this.getTransform();
        affineTransform.concatenate(xform);
        this.bor.a(affineTransform, this.getClip());
        this.bor.f(img, 0, 0, n2, n3);
        return true;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x2, int y2) {
        this.drawImage((Image)op.filter(img, null), x2, y2, null);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage bufferedImage = this.c(img);
        this.drawImage(bufferedImage, xform, null);
    }

    private BufferedImage c(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String[] stringArray = renderedImage.getPropertyNames();
        if (stringArray != null) {
            for (String string : stringArray) {
                hashtable.put(string, renderedImage.getProperty(string));
            }
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), hashtable);
        renderedImage.copyData(writableRaster);
        return bufferedImage;
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    public boolean drawImage(Image img, int x2, int y2, ImageObserver observer) {
        Color color = null;
        return this.drawImage(img, x2, y2, color, observer);
    }

    public boolean drawImage(Image img, int x2, int y2, int width, int height, ImageObserver observer) {
        Color color = null;
        return this.drawImage(img, x2, y2, width, height, color, observer);
    }

    public boolean drawImage(Image img, int x2, int y2, Color bgcolor, ImageObserver observer) {
        int n2 = img.getWidth(observer);
        int n3 = img.getHeight(observer);
        return this.drawImage(img, x2, y2, n2, n3, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x2, int y2, int width, int height, Color bgcolor, ImageObserver observer) {
        this.bor.a(this.getInternalTransform(), this.getClip());
        if (width == -1 || height == -1) {
            return false;
        }
        if (bgcolor != null) {
            this.bor.a(new Rectangle(x2, y2, width, height), bgcolor);
        }
        this.bor.f(img, x2, y2, width, height);
        return true;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img.getWidth(observer) == -1 || img.getHeight(observer) == -1) {
            return false;
        }
        int n2 = sx2 - sx1;
        int n3 = sy2 - sy1;
        int n4 = dx2 - dx1;
        int n5 = dy2 - dy1;
        BufferedImage bufferedImage = this.e(img, sx1, sy1, n2, n3);
        return this.drawImage(bufferedImage, dx1, dy1, n4, n5, bgcolor, observer);
    }

    private BufferedImage e(Image image, int n2, int n3, int n4, int n5) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getSubimage(n2, n3, n4, n5);
        }
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, n6, n7, null);
        graphics2D.dispose();
        return bufferedImage.getSubimage(n2, n3, n4, n5);
    }
}

