/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import com.inet.report.renderer.pdf.l;
import com.inet.report.renderer.pdf.m;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@InternalApi
public class PDFConfig {
    private static final ConfigValue<Boolean> aUZ = new ConfigValue(ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS);
    private static final ConfigValue<Boolean> aVa = new ConfigValue(ConfigKey.TAGGED_PDF);
    private boolean aUC = (Boolean)aUZ.get();
    private boolean aVb;
    private boolean aVc;
    private boolean aVd = (Boolean)aVa.get();
    private l aVe;
    private m aVf;

    public boolean isNoTransparency() {
        return this.aVb;
    }

    public void setPdfA(@Nullable l pdfA) {
        this.aVe = pdfA;
        if (pdfA != null) {
            this.aUC = true;
            if (pdfA == l.aWG) {
                this.aVb = true;
            }
        }
    }

    @Nullable
    public l getPdfA() {
        return this.aVe;
    }

    public void setPdfUA(@Nullable m pdfUA) {
        this.aVf = pdfUA;
        if (pdfUA != null) {
            this.aUC = true;
            this.aVd = true;
        }
    }

    @Nullable
    public m getPdfUA() {
        return this.aVf;
    }

    public void setLinear(boolean linear) {
        this.aVc = linear;
    }

    public boolean isLinear() {
        return this.aVc;
    }

    public boolean isSignatureEnabled() {
        return false;
    }

    public boolean isReplaceMissingChars() {
        return true;
    }

    public boolean isCompression() {
        return false;
    }

    public boolean isMapAdobeFonts() {
        return true;
    }

    public int getAsianEncodingCodePage() {
        return 932;
    }

    public void setCreateStructure(boolean setStructure) {
        this.aVd = setStructure;
    }

    public boolean isCreateStructure() {
        return this.aVd;
    }

    public boolean isReplaceNotEmbeddedFonts() {
        return this.aUC;
    }

    @Nullable
    public List<String> getListOfPreferredSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SERIF_FONT_LIST.getKey(), ConfigKey.PDF_SERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredSansSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SANSSERIF_FONT_LIST.getKey(), ConfigKey.PDF_SANSSERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredMonospacedFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_MONOSPACED_FONT_LIST.getKey(), ConfigKey.PDF_MONOSPACED_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }
}

